/*
 * Decompiled with CFR 0.152.
 */
package cryptix.jce.provider.asn;

import cryptix.jce.provider.asn.AsnInputStream;
import cryptix.jce.provider.asn.AsnObject;
import cryptix.jce.provider.asn.AsnOutputStream;
import java.io.IOException;

public final class AsnObjectId
extends AsnObject {
    private static final int[] _rsaEncryption = new int[]{1, 2, 840, 113549, 1, 1, 1};
    private static final int[] _md4WithRSAEncryption = new int[]{1, 2, 840, 113549, 1, 1, 3};
    private static final int[] _md5WithRSAEncryption = new int[]{1, 2, 840, 113549, 1, 1, 4};
    private static final int[] _sha1WithRSAEncryption = new int[]{1, 2, 840, 113549, 1, 1, 5};
    private static final int[] _rsaOAEPEncryptionSET = new int[]{1, 2, 840, 113549, 1, 1, 6};
    private static final int[] _id_hmacWithSHA1 = new int[]{1, 2, 840, 113549, 2, 7};
    private static final int[] _rc2_CBC = new int[]{1, 2, 840, 113549, 3, 2};
    private static final int[] _des_EDE3_CBC = new int[]{1, 2, 840, 113549, 3, 7};
    private static final int[] _rc5_CBC_PAD = new int[]{1, 2, 840, 113549, 3, 9};
    private static final int[] _pbeWithMD2AndDES_CBC = new int[]{1, 2, 840, 113549, 1, 5, 1};
    private static final int[] _pbeWithMD5AndDES_CBC = new int[]{1, 2, 840, 113549, 1, 5, 3};
    private static final int[] _pbeWithMD2AndRC2_CBC = new int[]{1, 2, 840, 113549, 1, 5, 4};
    private static final int[] _pbeWithMD5AndRC2_CBC = new int[]{1, 2, 840, 113549, 1, 5, 6};
    private static final int[] _pbeWithSHA1AndDES_CBC = new int[]{1, 2, 840, 113549, 1, 5, 10};
    private static final int[] _pbeWithSHA1AndRC2_CBC = new int[]{1, 2, 840, 113549, 1, 5, 11};
    private static final int[] _id_PBKDF2 = new int[]{1, 2, 840, 113549, 1, 5, 12};
    private static final int[] _id_PBES2 = new int[]{1, 2, 840, 113549, 1, 5, 13};
    private static final int[] _id_PBMAC1 = new int[]{1, 2, 840, 113549, 1, 5, 14};
    public static final AsnObjectId OID_rsaEncryption = new AsnObjectId(_rsaEncryption);
    public static final AsnObjectId OID_md5WithRSAEncryption = new AsnObjectId(_md5WithRSAEncryption);
    private final int[] components;

    public AsnObjectId(AsnInputStream asnInputStream) throws IOException {
        super((byte)6);
        int n = asnInputStream.readLength();
        if (n < 2) {
            throw new IOException("Invalid OBJECT_ID.");
        }
        byte[] byArray = asnInputStream.readBytes(n);
        this.components = AsnObjectId.decodePayload(byArray);
    }

    public AsnObjectId(int[] nArray) {
        super((byte)6);
        if (nArray.length < 2) {
            throw new IllegalArgumentException("Less than 2 components.");
        }
        if (nArray[0] < 0 || nArray[0] > 2) {
            throw new IllegalArgumentException("First comp must be 0, 1 or 2.");
        }
        if (nArray[1] >= nArray[0] * 40) {
            throw new IllegalArgumentException("Scnd comp >= (First comp*40).");
        }
        int n = 0;
        while (n < nArray.length) {
            if (nArray[n] < 0) {
                throw new IllegalArgumentException("Negative comp (" + n + ").");
            }
            ++n;
        }
        this.components = (int[])nArray.clone();
    }

    private static int[] decodePayload(byte[] byArray) {
        int n = 2;
        int n2 = 1;
        while (n2 < byArray.length) {
            if ((byArray[n2] & 0x80) == 0) {
                ++n;
            }
            ++n2;
        }
        int[] nArray = new int[n];
        nArray[0] = byArray[0] / 40;
        nArray[1] = byArray[0] % 40;
        int n3 = 1;
        int n4 = 2;
        while (n4 < nArray.length) {
            byte by;
            int n5 = 0;
            do {
                by = byArray[n3++];
                n5 = n5 << 7 | by & 0x7F;
            } while ((by & 0x80) == 128);
            nArray[n4] = n5;
            ++n4;
        }
        return nArray;
    }

    protected void encodePayload(AsnOutputStream asnOutputStream) throws IOException {
        asnOutputStream.writeByte((byte)(40 * this.components[0] + this.components[1]));
        int n = 2;
        while (n < this.components.length) {
            this.writeComponent(asnOutputStream, this.components[n]);
            ++n;
        }
    }

    private static int getEncodedComponentLen(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("c: < 0");
        }
        if (n <= 127) {
            return 1;
        }
        if (n <= 16383) {
            return 2;
        }
        if (n <= 0x1FFFFF) {
            return 3;
        }
        if (n <= 0xFFFFFFF) {
            return 4;
        }
        return 5;
    }

    protected int getEncodedLengthOfPayload(AsnOutputStream asnOutputStream) {
        int n = 1;
        int n2 = 2;
        while (n2 < this.components.length) {
            n += AsnObjectId.getEncodedComponentLen(this.components[n2]);
            ++n2;
        }
        return n;
    }

    public static void main(String[] stringArray) throws Exception {
        int[] nArray = new int[]{1, 2, 840};
        AsnObjectId asnObjectId = new AsnObjectId(nArray);
        AsnOutputStream asnOutputStream = new AsnOutputStream();
        asnOutputStream.write(asnObjectId);
        byte[] byArray = asnOutputStream.toByteArray();
        AsnInputStream asnInputStream = new AsnInputStream(byArray);
        AsnObject asnObject = asnInputStream.read();
        System.out.println(asnObject);
    }

    public String toString(String string) {
        String string2 = "OBJECT ID { ";
        int n = 0;
        while (n < this.components.length) {
            string2 = String.valueOf(string2) + this.components[n] + " ";
            ++n;
        }
        return String.valueOf(string) + string2 + "}";
    }

    private void writeComponent(AsnOutputStream asnOutputStream, int n) throws IOException {
        int n2 = AsnObjectId.getEncodedComponentLen(n);
        int n3 = n2 - 1;
        while (n3 > 0) {
            asnOutputStream.writeByte((byte)(n >>> n3 * 7 | 0x80));
            --n3;
        }
        asnOutputStream.writeByte((byte)(n & 0x7F));
    }
}

