/*
 * Decompiled with CFR 0.152.
 */
package cryptix.jce.provider.dsa;

import cryptix.jce.util.MPIOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPublicKey;

final class DSAPublicKeyOpenPGP
implements DSAPublicKey {
    private final BigInteger y;
    private final DSAParams params;

    DSAPublicKeyOpenPGP(BigInteger bigInteger, DSAParams dSAParams) {
        this.y = bigInteger;
        this.params = dSAParams;
    }

    public String getAlgorithm() {
        return "DSA";
    }

    public byte[] getEncoded() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            MPIOutputStream mPIOutputStream = new MPIOutputStream((OutputStream)byteArrayOutputStream);
            mPIOutputStream.write(this.params.getP());
            mPIOutputStream.write(this.params.getQ());
            mPIOutputStream.write(this.params.getG());
            mPIOutputStream.write(this.y);
            mPIOutputStream.flush();
            mPIOutputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new RuntimeException("PANIC");
        }
    }

    public String getFormat() {
        return "Cryptix";
    }

    public DSAParams getParams() {
        return this.params;
    }

    public BigInteger getY() {
        return this.y;
    }
}

