/*
 * Decompiled with CFR 0.152.
 */
package cryptix.jce.provider.key;

import cryptix.jce.provider.key.RawKeyGenerator;

public class DESKeyGenerator
extends RawKeyGenerator {
    public DESKeyGenerator() {
        super("DES", 56);
    }

    protected byte[] fixUp(byte[] byArray) {
        int n = 0;
        while (n < byArray.length) {
            byte by = byArray[n];
            byArray[n] = (byte)(by & 0xFE | (by >> 1 ^ by >> 2 ^ by >> 3 ^ by >> 4 ^ by >> 5 ^ by >> 6 ^ by >> 7) & 1);
            ++n;
        }
        return byArray;
    }

    protected boolean isValidSize(int n) {
        return n == 56;
    }

    protected boolean isWeak(byte[] byArray) {
        return this.isWeak(byArray, 0);
    }

    private boolean isWeak(byte[] byArray, int n) {
        int n2 = (byArray[n] & 0xFE) << 8 | byArray[n + 1] & 0xFE;
        int n3 = (byArray[n + 2] & 0xFE) << 8 | byArray[n + 3] & 0xFE;
        int n4 = (byArray[n + 4] & 0xFE) << 8 | byArray[n + 5] & 0xFE;
        int n5 = (byArray[n + 6] & 0xFE) << 8 | byArray[n + 7] & 0xFE;
        return !(n2 != 0 && n2 != 65278 || n3 != 0 && n3 != 65278 || n4 != 0 && n4 != 65278 || n5 != 0 && n5 != 65278);
    }

    protected int strengthToBits(int n) {
        if (n != 56) {
            throw new RuntimeException("Invalid strength value");
        }
        return 64;
    }
}

