/*
 * Decompiled with CFR 0.152.
 */
package cryptix.jce.provider.md;

import cryptix.jce.provider.md.PaddingMD;

public final class RIPEMD
extends PaddingMD {
    private static final int HASH_SIZE = 16;
    private int[] context = new int[4];
    private int[] savedContext = new int[4];
    private int[] X = new int[16];

    public RIPEMD() {
        super(16, 0);
        this.coreReset();
    }

    private RIPEMD(RIPEMD rIPEMD) {
        super(rIPEMD);
        this.context = (int[])rIPEMD.context.clone();
        this.savedContext = (int[])rIPEMD.savedContext.clone();
        this.X = (int[])rIPEMD.X.clone();
    }

    private int FF(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = n + (n2 & n3 | ~n2 & n4) + n5;
        return n7 << n6 | n7 >>> 32 - n6;
    }

    private int FFP(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = n + (n2 & n3 | ~n2 & n4) + n5 + 1352829926;
        return n7 << n6 | n7 >>> 32 - n6;
    }

    private int GG(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = n + (n2 & (n3 | n4) | n3 & n4) + n5 + 1518500249;
        return n7 << n6 | n7 >>> 32 - n6;
    }

    private int GGP(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = n + (n2 & (n3 | n4) | n3 & n4) + n5;
        return n7 << n6 | n7 >>> 32 - n6;
    }

    private int HH(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = n + (n2 ^ n3 ^ n4) + n5 + 1859775393;
        return n7 << n6 | n7 >>> 32 - n6;
    }

    private int HHP(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = n + (n2 ^ n3 ^ n4) + n5 + 1548603684;
        return n7 << n6 | n7 >>> 32 - n6;
    }

    public Object clone() {
        return new RIPEMD(this);
    }

    protected void coreDigest(byte[] byArray, int n) {
        int n2 = 0;
        while (n2 < 4) {
            int n3 = 0;
            while (n3 < 4) {
                byArray[n + (n2 * 4 + n3)] = (byte)(this.context[n2] >>> 8 * n3);
                ++n3;
            }
            ++n2;
        }
    }

    protected void coreReset() {
        this.context[0] = 1732584193;
        this.context[1] = -271733879;
        this.context[2] = -1732584194;
        this.context[3] = 271733878;
    }

    protected void coreUpdate(byte[] byArray, int n) {
        int n2 = 0;
        while (n2 < 16) {
            this.X[n2] = byArray[n++] & 0xFF | (byArray[n++] & 0xFF) << 8 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 24;
            ++n2;
        }
        int n3 = this.context[0];
        int n4 = this.context[1];
        int n5 = this.context[2];
        int n6 = this.context[3];
        n3 = this.FF(n3, n4, n5, n6, this.X[0], 11);
        n6 = this.FF(n6, n3, n4, n5, this.X[1], 14);
        n5 = this.FF(n5, n6, n3, n4, this.X[2], 15);
        n4 = this.FF(n4, n5, n6, n3, this.X[3], 12);
        n3 = this.FF(n3, n4, n5, n6, this.X[4], 5);
        n6 = this.FF(n6, n3, n4, n5, this.X[5], 8);
        n5 = this.FF(n5, n6, n3, n4, this.X[6], 7);
        n4 = this.FF(n4, n5, n6, n3, this.X[7], 9);
        n3 = this.FF(n3, n4, n5, n6, this.X[8], 11);
        n6 = this.FF(n6, n3, n4, n5, this.X[9], 13);
        n5 = this.FF(n5, n6, n3, n4, this.X[10], 14);
        n4 = this.FF(n4, n5, n6, n3, this.X[11], 15);
        n3 = this.FF(n3, n4, n5, n6, this.X[12], 6);
        n6 = this.FF(n6, n3, n4, n5, this.X[13], 7);
        n5 = this.FF(n5, n6, n3, n4, this.X[14], 9);
        n4 = this.FF(n4, n5, n6, n3, this.X[15], 8);
        n3 = this.GG(n3, n4, n5, n6, this.X[7], 7);
        n6 = this.GG(n6, n3, n4, n5, this.X[4], 6);
        n5 = this.GG(n5, n6, n3, n4, this.X[13], 8);
        n4 = this.GG(n4, n5, n6, n3, this.X[1], 13);
        n3 = this.GG(n3, n4, n5, n6, this.X[10], 11);
        n6 = this.GG(n6, n3, n4, n5, this.X[6], 9);
        n5 = this.GG(n5, n6, n3, n4, this.X[15], 7);
        n4 = this.GG(n4, n5, n6, n3, this.X[3], 15);
        n3 = this.GG(n3, n4, n5, n6, this.X[12], 7);
        n6 = this.GG(n6, n3, n4, n5, this.X[0], 12);
        n5 = this.GG(n5, n6, n3, n4, this.X[9], 15);
        n4 = this.GG(n4, n5, n6, n3, this.X[5], 9);
        n3 = this.GG(n3, n4, n5, n6, this.X[14], 7);
        n6 = this.GG(n6, n3, n4, n5, this.X[2], 11);
        n5 = this.GG(n5, n6, n3, n4, this.X[11], 13);
        n4 = this.GG(n4, n5, n6, n3, this.X[8], 12);
        n3 = this.HH(n3, n4, n5, n6, this.X[3], 11);
        n6 = this.HH(n6, n3, n4, n5, this.X[10], 13);
        n5 = this.HH(n5, n6, n3, n4, this.X[2], 14);
        n4 = this.HH(n4, n5, n6, n3, this.X[4], 7);
        n3 = this.HH(n3, n4, n5, n6, this.X[9], 14);
        n6 = this.HH(n6, n3, n4, n5, this.X[15], 9);
        n5 = this.HH(n5, n6, n3, n4, this.X[8], 13);
        n4 = this.HH(n4, n5, n6, n3, this.X[1], 15);
        n3 = this.HH(n3, n4, n5, n6, this.X[14], 6);
        n6 = this.HH(n6, n3, n4, n5, this.X[7], 8);
        n5 = this.HH(n5, n6, n3, n4, this.X[0], 13);
        n4 = this.HH(n4, n5, n6, n3, this.X[6], 6);
        n3 = this.HH(n3, n4, n5, n6, this.X[11], 12);
        n6 = this.HH(n6, n3, n4, n5, this.X[13], 5);
        n5 = this.HH(n5, n6, n3, n4, this.X[5], 7);
        n4 = this.HH(n4, n5, n6, n3, this.X[12], 5);
        this.savedContext[0] = n3;
        this.savedContext[1] = n4;
        this.savedContext[2] = n5;
        this.savedContext[3] = n6;
        n3 = this.context[0];
        n4 = this.context[1];
        n5 = this.context[2];
        n6 = this.context[3];
        n3 = this.FFP(n3, n4, n5, n6, this.X[0], 11);
        n6 = this.FFP(n6, n3, n4, n5, this.X[1], 14);
        n5 = this.FFP(n5, n6, n3, n4, this.X[2], 15);
        n4 = this.FFP(n4, n5, n6, n3, this.X[3], 12);
        n3 = this.FFP(n3, n4, n5, n6, this.X[4], 5);
        n6 = this.FFP(n6, n3, n4, n5, this.X[5], 8);
        n5 = this.FFP(n5, n6, n3, n4, this.X[6], 7);
        n4 = this.FFP(n4, n5, n6, n3, this.X[7], 9);
        n3 = this.FFP(n3, n4, n5, n6, this.X[8], 11);
        n6 = this.FFP(n6, n3, n4, n5, this.X[9], 13);
        n5 = this.FFP(n5, n6, n3, n4, this.X[10], 14);
        n4 = this.FFP(n4, n5, n6, n3, this.X[11], 15);
        n3 = this.FFP(n3, n4, n5, n6, this.X[12], 6);
        n6 = this.FFP(n6, n3, n4, n5, this.X[13], 7);
        n5 = this.FFP(n5, n6, n3, n4, this.X[14], 9);
        n4 = this.FFP(n4, n5, n6, n3, this.X[15], 8);
        n3 = this.GGP(n3, n4, n5, n6, this.X[7], 7);
        n6 = this.GGP(n6, n3, n4, n5, this.X[4], 6);
        n5 = this.GGP(n5, n6, n3, n4, this.X[13], 8);
        n4 = this.GGP(n4, n5, n6, n3, this.X[1], 13);
        n3 = this.GGP(n3, n4, n5, n6, this.X[10], 11);
        n6 = this.GGP(n6, n3, n4, n5, this.X[6], 9);
        n5 = this.GGP(n5, n6, n3, n4, this.X[15], 7);
        n4 = this.GGP(n4, n5, n6, n3, this.X[3], 15);
        n3 = this.GGP(n3, n4, n5, n6, this.X[12], 7);
        n6 = this.GGP(n6, n3, n4, n5, this.X[0], 12);
        n5 = this.GGP(n5, n6, n3, n4, this.X[9], 15);
        n4 = this.GGP(n4, n5, n6, n3, this.X[5], 9);
        n3 = this.GGP(n3, n4, n5, n6, this.X[14], 7);
        n6 = this.GGP(n6, n3, n4, n5, this.X[2], 11);
        n5 = this.GGP(n5, n6, n3, n4, this.X[11], 13);
        n4 = this.GGP(n4, n5, n6, n3, this.X[8], 12);
        n3 = this.HHP(n3, n4, n5, n6, this.X[3], 11);
        n6 = this.HHP(n6, n3, n4, n5, this.X[10], 13);
        n5 = this.HHP(n5, n6, n3, n4, this.X[2], 14);
        n4 = this.HHP(n4, n5, n6, n3, this.X[4], 7);
        n3 = this.HHP(n3, n4, n5, n6, this.X[9], 14);
        n6 = this.HHP(n6, n3, n4, n5, this.X[15], 9);
        n5 = this.HHP(n5, n6, n3, n4, this.X[8], 13);
        n4 = this.HHP(n4, n5, n6, n3, this.X[1], 15);
        n3 = this.HHP(n3, n4, n5, n6, this.X[14], 6);
        n6 = this.HHP(n6, n3, n4, n5, this.X[7], 8);
        n5 = this.HHP(n5, n6, n3, n4, this.X[0], 13);
        n4 = this.HHP(n4, n5, n6, n3, this.X[6], 6);
        n3 = this.HHP(n3, n4, n5, n6, this.X[11], 12);
        n6 = this.HHP(n6, n3, n4, n5, this.X[13], 5);
        n5 = this.HHP(n5, n6, n3, n4, this.X[5], 7);
        n4 = this.HHP(n4, n5, n6, n3, this.X[12], 5);
        n3 += this.savedContext[3];
        n4 += this.savedContext[0];
        n5 += this.savedContext[1];
        n6 += this.savedContext[2];
        this.context[1] = n3 += this.context[2];
        this.context[2] = n4 += this.context[3];
        this.context[3] = n5 += this.context[0];
        this.context[0] = n6 += this.context[1];
    }
}

