/*
 * Decompiled with CFR 0.152.
 */
package cryptix.jce.provider.rsa;

import cryptix.jce.provider.asn.AsnAlgorithmId;
import cryptix.jce.provider.asn.AsnBitString;
import cryptix.jce.provider.asn.AsnInteger;
import cryptix.jce.provider.asn.AsnObjectId;
import cryptix.jce.provider.asn.AsnOutputStream;
import cryptix.jce.provider.asn.AsnSequence;
import java.io.IOException;
import java.math.BigInteger;
import java.security.interfaces.RSAPublicKey;

public final class RSAPublicKeyImpl
implements RSAPublicKey {
    private final BigInteger n;
    private final BigInteger e;

    public RSAPublicKeyImpl(BigInteger bigInteger, BigInteger bigInteger2) {
        this.n = bigInteger;
        this.e = bigInteger2;
    }

    public String getAlgorithm() {
        return "RSA";
    }

    public byte[] getEncoded() {
        try {
            AsnOutputStream asnOutputStream = new AsnOutputStream();
            asnOutputStream.write(new AsnSequence(new AsnInteger(this.n), new AsnInteger(this.e)));
            byte[] byArray = asnOutputStream.toByteArray();
            asnOutputStream = new AsnOutputStream();
            asnOutputStream.write(new AsnSequence(new AsnAlgorithmId(AsnObjectId.OID_rsaEncryption), new AsnBitString(byArray)));
            return asnOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new InternalError("PANIC: Unexpected exception during ASN encoding...");
        }
    }

    public String getFormat() {
        return "X.509";
    }

    public BigInteger getModulus() {
        return this.n;
    }

    public BigInteger getPublicExponent() {
        return this.e;
    }
}

