/*
 * Decompiled with CFR 0.152.
 */
package cryptix.jce.test;

import cryptix.jce.test.Test;
import cryptix.jce.test.Util;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;

abstract class CipherTest
extends Test {
    private static SecureRandom random = new SecureRandom();
    private final String alg;

    protected CipherTest(String string) {
        super(string);
        this.alg = string;
    }

    protected void testCipher(String[][] stringArray) throws Exception {
        this.testExistence(this.alg);
        this.testValuesECB(this.alg, stringArray);
        this.testKeyGenExistence(this.alg);
        this.testKeyGenWorks(this.alg);
    }

    protected void testExistence(String string) throws Exception {
        this.beginTest("Algorithm available as " + string);
        boolean bl = true;
        try {
            Cipher cipher = Cipher.getInstance(string, "CryptixCrypto");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            bl = false;
        }
        this.passIf(bl);
    }

    protected void testKeyGenExistence(String string) throws Exception {
        this.beginTest("KeyGenerator available");
        boolean bl = true;
        try {
            KeyGenerator keyGenerator = KeyGenerator.getInstance(string, "CryptixCrypto");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            bl = false;
        }
        this.passIf(bl);
    }

    protected void testKeyGenWorks(String string) throws Exception {
        boolean bl = true;
        this.beginTest("KeyGenerator works");
        try {
            KeyGenerator keyGenerator = KeyGenerator.getInstance(string, "CryptixCrypto");
            keyGenerator.init(random);
            Cipher cipher = Cipher.getInstance(String.valueOf(string) + "/ECB/None", "CryptixCrypto");
            int n = cipher.getBlockSize();
            byte[] byArray = new byte[n];
            int n2 = 0;
            while (n2 < byArray.length) {
                byArray[n2] = (byte)n2;
                ++n2;
            }
            int n3 = 0;
            while (n3 < 1000) {
                SecretKey secretKey = keyGenerator.generateKey();
                cipher.init(1, secretKey);
                byte[] byArray2 = cipher.doFinal(byArray);
                cipher.init(2, secretKey);
                byArray2 = cipher.doFinal(byArray2);
                bl = Util.areEqual(byArray2, byArray);
                if (bl) {
                    ++n3;
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            bl = false;
        }
        this.passIf(bl);
    }

    protected void testValuesCFB(String string, String[][] stringArray) throws Exception {
        this.beginTest("CFB Test Values (" + string + ")");
        boolean bl = true;
        try {
            int n = 0;
            while (n < stringArray.length) {
                byte[] byArray = Util.hexFromString(stringArray[n][0]);
                byte[] byArray2 = Util.hexFromString(stringArray[n][1]);
                byte[] byArray3 = Util.hexFromString(stringArray[n][2]);
                byte[] byArray4 = Util.hexFromString(stringArray[n][3]);
                IvParameterSpec ivParameterSpec = new IvParameterSpec(byArray2);
                Cipher cipher = Cipher.getInstance(string, "CryptixCrypto");
                cipher.init(1, (Key)new K(string, byArray), ivParameterSpec);
                byte[] byArray5 = cipher.doFinal(byArray3);
                cipher.init(2, (Key)new K(string, byArray), ivParameterSpec);
                byte[] byArray6 = cipher.doFinal(byArray4);
                if (!Util.areEqual(byArray4, byArray5) || !Util.areEqual(byArray3, byArray6)) {
                    bl = false;
                }
                ++n;
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            bl = false;
        }
        this.passIf(bl);
    }

    protected void testValuesECB(String string, String[][] stringArray) throws Exception {
        byte[] byArray = new byte[0xA00000];
        int n = 100000;
        this.beginTest("ECB Test Values");
        boolean bl = true;
        try {
            int n2 = 0;
            while (n2 < stringArray.length) {
                byte[] byArray2 = Util.hexFromString(stringArray[n2][0]);
                byte[] byArray3 = Util.hexFromString(stringArray[n2][1]);
                byte[] byArray4 = Util.hexFromString(stringArray[n2][2]);
                Cipher cipher = Cipher.getInstance(String.valueOf(string) + "/ECB/None", "CryptixCrypto");
                cipher.init(1, new K(string, byArray2));
                byte[] byArray5 = cipher.doFinal(byArray3);
                long l = System.currentTimeMillis();
                cipher.doFinal(byArray);
                long l2 = System.currentTimeMillis();
                double d = (double)(l2 - l) / 1000.0;
                double d2 = (double)byArray.length / 1024.0 / d;
                System.out.print("enc elapsed: " + d);
                System.out.println(", tp: " + d2);
                cipher.init(2, new K(string, byArray2));
                byte[] byArray6 = cipher.doFinal(byArray4);
                if (!Util.areEqual(byArray4, byArray5) || !Util.areEqual(byArray3, byArray6)) {
                    System.out.println(stringArray[n2][0]);
                    bl = false;
                }
                ++n2;
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            bl = false;
        }
        this.passIf(bl);
    }

    private class K
    implements Key {
        private final byte[] keyBytes;
        private final String alg;

        K(String string, byte[] byArray) {
            this.alg = string;
            this.keyBytes = byArray;
        }

        public String getAlgorithm() {
            return this.alg;
        }

        public byte[] getEncoded() {
            return (byte[])this.keyBytes.clone();
        }

        public String getFormat() {
            return "RAW";
        }
    }
}

