/*
 * Decompiled with CFR 0.152.
 */
package cryptix.jce.test;

import cryptix.jce.test.Test;
import java.security.AlgorithmParameters;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;

final class TestAlgorithmParameters
extends Test {
    private static final String name = "AlgorithmParameters";
    private Cipher c;
    private SecretKey sk;
    private String algo;
    private int KEY_SIZE;

    protected TestAlgorithmParameters() {
        super(name);
        this.algo = "DES";
        this.KEY_SIZE = 56;
    }

    protected TestAlgorithmParameters(String string, int n) {
        super(name);
        this.algo = string;
        this.KEY_SIZE = n;
    }

    protected void doIt() throws Exception {
        this.init();
        this.beginTest("test with parameters only AlgorithmParameters");
        this.passIf(this.test1());
        this.beginTest("test with parameters from Cipher");
        this.passIf(this.test2(this.c) && this.test3(this.c));
    }

    private void init() throws Exception {
        KeyGenerator keyGenerator = KeyGenerator.getInstance(this.algo);
        keyGenerator.init(this.KEY_SIZE);
        this.sk = keyGenerator.generateKey();
        this.c = Cipher.getInstance(String.valueOf(this.algo) + "/CBC/NONE");
        this.c.init(1, this.sk);
    }

    private boolean test1() throws Exception {
        byte[] byArray = new byte[8];
        new SecureRandom().nextBytes(byArray);
        AlgorithmParameters algorithmParameters = AlgorithmParameters.getInstance("DES");
        algorithmParameters.init(new IvParameterSpec(byArray));
        String string = algorithmParameters.getAlgorithm();
        String string2 = algorithmParameters.toString();
        String string3 = algorithmParameters.getProvider().getName();
        byte[] byArray2 = algorithmParameters.getEncoded();
        AlgorithmParameters algorithmParameters2 = AlgorithmParameters.getInstance(string, string3);
        algorithmParameters2.init(byArray2);
        return string.equals(algorithmParameters2.getAlgorithm()) && string2.equals(algorithmParameters2.toString()) && string3.equals(algorithmParameters2.getProvider().getName());
    }

    private boolean test2(Cipher cipher) throws Exception {
        AlgorithmParameters algorithmParameters = cipher.getParameters();
        String string = algorithmParameters.getAlgorithm();
        String string2 = algorithmParameters.toString();
        String string3 = algorithmParameters.getProvider().getName();
        byte[] byArray = algorithmParameters.getEncoded();
        AlgorithmParameters algorithmParameters2 = AlgorithmParameters.getInstance(this.algo);
        algorithmParameters2.init(byArray);
        return string.equals(algorithmParameters2.getAlgorithm()) && string2.equals(algorithmParameters2.toString()) && string3.equals(algorithmParameters2.getProvider().getName());
    }

    private boolean test3(Cipher cipher) throws Exception {
        byte[] byArray = cipher.getIV();
        AlgorithmParameters algorithmParameters = cipher.getParameters();
        String string = algorithmParameters.getAlgorithm();
        String string2 = algorithmParameters.toString();
        String string3 = algorithmParameters.getProvider().getName();
        AlgorithmParameters algorithmParameters2 = AlgorithmParameters.getInstance(this.algo);
        algorithmParameters2.init(new IvParameterSpec(byArray));
        return string.equals(algorithmParameters2.getAlgorithm()) && string2.equals(algorithmParameters2.toString()) && string3.equals(algorithmParameters2.getProvider().getName());
    }
}

