/*
 * Decompiled with CFR 0.152.
 */
package cryptix.jce.test;

import cryptix.jce.test.Test;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.Signature;

final class TestDSA
extends Test {
    private static SecureRandom random = new SecureRandom();
    private static final String NAME = "DSA";

    protected TestDSA() {
        super(NAME);
    }

    protected void doIt() throws Exception {
        this.testExistence(NAME);
    }

    protected void testExistence(String string) throws Exception {
        this.beginTest("Algorithm available as " + string);
        boolean bl = true;
        try {
            Signature signature = Signature.getInstance(string, "CryptixCrypto");
            Signature signature2 = Signature.getInstance(string, "SUN");
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(NAME);
            keyPairGenerator.initialize(1024);
            KeyPair keyPair = keyPairGenerator.genKeyPair();
            byte[] byArray = null;
            signature.initSign(keyPair.getPrivate());
            signature.update("jeroen".getBytes());
            byArray = signature.sign();
            int n = 1000;
            System.out.println("begin of num: " + n);
            long l = System.currentTimeMillis();
            int n2 = 0;
            while (n2 < n) {
                signature.initSign(keyPair.getPrivate());
                signature.update("jeroen".getBytes());
                signature.sign();
                ++n2;
            }
            long l2 = System.currentTimeMillis();
            System.out.println("mills/iter: " + (l2 - l) / (long)n);
            System.out.println("begin of num: " + n);
            l = System.currentTimeMillis();
            int n3 = 0;
            while (n3 < n) {
                signature.initVerify(keyPair.getPublic());
                signature.update("jeroen".getBytes());
                if (!signature.verify(byArray)) {
                    throw new RuntimeException();
                }
                ++n3;
            }
            l2 = System.currentTimeMillis();
            System.out.println("mills/iter: " + (l2 - l) / (long)n);
            signature2.initVerify(keyPair.getPublic());
            signature2.update("jeroen".getBytes());
            boolean bl2 = signature2.verify(byArray);
            System.out.println("res1: " + bl2);
            signature2.initVerify(keyPair.getPublic());
            signature2.update("jeroen".getBytes());
            boolean bl3 = signature2.verify(byArray);
            System.out.println("res2: " + bl3);
            signature2.initVerify(keyPair.getPublic());
            signature2.update("jeoen".getBytes());
            boolean bl4 = signature2.verify(byArray);
            System.out.println("res3: " + bl4);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            noSuchAlgorithmException.printStackTrace();
            bl = false;
        }
        this.passIf(bl);
    }
}

