/*
 * Decompiled with CFR 0.152.
 */
package cryptix.jce.test;

import cryptix.jce.test.Test;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyPairGeneratorSpi;
import java.security.SecureRandom;
import java.security.Signature;
import javax.crypto.Cipher;

class TestRSA
extends Test {
    private static SecureRandom random = new SecureRandom();

    TestRSA() {
        super("RSA");
    }

    protected void doIt() {
        int n = 50;
        int n2 = 0;
        while (n2 < n) {
            long l = System.currentTimeMillis();
            String string = "(pass " + n2 + "/" + n + ")";
            this.doItPrivate2(string);
            this.doItPrivate1(string);
            long l2 = (System.currentTimeMillis() - l) / 1000L;
            ++n2;
        }
    }

    private void doItPrivate1(String string) {
        this.beginTest("RSA Signing " + string);
        boolean bl = false;
        try {
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
            keyPairGenerator.initialize(768);
            KeyPair keyPair = ((KeyPairGeneratorSpi)keyPairGenerator).generateKeyPair();
            Signature signature = Signature.getInstance("SHA1withRSA");
            signature.initSign(keyPair.getPrivate());
            signature.update((byte)0);
            byte[] byArray = signature.sign();
            signature.initVerify(keyPair.getPublic());
            signature.update((byte)0);
            byArray[0] = ~byArray[0];
            bl = true;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        this.passIf(bl);
    }

    private void doItPrivate2(String string) {
        this.beginTest("RSA Crypting " + string);
        boolean bl = false;
        try {
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
            keyPairGenerator.initialize(768);
            KeyPair keyPair = ((KeyPairGeneratorSpi)keyPairGenerator).generateKeyPair();
            Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS#1");
            bl = true;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        this.passIf(bl);
    }
}

