/*
 * Decompiled with CFR 0.152.
 */
package cryptix.jce.test;

import cryptix.jce.test.Test;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyPairGeneratorSpi;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import javax.crypto.Cipher;

final class TestRSA_ECB_PKCS1
extends Test {
    private static final String name = "RSA_ECB_PKCS1";
    private Cipher c;
    private Cipher d;
    private final String s = "ThisIsASecretSecretMessageOfNull";
    private String algo;
    private int KEY_SIZE;

    protected TestRSA_ECB_PKCS1() {
        super(name);
        this.algo = "RSA";
        this.KEY_SIZE = 1024;
    }

    protected TestRSA_ECB_PKCS1(String string, int n) {
        super(name);
        this.algo = string;
        this.KEY_SIZE = n;
    }

    protected void doIt() throws Exception {
        this.beginTest("ECB with PKCS1");
        this.init();
        this.passIf(this.test(this.c, this.d, "ThisIsASecretSecretMessageOfNull"));
    }

    private void init() throws Exception {
        this.algo = "RSA";
        this.KEY_SIZE = 1024;
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(this.algo);
        keyPairGenerator.initialize(this.KEY_SIZE);
        KeyPair keyPair = ((KeyPairGeneratorSpi)keyPairGenerator).generateKeyPair();
        RSAPrivateKey rSAPrivateKey = (RSAPrivateKey)keyPair.getPrivate();
        RSAPublicKey rSAPublicKey = (RSAPublicKey)keyPair.getPublic();
        this.algo = String.valueOf(this.algo) + "/ECB/PKCS#1";
        this.c = Cipher.getInstance(this.algo);
        this.d = Cipher.getInstance(this.algo);
        this.c.init(1, rSAPublicKey);
        this.d.init(2, rSAPrivateKey);
    }

    private boolean test(Cipher cipher, Cipher cipher2, String string) throws Exception {
        byte[] byArray = string.getBytes();
        byte[] byArray2 = cipher2.doFinal(cipher.doFinal(byArray));
        return new String(byArray2).equals(string);
    }
}

