/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NullCipher;

public class CipherInputStream
extends FilterInputStream {
    private int bufBegin = 0;
    private int bufEnd = 0;
    private boolean isClosed = false;
    private Cipher c;
    private byte[] encBuf;
    private byte[] rawBuf = null;
    private InputStream is;

    protected CipherInputStream(InputStream inputStream) {
        this(inputStream, new NullCipher());
    }

    public CipherInputStream(InputStream inputStream, Cipher cipher) {
        super(inputStream);
        this.c = cipher;
        this.is = inputStream;
        this.encBuf = new byte[1024];
    }

    public int available() throws IOException {
        return this.bufEnd - this.bufBegin;
    }

    public void close() throws IOException {
        this.is.close();
        this.doClose();
    }

    private int doBuffering() throws IOException {
        if (this.isClosed) {
            return -1;
        }
        int n = this.is.read(this.encBuf);
        if (n < 0) {
            this.doClose();
        } else {
            try {
                this.rawBuf = this.c.update(this.encBuf, 0, n);
            }
            catch (IllegalStateException illegalStateException) {
                throw new RuntimeException("PANIC: Internal error!");
            }
        }
        n = this.rawBuf.length;
        this.bufBegin = 0;
        this.bufEnd = n;
        return n;
    }

    private void doClose() {
        this.isClosed = true;
        try {
            this.rawBuf = this.c.doFinal();
        }
        catch (IllegalStateException illegalStateException) {
            throw new RuntimeException("PANIC: Internal error!");
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            throw new RuntimeException("PANIC: Internal error!");
        }
        catch (BadPaddingException badPaddingException) {
            throw new RuntimeException("PANIC: Internal error!");
        }
    }

    public boolean markSupported() {
        return false;
    }

    public int read() throws IOException {
        if (this.bufBegin >= this.bufEnd && this.doBuffering() == -1) {
            return -1;
        }
        return this.rawBuf[this.bufBegin++] & 0xFF;
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.bufBegin >= this.bufEnd && this.doBuffering() == -1) {
            return -1;
        }
        if (n2 <= 0) {
            return 0;
        }
        int n3 = this.bufEnd - this.bufBegin;
        if (n3 > n2) {
            n3 = n2;
        }
        if (byArray != null) {
            int n4 = 0;
            while (n4 < n3) {
                byArray[n + n4] = this.rawBuf[this.bufBegin + n4];
                ++n4;
            }
        }
        this.bufBegin += n3;
        return n3;
    }

    public long skip(long l) throws IOException {
        long l2 = this.bufEnd - this.bufBegin;
        if (l2 <= 0L || l <= 0L) {
            return 0L;
        }
        if (l2 < l) {
            l2 = l;
        }
        this.bufBegin += (int)l2;
        return l2;
    }
}

