/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto;

import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.ExemptionMechanismException;
import javax.crypto.ExemptionMechanismSpi;
import javax.crypto.ShortBufferException;
import javax.crypto.Support;

public class ExemptionMechanism {
    private final ExemptionMechanismSpi spi;
    private final Provider provider;
    private final String mechanism;
    private boolean isInitialized = false;

    protected ExemptionMechanism(ExemptionMechanismSpi exemptionMechanismSpi, Provider provider, String string) {
        this.spi = exemptionMechanismSpi;
        this.provider = provider;
        this.mechanism = string;
    }

    protected void finalize() {
        throw new RuntimeException("Method not yet implemented!");
    }

    public final byte[] genExemptionBlob() throws IllegalStateException, ExemptionMechanismException {
        if (!this.isInitialized) {
            throw new IllegalStateException("ExemptionMechanism not initialized!");
        }
        return this.spi.engineGenExemptionBlob();
    }

    public final int genExemptionBlob(byte[] byArray) throws IllegalStateException, ShortBufferException, ExemptionMechanismException {
        if (!this.isInitialized) {
            throw new IllegalStateException("ExemptionMechanism not initialized!");
        }
        if (byArray.length < this.getOutputSize(0)) {
            throw new ShortBufferException("Buffer to short!");
        }
        return this.spi.engineGenExemptionBlob(byArray, 0);
    }

    public final int genExemptionBlob(byte[] byArray, int n) throws IllegalStateException, ShortBufferException, ExemptionMechanismException {
        if (!this.isInitialized) {
            throw new IllegalStateException("ExemptionMechanism not initialized!");
        }
        if (byArray.length - n < this.getOutputSize(0)) {
            throw new ShortBufferException("Buffer to short!");
        }
        return this.spi.engineGenExemptionBlob(byArray, n);
    }

    public static final ExemptionMechanism getInstance(String string) throws NoSuchAlgorithmException {
        Object[] objectArray = Support.getImplementation("ExemptionMechanism", string);
        return new ExemptionMechanism((ExemptionMechanismSpi)objectArray[0], (Provider)objectArray[1], string);
    }

    public static final ExemptionMechanism getInstance(String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException {
        Object[] objectArray = Support.getImplementation("ExemptionMechanism", string, string2);
        return new ExemptionMechanism((ExemptionMechanismSpi)objectArray[0], (Provider)objectArray[1], string);
    }

    public final String getName() {
        return this.mechanism;
    }

    public final int getOutputSize(int n) throws IllegalStateException {
        if (!this.isInitialized) {
            throw new IllegalStateException("ExemptionMechanism not initialized!");
        }
        return this.spi.engineGetOutputSize(n);
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public final void init(Key key) throws InvalidKeyException, ExemptionMechanismException {
        this.spi.engineInit(key);
        this.isInitialized = true;
    }

    public final void init(Key key, AlgorithmParameters algorithmParameters) throws InvalidKeyException, InvalidAlgorithmParameterException, ExemptionMechanismException {
        this.spi.engineInit(key, algorithmParameters);
        this.isInitialized = true;
    }

    public final void init(Key key, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidKeyException, InvalidAlgorithmParameterException, ExemptionMechanismException {
        this.spi.engineInit(key, algorithmParameterSpec);
        this.isInitialized = true;
    }

    public final boolean isCryptoAllowed(Key key) throws ExemptionMechanismException {
        throw new RuntimeException("Method not yet implemented");
    }
}

