/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto.spec;

import java.security.InvalidKeyException;
import java.security.spec.KeySpec;

public class DESKeySpec
implements KeySpec {
    public static final int DES_KEY_LEN = 8;
    private final byte[] key;

    public DESKeySpec(byte[] byArray) throws InvalidKeyException {
        this(byArray, 0);
    }

    public DESKeySpec(byte[] byArray, int n) throws InvalidKeyException {
        if (byArray.length - n < 8) {
            throw new InvalidKeyException("Wrong size");
        }
        this.key = new byte[8];
        System.arraycopy(byArray, n, this.key, 0, 8);
    }

    public byte[] getKey() {
        return (byte[])this.key.clone();
    }

    public static boolean isParityAdjusted(byte[] byArray, int n) throws InvalidKeyException {
        throw new RuntimeException("Method not yet implemented.");
    }

    public static boolean isWeak(byte[] byArray, int n) throws InvalidKeyException {
        int n2 = (byArray[n] & 0xFE) << 8 | byArray[n + 1] & 0xFE;
        int n3 = (byArray[n + 2] & 0xFE) << 8 | byArray[n + 3] & 0xFE;
        int n4 = (byArray[n + 4] & 0xFE) << 8 | byArray[n + 5] & 0xFE;
        int n5 = (byArray[n + 6] & 0xFE) << 8 | byArray[n + 7] & 0xFE;
        return !(n2 != 0 && n2 != 65278 || n3 != 0 && n3 != 65278 || n4 != 0 && n4 != 65278 || n5 != 0 && n5 != 65278);
    }
}

