/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto.spec;

import java.security.spec.AlgorithmParameterSpec;

public class RC2ParameterSpec
implements AlgorithmParameterSpec {
    private final int bits;
    private final byte[] iv;

    public RC2ParameterSpec(int n) {
        this.bits = n;
        this.iv = null;
    }

    public RC2ParameterSpec(int n, byte[] byArray) {
        this.bits = n;
        this.iv = byArray;
    }

    public RC2ParameterSpec(int n, byte[] byArray, int n2) {
        this.bits = n;
        this.iv = new byte[8];
        System.arraycopy(byArray, n2, this.iv, 0, this.iv.length);
    }

    public boolean equals(Object object) {
        if (!(object instanceof RC2ParameterSpec)) {
            return false;
        }
        return this.bits == ((RC2ParameterSpec)object).getEffectiveKeyBits() && this.iv == null && ((RC2ParameterSpec)object).getIV() == null;
    }

    public int getEffectiveKeyBits() {
        return this.bits;
    }

    public byte[] getIV() {
        return (byte[])this.iv.clone();
    }

    public int hashCode() {
        throw new RuntimeException("NYI: method not implemented!");
    }
}

