/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto.spec;

import cryptix.jce.util.Util;
import java.security.spec.AlgorithmParameterSpec;

public class RC5ParameterSpec
implements AlgorithmParameterSpec {
    private final int version;
    private final int rounds;
    private final int wordSize;
    private final byte[] iv;

    public RC5ParameterSpec(int n, int n2, int n3) {
        this.version = n;
        this.rounds = n2;
        this.wordSize = n3;
        this.iv = null;
    }

    public RC5ParameterSpec(int n, int n2, int n3, byte[] byArray) {
        this.version = n;
        this.rounds = n2;
        this.wordSize = n3;
        this.iv = (byte[])byArray.clone();
    }

    public RC5ParameterSpec(int n, int n2, int n3, byte[] byArray, int n4) {
        this.version = n;
        this.rounds = n2;
        this.wordSize = n3;
        this.iv = new byte[2 * (n3 / 8)];
        System.arraycopy(byArray, n4, this.iv, 0, this.iv.length);
    }

    public boolean equals(Object object) {
        if (!(object instanceof RC5ParameterSpec)) {
            return false;
        }
        RC5ParameterSpec rC5ParameterSpec = (RC5ParameterSpec)object;
        return this.version == rC5ParameterSpec.version && this.rounds == rC5ParameterSpec.rounds && this.wordSize == rC5ParameterSpec.wordSize && Util.equals(this.iv, rC5ParameterSpec.iv);
    }

    public byte[] getIV() {
        return this.iv == null ? this.iv : (byte[])this.iv.clone();
    }

    public int getRounds() {
        return this.rounds;
    }

    public int getVersion() {
        return this.version;
    }

    public int getWordSize() {
        return this.wordSize;
    }

    public int hashCode() {
        return 0;
    }
}

