/*
 * Decompiled with CFR 0.152.
 */
package java.security.cert;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;

public abstract class Certificate
implements Serializable {
    private final String type;
    private transient int cachedHashCode = -1;

    protected Certificate(String string) {
        this.type = string;
    }

    public boolean equals(Object object) {
        try {
            byte[] byArray;
            if (!(object instanceof Certificate)) {
                return false;
            }
            Certificate certificate = (Certificate)object;
            if (this.hashCode() != certificate.hashCode()) {
                return false;
            }
            byte[] byArray2 = this.getEncoded();
            if (byArray2.length != (byArray = certificate.getEncoded()).length) {
                return false;
            }
            int n = 0;
            while (n < byArray2.length) {
                if (byArray2[n] != byArray[n]) {
                    return false;
                }
                ++n;
            }
            return true;
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
        catch (CertificateEncodingException certificateEncodingException) {
            return false;
        }
    }

    public abstract byte[] getEncoded() throws CertificateEncodingException;

    public abstract PublicKey getPublicKey();

    public final String getType() {
        return this.type;
    }

    public int hashCode() {
        if (this.cachedHashCode != -1) {
            return this.cachedHashCode;
        }
        try {
            byte[] byArray = this.getEncoded();
            int n = 0;
            int n2 = 0;
            while (n2 < byArray.length) {
                n = (n << 7 | n >>> 25) ^ byArray[n2] & 0xFF;
                ++n2;
            }
            this.cachedHashCode = n;
            return this.cachedHashCode;
        }
        catch (NullPointerException nullPointerException) {
            return 0;
        }
        catch (CertificateEncodingException certificateEncodingException) {
            return 0;
        }
    }

    public abstract String toString();

    public abstract void verify(PublicKey var1) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException;

    public abstract void verify(PublicKey var1, String var2) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException;

    protected Object writeReplace() throws ObjectStreamException {
        throw new RuntimeException("NYI");
    }
}

