/*
 * Decompiled with CFR 0.152.
 */
package java.security.cert;

import java.io.InputStream;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactorySpi;
import java.security.cert.Support;

public class CertificateFactory {
    private final CertificateFactorySpi spi;

    protected CertificateFactory(CertificateFactorySpi certificateFactorySpi, Provider provider, String string) {
        this.spi = certificateFactorySpi;
    }

    public final Certificate generateCertificate(InputStream inputStream) throws CertificateException {
        return this.spi.engineGenerateCertificate(inputStream);
    }

    public static CertificateFactory getInstance(String string) throws CertificateException {
        Object[] objectArray = Support.getImplementation("CertificateFactory", string);
        return new CertificateFactory((CertificateFactorySpi)objectArray[0], (Provider)objectArray[1], string);
    }

    public static final CertificateFactory getInstance(String string, String string2) throws CertificateException, NoSuchProviderException {
        Object[] objectArray = Support.getImplementation("CertificateFactory", string, string2);
        return new CertificateFactory((CertificateFactorySpi)objectArray[0], (Provider)objectArray[1], string);
    }
}

