/* $Id: TestMD5.java,v 1.2 2000/07/28 20:06:11 gelderen Exp $
 *
 * Copyright (C) 1995-1999 The Cryptix Foundation Limited.
 * All rights reserved.
 *
 * Use, modification, copying and distribution of this software is subject
 * the terms and conditions of the Cryptix General Licence. You should have
 * received a copy of the Cryptix General Licence along with this library;
 * if not, you can download a copy from http://www.cryptix.org/ .
 */
package cryptix.jce.test;


/*package*/ final class TestRIPEMD extends MessageDigestTest {

    private static final String NAME="RIPEMD";


    String[][] TEST_VALUES = {
        //    data,        md
        //..................................................................
        {"",               "9f73aa9b372a9dacfb86a6108852e2d9"}, // A.5 1
        {"a",              "486f74f790bc95ef7963cd2382b4bbc9"},
        {"abc",            "3f14bad4c2f9b0ea805e5485d3d6882d"}, // A.5 3
        {"message digest", "5f5c7ebe1abbb3c7036482942d5f9d49"}, // A.5 4
        {"abcdefghijklmnopqrstuvwxyz",
                           "ff6e1547494251a1cca6f005a6eaa2b4"}, // A.5 5
        {"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789",
                           "ff418a5aed3763d8f2ddf88a29e62486"}, // A.5 6
        {"12345678901234567890123456789012345678901234567890"+
         "123456789012345678901234567890",
                           "dfd6b45f60fe79bbbde87c6bfc6580a5"}  // A.5 7
    };


    protected TestRIPEMD() {
        super(NAME);
    }


    protected void doIt() throws Exception {
        testExistence(NAME);
        testValues(NAME, TEST_VALUES);
        //testCloning(NAME);
    }
}
