/*
 * Copyright (c) 1997 Robert Nordier
 * All rights reserved.
 *
 * $Id: err.c,v 1.1 1997/01/20 22:57:57 rnordier Exp $
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR(S) ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR(S) BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
 * GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
 * IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN
 * IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <stdarg.h>
#include <stdlib.h>
#include <stdio.h>
#include "err.h"

extern char *__progname;

static void output(const char *fmt, va_list ap, const char *errmsg);

void
err(int eval, const char *fmt,...)
{
    va_list ap;
    const char *errmsg;

    errmsg = _sys_errlist[errno];
    va_start(ap, fmt);
    output(fmt, ap, errmsg);
    va_end(ap);
    exit(eval);
}

void
errx(int eval, const char *fmt,...)
{
    va_list ap;

    va_start(ap, fmt);
    output(fmt, ap, NULL);
    va_end(ap);
    exit(eval);
}

void
warn(const char *fmt,...)
{
    va_list ap;
    const char *errmsg;

    errmsg = _sys_errlist[errno];
    va_start(ap, fmt);
    output(fmt, ap, errmsg);
    va_end(ap);
}

void
warnx(const char *fmt,...)
{
    va_list ap;

    va_start(ap, fmt);
    output(fmt, ap, NULL);
    va_end(ap);
}

static void
output(const char *fmt, va_list ap, const char *errmsg)
{
    fprintf(stderr, "%s: ", __progname);
    if (fmt)
	vfprintf(stderr, fmt, ap);
    if (errmsg)
	fprintf(stderr, "%s%s", fmt ? ": " : "", errmsg);
    fputc('\n', stderr);
}
