/*
 * Decompiled with CFR 0.152.
 */
package megamek.common;

import java.security.SecureRandom;
import java.util.Random;
import megamek.common.MMRoll;
import megamek.common.MMShuffle;
import megamek.common.Roll;

public abstract class MMRandom {
    public static final int R_DEFAULT = 1;
    public static final int R_SUN = 0;
    public static final int R_CRYPTO = 1;
    public static final int R_POOL36 = 2;

    public static MMRandom generate(int n) {
        System.err.println("MMRandom: generating RNG type #" + n);
        try {
            switch (n) {
                case 1: {
                    return new CryptoRandom();
                }
                case 2: {
                    return new Pool36Random();
                }
            }
            return new SunRandom();
        }
        catch (Exception exception) {
            System.err.println("MMRandom: could not create desired RNG #" + n);
            System.err.println("MMRandom: using SunRandom (#0) instead");
            return new SunRandom();
        }
    }

    public Roll d6(int n) {
        if (0 >= n) {
            throw new IllegalArgumentException("Must ask for a positive number of rolls, not " + n);
        }
        MMRoll mMRoll = new MMRoll(this, 6, 1);
        for (int i = 1; i < n; ++i) {
            mMRoll.addRoll(this);
        }
        return mMRoll;
    }

    public Roll d6() {
        return this.d6(1);
    }

    public abstract int randomInt(int var1);

    static class Pool36Random
    extends SunRandom {
        public static final int NUM_SHUFFLES = 360;
        MMShuffle[] pool = new MMShuffle[36];
        int index = 0;

        public Pool36Random() {
            this.initPool();
            this.shufflePool();
        }

        public Roll d6(int n) {
            if (n != 2) {
                return super.d6(n);
            }
            if (this.index >= this.pool.length) {
                this.shufflePool();
            }
            return this.pool[this.index++];
        }

        void initPool() {
            this.index = 0;
            for (int i = 1; i <= 6; ++i) {
                for (int j = 1; j <= 6; ++j) {
                    this.pool[this.index++] = new MMShuffle(i, j);
                }
            }
        }

        void shufflePool() {
            int n;
            for (n = 0; n < 360; ++n) {
                int n2 = this.randomInt(this.pool.length);
                int n3 = this.randomInt(this.pool.length);
                MMShuffle mMShuffle = this.pool[n2];
                this.pool[n2] = this.pool[n3];
                this.pool[n3] = mMShuffle;
            }
            for (n = 0; n < this.pool.length; ++n) {
                this.pool[n].setDeal(n + 1);
            }
            this.index = 0;
        }
    }

    static class CryptoRandom
    extends MMRandom {
        SecureRandom random;

        public CryptoRandom() throws ClassNotFoundException, NoSuchMethodException {
            new Random().getClass().getMethod("nextInt", Integer.TYPE);
            this.random = new SecureRandom();
            Thread thread = new Thread(new Runnable(){

                public void run() {
                    CryptoRandom.this.random.nextInt();
                }
            }, "Random Number Init (CryptoRandom)");
            thread.start();
        }

        public int randomInt(int n) {
            return this.random.nextInt(n);
        }
    }

    static class SunRandom
    extends MMRandom {
        Random random = new Random();

        SunRandom() {
        }

        public int randomInt(int n) {
            return this.random.nextInt(n);
        }
    }
}

