/*
 * Decompiled with CFR 0.152.
 */
package gd.xml;

import gd.xml.ParseException;
import gd.xml.XMLReader;
import gd.xml.XMLResponder;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;

public class XMLParser {
    private static final ParseException EOS = new ParseException("unexpected end of document");
    private Hashtable paramEntities;
    private Hashtable genEntities;
    private boolean skipDoctype;
    private XMLReader reader;
    private char cn;
    private XMLResponder xr;
    private String version = null;
    private boolean standalone = true;
    private boolean dtd = false;

    private void checkPEReference() throws ParseException {
        if (this.cn == '%') {
            if (!this.dtd) {
                throw new ParseException("incorrect use of PE within internal DTD");
            }
            this.read();
            String string = this.readName();
            if (this.cn != ';') {
                throw new ParseException("parameter entity not terminated with ';'");
            }
            if (!this.paramEntities.containsKey(string)) {
                throw new ParseException("parameter entity not recognised ");
            }
            String[] stringArray = (String[])this.paramEntities.get(string);
            if (stringArray[0] == null) {
                stringArray[0] = string;
                this.skipDoctype = this.parseExternal(stringArray) ^ true;
            } else {
                this.reader.push(stringArray[0]);
                this.read();
                this.checkPEReference();
            }
        }
    }

    private static boolean isFirstNameChar(char c) {
        return Character.isLetter(c) || c == ':' || c == '_';
    }

    private static boolean isQuote(char c) {
        return c == '\'' || c == '\"';
    }

    private static boolean isWhite(char c) {
        return c == ' ' || c == '\t' || c == '\r' || c == '\n';
    }

    public void parseDTD(XMLResponder xMLResponder) throws ParseException {
        this.xr = xMLResponder;
        InputStream inputStream = this.xr.getDocumentStream();
        this.reader = new XMLReader(inputStream);
        this.genEntities = new Hashtable();
        this.paramEntities = new Hashtable();
        this.readDTD();
        try {
            this.reader.close();
            this.reader = null;
        }
        catch (IOException iOException) {
            throw new ParseException(iOException.getMessage());
        }
        this.paramEntities = null;
        this.genEntities = null;
        this.xr = null;
    }

    private boolean parseExternal(String[] stringArray) throws ParseException {
        InputStream inputStream = this.xr.resolveExternalEntity(stringArray[0], stringArray[1], stringArray[2]);
        if (inputStream == null) {
            return false;
        }
        XMLReader xMLReader = this.reader;
        this.reader = new XMLReader(inputStream);
        this.readXMLTag();
        StringBuffer stringBuffer = new StringBuffer();
        try {
            while (true) {
                this.read();
                stringBuffer.append(this.cn);
            }
        }
        catch (ParseException parseException) {
            if (parseException != EOS) {
                throw parseException;
            }
            stringArray[0] = stringBuffer.toString();
            this.reader = xMLReader;
            return true;
        }
    }

    public void parseXML(XMLResponder xMLResponder) throws ParseException {
        this.xr = xMLResponder;
        InputStream inputStream = this.xr.getDocumentStream();
        this.reader = new XMLReader(inputStream);
        this.genEntities = new Hashtable();
        this.paramEntities = new Hashtable();
        this.readDocument();
        try {
            this.reader.close();
            this.reader = null;
        }
        catch (IOException iOException) {
            throw new ParseException(iOException.getMessage());
        }
        this.paramEntities = null;
        this.genEntities = null;
        this.xr = null;
    }

    private void read() throws ParseException {
        try {
            this.cn = (char)this.reader.read();
        }
        catch (IOException iOException) {
            throw new ParseException(iOException.getMessage());
        }
        if (this.cn == '\uffff') {
            throw EOS;
        }
    }

    private void readAttlistTag() throws ParseException {
        String string = this.readName();
        while (this.cn != '>') {
            String string2;
            String string3;
            String string4;
            this.checkPEReference();
            String string5 = this.readName();
            if (Character.isLetterOrDigit(this.cn)) {
                string4 = this.readName();
            } else {
                this.checkPEReference();
                string4 = this.readParens(false);
            }
            boolean bl = string4.equals("NOTATIONS");
            if (bl) {
                string4 = this.readParens(false);
            }
            if (XMLParser.isQuote(this.cn)) {
                string3 = this.readAttrValue();
                string2 = "DEFAULT";
            } else if (this.cn == '#') {
                this.read();
                string2 = this.readName();
                if (string2.equals("FIXED")) {
                    this.checkPEReference();
                    string3 = this.readAttrValue();
                } else {
                    string3 = null;
                    if (!string2.equals("REQUIRED") && !string2.equals("IMPLIED")) {
                        throw new ParseException("expected default modifier");
                    }
                }
            } else {
                throw new ParseException("expected default");
            }
            this.xr.recordAttlistDeclaration(string, string5, bl, string4, string2, string3);
        }
    }

    private String readAttrValue() throws ParseException {
        StringBuffer stringBuffer = new StringBuffer();
        if (!XMLParser.isQuote(this.cn)) {
            throw new ParseException("unquoted attribute value");
        }
        char c = this.cn;
        this.read();
        while (this.cn != c) {
            if (this.cn == '<') {
                throw new ParseException("unescaped < in attribute value");
            }
            if (this.cn == '&') {
                stringBuffer.append(this.readReference());
            } else {
                stringBuffer.append(this.cn);
            }
            this.read();
        }
        this.read();
        this.readWhite();
        return stringBuffer.toString();
    }

    private Hashtable readAttributes() throws ParseException {
        Hashtable<String, String> hashtable = null;
        while (XMLParser.isFirstNameChar(this.cn)) {
            String string = this.readName();
            if (this.cn != '=') {
                throw new ParseException("expected = after attribute name");
            }
            this.read();
            this.readWhite();
            String string2 = this.readAttrValue();
            if (hashtable == null) {
                hashtable = new Hashtable<String, String>();
            }
            hashtable.put(string, string2);
        }
        return hashtable;
    }

    private void readBangTag(boolean bl) throws ParseException {
        this.read();
        String string = this.cn == '-' ? this.readChars(2) : (this.cn == '[' ? this.readChars(7) : this.readChars(7));
        if (string.equals("--")) {
            this.readCommentOrCDATA('-');
        } else if (string.equals("[CDATA[")) {
            if (bl) {
                throw new ParseException("CDATA found in prolog");
            }
            this.readCommentOrCDATA(']');
        } else if (string.equals("DOCTYPE")) {
            if (!bl) {
                throw new ParseException("DOCTYPE found outside prolog");
            }
            this.readDoctypeTag();
        } else {
            throw new ParseException("unrecognized <! > tag");
        }
    }

    private void readCharData() throws ParseException {
        StringBuffer stringBuffer = new StringBuffer();
        while (this.cn != '<') {
            if (this.cn == '&') {
                stringBuffer.append(this.readReference());
            } else {
                stringBuffer.append(this.cn);
            }
            this.read();
        }
        this.xr.recordCharData(stringBuffer.toString());
    }

    private char readCharacterRef() throws ParseException {
        StringBuffer stringBuffer = new StringBuffer();
        this.read();
        while (this.cn != ';') {
            stringBuffer.append(this.cn);
            this.read();
        }
        String string = stringBuffer.toString();
        int n = 10;
        if (string.startsWith("x")) {
            string = string.substring(1);
            n = 16;
        }
        try {
            return (char)Integer.parseInt(string, n);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ParseException("unrecognized character reference");
        }
    }

    private String readChars(int n) throws ParseException {
        StringBuffer stringBuffer = new StringBuffer();
        while (stringBuffer.length() < n) {
            stringBuffer.append(this.cn);
            this.read();
        }
        return stringBuffer.toString();
    }

    private void readClosingTag() throws ParseException {
        this.read();
        String string = this.readName();
        this.readWhite();
        if (this.readTagClose()) {
            throw new ParseException("close tag ended with />");
        }
        this.xr.recordElementEnd(string);
    }

    private void readCommentOrCDATA(char c) throws ParseException {
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer();
        while (this.cn != '>' || n < 2 || stringBuffer.charAt(n - 2) != c || stringBuffer.charAt(n - 1) != c) {
            if (c == '-' && n >= 2 && stringBuffer.charAt(n - 2) == '-' && stringBuffer.charAt(n - 1) == '-') {
                throw new ParseException("-- found in comment");
            }
            stringBuffer.append(this.cn);
            ++n;
            this.read();
        }
        stringBuffer.setLength(n - 2);
        String string = stringBuffer.toString();
        if (c == '-') {
            this.xr.recordComment(string);
        } else {
            this.xr.recordCharData(string);
        }
    }

    private void readDTD() throws ParseException {
        this.dtd = true;
        this.readXMLTag();
        while (true) {
            try {
                this.read();
                this.readWhite();
            }
            catch (ParseException parseException) {
                if (parseException == EOS) break;
                throw parseException;
            }
            this.readDTDPart();
        }
        this.dtd = false;
    }

    private void readDTDPart() throws ParseException {
        if (!this.dtd) {
            this.dtd = true;
            this.checkPEReference();
            this.dtd = false;
        } else {
            this.checkPEReference();
        }
        switch (this.cn) {
            case '<': {
                this.read();
                if (this.cn == '!') {
                    this.read();
                    if (this.cn == '[' && !this.dtd) {
                        throw new ParseException("conditional include in internal DTD");
                    }
                    if (this.cn == '-') {
                        this.read();
                        if (this.cn == '-') {
                            this.read();
                            this.readCommentOrCDATA('-');
                            break;
                        }
                        throw new ParseException("unrecognised tag in DTD");
                    }
                    String string = this.readName();
                    if (string.equals("ELEMENT")) {
                        this.readElementTag();
                        break;
                    }
                    if (string.equals("ENTITY")) {
                        this.readEntityTag();
                        break;
                    }
                    if (string.equals("ATTLIST")) {
                        this.readAttlistTag();
                        break;
                    }
                    if (string.equals("NOTATION")) {
                        this.readNotationTag();
                        break;
                    }
                    throw new ParseException("unrecognised tag in DTD");
                }
                if (this.cn != '?') break;
                this.readPITag();
                break;
            }
            case ']': {
                if (!this.dtd) break;
            }
            default: {
                throw new ParseException("expected markup or parameter reference");
            }
        }
    }

    private void readDoctypeTag() throws ParseException {
        Object object;
        String string;
        String string2;
        this.readWhite();
        String string3 = this.readName();
        if (this.cn == '>') {
            string2 = null;
            string = null;
        } else {
            if (Character.isLetterOrDigit(this.cn)) {
                object = this.readExternalID(false);
                string = object[0];
                string2 = object[1];
            } else {
                string2 = null;
                string = null;
            }
            if (this.cn != '>') {
                if (this.cn != '[') {
                    throw new ParseException("expected '['");
                }
                do {
                    if (!this.skipDoctype) {
                        this.read();
                        this.readWhite();
                        this.readDTDPart();
                        continue;
                    }
                    this.read();
                } while (this.cn != ']');
                this.read();
                this.readWhite();
                if (this.cn != '>') {
                    throw new ParseException("expected close of internal DTD after ]");
                }
            }
        }
        if ((string != null || string2 != null) && (object = this.xr.resolveDTDEntity(string3, string, string2)) != null) {
            XMLReader xMLReader = this.reader;
            this.reader = new XMLReader((InputStream)object);
            this.readDTD();
            this.reader = xMLReader;
        }
        this.xr.recordDoctypeDeclaration(string3, string, string2);
    }

    private void readDocument() throws ParseException {
        boolean bl;
        block15: {
            boolean bl2 = true;
            bl = false;
            boolean bl3 = true;
            int n = 0;
            this.readXMLTag();
            this.xr.recordDocStart();
            this.read();
            this.readWhite();
            while (true) {
                if (this.cn == '<') {
                    this.read();
                    switch (this.cn) {
                        case '?': {
                            this.readPITag();
                            break;
                        }
                        case '!': {
                            this.readBangTag(bl2);
                            break;
                        }
                        case '/': {
                            this.readClosingTag();
                            --n;
                            break;
                        }
                        default: {
                            String string = this.readTag();
                            if (string == null) {
                                ++n;
                            } else {
                                this.xr.recordElementEnd(string);
                            }
                            if (bl) {
                                throw new ParseException("element found outside root element");
                            }
                            bl2 = false;
                        }
                    }
                    if (!bl && !bl2 && n == 0) {
                        bl = true;
                    }
                    try {
                        this.read();
                        this.readWhite();
                    }
                    catch (ParseException parseException) {
                        if (parseException != EOS) {
                            throw parseException;
                        }
                        break block15;
                    }
                }
                this.readCharData();
                if (bl2 || bl) break;
            }
            throw new ParseException("character data outside root element");
        }
        if (!bl) {
            throw new ParseException("no root element in document");
        }
        this.xr.recordDocEnd();
    }

    private void readElementTag() throws ParseException {
        String string;
        String string2 = this.readName();
        this.checkPEReference();
        if (this.cn == '(') {
            string = this.readParens(true);
        } else {
            string = this.readName();
            if (!string.equals("ANY") && !string.equals("EMPTY")) {
                throw new ParseException("expected 'EMPTY' or 'ANY'");
            }
        }
        if (this.cn != '>') {
            throw new ParseException("expected tag close");
        }
        this.xr.recordElementDeclaration(string2, string);
    }

    private void readEntityTag() throws ParseException {
        String string;
        String[] stringArray;
        String string2;
        String[] stringArray2;
        boolean bl = false;
        if (this.cn == '%') {
            bl = true;
            this.read();
            this.readWhite();
        }
        String string3 = this.readName();
        this.checkPEReference();
        if (XMLParser.isQuote(this.cn)) {
            stringArray2 = new StringBuffer();
            char c = this.cn;
            this.read();
            while (this.cn != c) {
                this.checkPEReference();
                if (this.cn == '&') {
                    this.read();
                    if (this.cn == '#') {
                        this.cn = this.readCharacterRef();
                    } else {
                        stringArray2.append('&');
                    }
                }
                stringArray2.append(this.cn);
                this.read();
            }
            string2 = stringArray2.toString();
            this.read();
            this.readWhite();
            stringArray = new String[]{null, null};
        } else {
            stringArray = this.readExternalID(false);
            string2 = null;
        }
        if (this.cn != '>' && !bl) {
            if (!this.readName().equals("NDATA")) {
                throw new ParseException("expected NDATA or close");
            }
            string = this.readName();
        } else {
            string = null;
        }
        if (this.cn != '>') {
            throw new ParseException("expected tag close");
        }
        stringArray2 = new String[]{string2, stringArray[0], stringArray[1], string};
        if (bl) {
            if (!this.paramEntities.containsKey(string3)) {
                this.paramEntities.put(string3, stringArray2);
            }
        } else {
            if (!this.genEntities.containsKey(string3)) {
                this.genEntities.put(string3, stringArray2);
            }
            this.xr.recordEntityDeclaration(string3, string2, stringArray[0], stringArray[1], string);
        }
    }

    private String[] readExternalID(boolean bl) throws ParseException {
        String[] stringArray = new String[2];
        String string = this.readName();
        if (string.equals("SYSTEM")) {
            stringArray[0] = null;
            stringArray[1] = this.readPubSysID(false);
        } else if (string.equals("PUBLIC")) {
            stringArray[0] = this.readPubSysID(true);
            stringArray[1] = !bl || XMLParser.isQuote(this.cn) ? this.readPubSysID(false) : null;
        } else {
            throw new ParseException("expected external ID");
        }
        return stringArray;
    }

    private String readName() throws ParseException {
        if (!XMLParser.isFirstNameChar(this.cn)) {
            throw new ParseException("name in tag started without letter, : or _");
        }
        StringBuffer stringBuffer = new StringBuffer();
        do {
            stringBuffer.append(this.cn);
            this.read();
        } while (Character.isLetterOrDigit(this.cn) || this.cn == '.' || this.cn == '-' || this.cn == '_' || this.cn == ':');
        this.readWhite();
        return stringBuffer.toString();
    }

    private void readNotationTag() throws ParseException {
        String string = this.readName();
        String[] stringArray = this.readExternalID(true);
        if (this.cn != '>') {
            throw new ParseException("expected tag close");
        }
        this.xr.recordNotationDeclaration(string, stringArray[0], stringArray[1]);
    }

    private void readPITag() throws ParseException {
        this.read();
        String string = this.readName();
        if (string.toLowerCase().equals("xml")) {
            throw new ParseException("<?xml?> tag must start document");
        }
        StringBuffer stringBuffer = new StringBuffer();
        char c = this.cn;
        this.read();
        while (c != '?' || this.cn != '>') {
            stringBuffer.append(c);
            c = this.cn;
            this.read();
        }
        this.xr.recordPI(string, stringBuffer.toString());
    }

    private String readParens(boolean bl) throws ParseException {
        if (this.cn != '(') {
            throw new ParseException("( expected");
        }
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer();
        do {
            this.checkPEReference();
            if (this.cn == '(') {
                ++n;
            }
            if (this.cn == ')') {
                --n;
            }
            stringBuffer.append(this.cn);
            this.read();
        } while (n != 0);
        if (bl && (this.cn == '?' || this.cn == '+' || this.cn == '*')) {
            stringBuffer.append(this.cn);
            this.read();
        }
        this.readWhite();
        return stringBuffer.toString();
    }

    private String readPubSysID(boolean bl) throws ParseException {
        this.checkPEReference();
        if (!XMLParser.isQuote(this.cn)) {
            throw new ParseException("unquoted system or public ID");
        }
        char c = this.cn;
        StringBuffer stringBuffer = new StringBuffer();
        this.read();
        while (this.cn != c) {
            if (false) {
                throw new ParseException("illegal character in Public ID");
            }
            stringBuffer.append(this.cn);
            this.read();
        }
        this.read();
        this.readWhite();
        return stringBuffer.toString();
    }

    private String readReference() throws ParseException {
        this.read();
        if (this.cn == '#') {
            return String.valueOf(this.readCharacterRef());
        }
        String string = this.readName();
        if (string.equals("quot")) {
            return "\"";
        }
        if (string.equals("apos")) {
            return "'";
        }
        if (string.equals("lt")) {
            return "<";
        }
        if (string.equals("gt")) {
            return ">";
        }
        if (string.equals("amp")) {
            return "&";
        }
        String[] stringArray = (String[])this.genEntities.get(string);
        if (stringArray == null) {
            throw new ParseException("unrecognized character reference");
        }
        if (stringArray[3] != null) {
            throw new ParseException("cannot parse notation");
        }
        if (stringArray[0] == null) {
            this.parseExternal(stringArray);
        }
        this.reader.push(stringArray[0]);
        return "";
    }

    private String readTag() throws ParseException {
        String string = this.readName();
        Hashtable hashtable = this.readAttributes();
        this.xr.recordElementStart(string, hashtable);
        return this.readTagClose() ? string : null;
    }

    private boolean readTagClose() throws ParseException {
        if (this.cn != '/' && this.cn != '>') {
            throw new ParseException("expected tag close");
        }
        boolean bl = false;
        while (this.cn != '>') {
            bl = this.cn == '/';
            this.read();
        }
        return bl;
    }

    private void readWhite() throws ParseException {
        while (XMLParser.isWhite(this.cn)) {
            this.read();
        }
    }

    private void readXMLTag() throws ParseException {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            int n = 0;
            while (n < 5) {
                this.read();
                stringBuffer.append(this.cn);
                ++n;
            }
        }
        catch (ParseException parseException) {
            this.reader.push(stringBuffer.toString());
            if (parseException == EOS) {
                return;
            }
            throw parseException;
        }
        String string = stringBuffer.toString();
        if (string.equals("<?xml")) {
            this.read();
            this.readWhite();
            Hashtable hashtable = this.readAttributes();
            if (hashtable == null) {
                throw new ParseException("empty <?xml?> tag");
            }
            if (hashtable.size() > 3) {
                throw new ParseException("too many attributes in <?xml?> tag");
            }
            this.version = (String)hashtable.get("version");
            String string2 = (String)hashtable.get("encoding");
            String string3 = (String)hashtable.get("standalone");
            if (this.version == null) {
                throw new ParseException("no xml version");
            }
            try {
                if (string2 != null) {
                    this.reader.setEncoding(string2);
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new ParseException("unsupported encoding");
            }
            if (this.cn != '?') {
                throw new ParseException("illegal character in <?xml?> tag");
            }
            this.read();
            if (this.cn != '>') {
                throw new ParseException("expected tag close");
            }
        } else {
            this.reader.push(string);
        }
    }
}

