/*
 * Decompiled with CFR 0.152.
 */
package com.declarativa.interprolog.gui;

import com.declarativa.interprolog.ObjectExamplePair;
import com.declarativa.interprolog.PrologEngine;
import com.declarativa.interprolog.gui.RelationTreeNode;
import com.declarativa.interprolog.util.IPException;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class RelationTreeModel
implements TreeModel {
    protected Vector listeners;
    PrologEngine engine;
    RelationTreeNode root;
    String relationFunctor;

    public RelationTreeModel(PrologEngine prologEngine, String string, Object object) {
        this.engine = prologEngine;
        this.root = new RelationTreeNode(this, object);
        this.relationFunctor = string;
    }

    public static void browseRelation(PrologEngine prologEngine, String string, Object object) {
        RelationTreeModel relationTreeModel = new RelationTreeModel(prologEngine, string, object);
        JTree jTree = new JTree(relationTreeModel);
        JFrame jFrame = new JFrame("Relation Tree Browser (" + object + ")");
        jFrame.getContentPane().add("Center", new JScrollPane(jTree));
        ((Component)jFrame).setSize(300, 300);
        ((Component)jFrame).setVisible(true);
    }

    public Object getRoot() {
        return this.root;
    }

    public Object getChild(Object object, int n) {
        return ((RelationTreeNode)object).getChild(n);
    }

    public int getChildCount(Object object) {
        return ((RelationTreeNode)object).getChildCount();
    }

    public boolean isLeaf(Object object) {
        return ((RelationTreeNode)object).isLeaf();
    }

    public void valueForPathChanged(TreePath treePath, Object object) {
        throw new RuntimeException("I can not handle term edition!");
    }

    public int getIndexOfChild(Object object, Object object2) {
        return ((RelationTreeNode)object).getIndexOfChild(object2);
    }

    public void addTreeModelListener(TreeModelListener treeModelListener) {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        this.listeners.addElement(treeModelListener);
    }

    public void removeTreeModelListener(TreeModelListener treeModelListener) {
        if (!this.listeners.removeElement(treeModelListener)) {
            throw new IPException("Bad removal of RelationTreeModel listener");
        }
    }

    public static ObjectExamplePair example() {
        return new ObjectExamplePair(new NodeDescriptionTriple());
    }

    public static class BrowseAction
    extends AbstractAction {
        String relationFunctor;
        Object top;
        PrologEngine engine;

        public BrowseAction(PrologEngine prologEngine, String string, Object object) {
            super(String.valueOf(string) + "(" + object + ")");
            this.engine = prologEngine;
            this.relationFunctor = string;
            this.top = object;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            RelationTreeModel.browseRelation(this.engine, this.relationFunctor, this.top);
        }
    }

    public static class NodeDescriptionTriple
    implements Serializable {
        Object node;
        Object description;
        int childCount;
    }
}

