/*
 * Decompiled with CFR 0.152.
 */
package jrm;

import java.io.File;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import jrm.misc.Log;
import jrm.misc.Settings;
import jrm.ui.MainFrame;
import jupdater.JUpdater;
import org.apache.commons.io.FilenameUtils;

public final class JRomManager {
    public static void main(String[] args) {
        block8: for (int i = 0; i < args.length; ++i) {
            switch (args[i]) {
                case "--multiuser": {
                    Settings.multiuser = true;
                    continue block8;
                }
                case "--noupdate": {
                    Settings.noupdate = true;
                }
            }
        }
        if (JRomManager.lockInstance(FilenameUtils.removeExtension(JRomManager.class.getSimpleName()) + ".lock")) {
            JUpdater updater;
            if (!Settings.noupdate && (updater = new JUpdater("optyfr", "JRomManager")).updateAvailable()) {
                updater.showMessage();
            }
            new MainFrame().setVisible(true);
        }
    }

    private static boolean lockInstance(String lockFile) {
        try {
            File file = new File(Settings.getWorkPath().toFile(), lockFile);
            RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
            FileLock fileLock = randomAccessFile.getChannel().tryLock();
            if (fileLock != null) {
                Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                    try {
                        fileLock.release();
                        randomAccessFile.close();
                        file.delete();
                    }
                    catch (Exception e) {
                        Log.err("Unable to remove lock file: " + lockFile, e);
                    }
                }));
                return true;
            }
        }
        catch (Exception e) {
            Log.err("Unable to create and/or lock file: " + lockFile, e);
        }
        return false;
    }
}

