/*
 * Decompiled with CFR 0.152.
 */
package jrm.compressors;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import jrm.compressors.Archive;
import jrm.compressors.SevenZipNArchive;
import jrm.compressors.SevenZipOptions;
import jrm.misc.FindCmd;
import jrm.misc.Settings;
import net.sf.sevenzipjbinding.SevenZipNativeInitializationException;
import org.apache.commons.io.FileUtils;

public class SevenZipArchive
implements Archive {
    private File tempDir;
    private File archive;
    private String cmd;
    private boolean readonly;
    private static HashMap<String, File> archives = new HashMap();
    private SevenZipNArchive native_7zip;

    public SevenZipArchive(File archive) throws IOException {
        this(archive, false);
    }

    public SevenZipArchive(File archive, boolean readonly) throws IOException {
        block3: {
            this.tempDir = null;
            this.archive = null;
            this.cmd = null;
            this.readonly = false;
            this.native_7zip = null;
            try {
                this.native_7zip = new SevenZipNArchive(archive, readonly);
            }
            catch (SevenZipNativeInitializationException e) {
                this.readonly = readonly;
                this.cmd = Settings.getProperty("7z_cmd", FindCmd.find7z());
                if (!new File(this.cmd).exists() && !new File(this.cmd + ".exe").exists()) {
                    throw new IOException(this.cmd + " does not exists");
                }
                this.archive = archives.get(archive.getAbsolutePath());
                if (null != this.archive) break block3;
                this.archive = archive;
                archives.put(archive.getAbsolutePath(), this.archive);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (this.native_7zip != null) {
            this.native_7zip.close();
        } else if (this.tempDir != null) {
            if (this.readonly) {
                FileUtils.deleteDirectory(this.tempDir);
            } else {
                int err = -1;
                ArrayList<String> cmd_add = new ArrayList<String>();
                Path tmpfile = Files.createTempFile(this.archive.getParentFile().toPath(), "JRM", ".7z", new FileAttribute[0]);
                tmpfile.toFile().delete();
                Collections.addAll(cmd_add, Settings.getProperty("7z_cmd", FindCmd.find7z()), "a", "-r", "-t7z");
                Collections.addAll(cmd_add, "-ms=" + (Settings.getProperty("7z_solid", false) ? "on" : "off"), "-mx=" + Settings.getProperty("7z_level", SevenZipOptions.NORMAL.toString()));
                Collections.addAll(cmd_add, tmpfile.toFile().getAbsolutePath(), "*");
                Process process = new ProcessBuilder(cmd_add).directory(this.tempDir).redirectErrorStream(true).start();
                try {
                    err = process.waitFor();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                FileUtils.deleteDirectory(this.tempDir);
                if (err != 0) {
                    Files.deleteIfExists(tmpfile);
                    throw new IOException("Process returned " + err);
                }
                File file = this.archive;
                synchronized (file) {
                    Files.move(tmpfile, this.archive.toPath(), StandardCopyOption.REPLACE_EXISTING);
                }
            }
            this.tempDir = null;
        }
    }

    @Override
    public File getTempDir() throws IOException {
        if (this.native_7zip != null) {
            return this.native_7zip.getTempDir();
        }
        if (this.tempDir == null) {
            this.tempDir = Files.createTempDirectory("JRM", new FileAttribute[0]).toFile();
            if (this.archive.exists() && !this.readonly) {
                if (this.extract(this.tempDir, null) == 0) {
                    return this.tempDir;
                }
                FileUtils.deleteDirectory(this.tempDir);
                this.tempDir = null;
            }
        }
        return this.tempDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int extract(File baseDir, String entry) throws IOException {
        ArrayList<String> cmd = new ArrayList<String>();
        Collections.addAll(cmd, Settings.getProperty("7z_cmd", FindCmd.find7z()), "x", "-y", this.archive.getAbsolutePath());
        if (entry != null && !entry.isEmpty()) {
            cmd.add(entry);
        }
        ProcessBuilder pb = new ProcessBuilder(cmd).directory(baseDir);
        File file = this.archive;
        synchronized (file) {
            Process process = pb.start();
            try {
                return process.waitFor();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return -1;
    }

    @Override
    public File extract(String entry) throws IOException {
        File result;
        if (this.native_7zip != null) {
            return this.native_7zip.extract(entry);
        }
        if (this.readonly) {
            this.extract(this.getTempDir(), entry);
        }
        if ((result = new File(this.getTempDir(), entry)).exists()) {
            return result;
        }
        return null;
    }

    @Override
    public InputStream extract_stdout(String entry) throws IOException {
        if (this.native_7zip != null) {
            return this.native_7zip.extract_stdout(entry);
        }
        if (this.readonly) {
            this.extract(this.getTempDir(), entry);
        }
        return new FileInputStream(new File(this.getTempDir(), entry));
    }

    @Override
    public int add(String entry) throws IOException {
        if (this.native_7zip != null) {
            return this.native_7zip.add(entry);
        }
        return this.add(this.getTempDir(), entry);
    }

    @Override
    public int add(File baseDir, String entry) throws IOException {
        if (this.native_7zip != null) {
            return this.native_7zip.add(baseDir, entry);
        }
        if (this.readonly) {
            return -1;
        }
        if (!baseDir.equals(this.getTempDir())) {
            FileUtils.copyFile(new File(baseDir, entry), new File(this.getTempDir(), entry));
        }
        return 0;
    }

    @Override
    public int add_stdin(InputStream src, String entry) throws IOException {
        if (this.native_7zip != null) {
            return this.native_7zip.add_stdin(src, entry);
        }
        if (this.readonly) {
            return -1;
        }
        FileUtils.copyInputStreamToFile(src, new File(this.getTempDir(), entry));
        return 0;
    }

    @Override
    public int delete(String entry) throws IOException {
        if (this.native_7zip != null) {
            return this.native_7zip.delete(entry);
        }
        if (this.readonly) {
            return -1;
        }
        FileUtils.deleteQuietly(new File(this.getTempDir(), entry));
        return 0;
    }

    @Override
    public int rename(String entry, String newname) throws IOException {
        if (this.native_7zip != null) {
            return this.native_7zip.rename(entry, newname);
        }
        if (this.readonly) {
            return -1;
        }
        FileUtils.moveFile(new File(this.getTempDir(), entry), new File(this.getTempDir(), newname));
        return 0;
    }

    @Override
    public int duplicate(String entry, String newname) throws IOException {
        if (this.native_7zip != null) {
            return this.native_7zip.duplicate(entry, newname);
        }
        if (this.readonly) {
            return -1;
        }
        FileUtils.copyFile(new File(this.getTempDir(), entry), new File(this.getTempDir(), newname));
        return 0;
    }
}

