/*
 * Decompiled with CFR 0.152.
 */
package jrm.profile.manager;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.util.Date;
import javax.swing.JOptionPane;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import jrm.misc.Settings;
import jrm.profile.manager.ProfileNFOMame;
import jrm.profile.manager.ProfileNFOStats;
import org.apache.commons.io.FilenameUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class ProfileNFO
implements Serializable {
    private static final long serialVersionUID = 1L;
    public File file = null;
    public String name = null;
    public ProfileNFOStats stats = new ProfileNFOStats();
    public ProfileNFOMame mame = new ProfileNFOMame();
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("file", File.class), new ObjectStreamField("name", String.class), new ObjectStreamField("stats", ProfileNFOStats.class), new ObjectStreamField("mame", ProfileNFOMame.class)};

    private void writeObject(ObjectOutputStream stream) throws IOException {
        ObjectOutputStream.PutField fields = stream.putFields();
        fields.put("file", this.file);
        fields.put("name", this.name);
        fields.put("stats", this.stats);
        fields.put("mame", this.mame);
        stream.writeFields();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField fields = stream.readFields();
        this.file = (File)fields.get("file", null);
        this.name = (String)fields.get("name", null);
        this.stats = (ProfileNFOStats)fields.get("stats", new ProfileNFOStats());
        this.mame = (ProfileNFOMame)fields.get("mame", new ProfileNFOMame());
    }

    private ProfileNFO(File file) {
        this.file = file;
        this.name = file.getName();
        this.stats.created = new Date();
        if (this.isJRM()) {
            this.loadJrm(file);
        }
    }

    private static File getFileNfo(File file) {
        return Settings.getWorkFile(file.getParentFile(), file.getName(), ".nfo");
    }

    public void relocate(File file) {
        ProfileNFO.getFileNfo(this.file).delete();
        this.file = file;
        this.name = file.getName();
        this.save();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ProfileNFO load(File file) {
        File filenfo = ProfileNFO.getFileNfo(file);
        if (filenfo.lastModified() < file.lastModified()) return new ProfileNFO(file);
        try (ObjectInputStream ois = new ObjectInputStream(new BufferedInputStream(new FileInputStream(filenfo)));){
            ProfileNFO profileNFO = (ProfileNFO)ois.readObject();
            return profileNFO;
        }
        catch (Throwable throwable6) {
            // empty catch block
        }
        return new ProfileNFO(file);
    }

    public void save() {
        if (this.isJRM()) {
            try {
                long modified = this.file.lastModified();
                ProfileNFO.saveJrm(this.file, this.mame.fileroms, this.mame.filesl);
                if (modified != 0L) {
                    this.file.setLastModified(modified);
                }
            }
            catch (ParserConfigurationException | TransformerException e) {
                e.printStackTrace();
            }
        }
        try (ObjectOutputStream oos = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(ProfileNFO.getFileNfo(this.file))));){
            oos.writeObject(this);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public boolean isJRM() {
        return FilenameUtils.getExtension(this.file.getName()).equals("jrm");
    }

    public void loadJrm(final File jrmfile) {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        try {
            SAXParser parser = factory.newSAXParser();
            parser.parse(jrmfile, new DefaultHandler(){
                private boolean in_jrm = false;

                @Override
                public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                    if (qName.equalsIgnoreCase("JRomManager")) {
                        this.in_jrm = true;
                    } else if (qName.equalsIgnoreCase("Profile") && this.in_jrm) {
                        block8: for (int i = 0; i < attributes.getLength(); ++i) {
                            switch (attributes.getQName(i).toLowerCase()) {
                                case "roms": {
                                    ProfileNFO.this.mame.fileroms = new File(jrmfile.getParentFile(), attributes.getValue(i));
                                    continue block8;
                                }
                                case "sl": {
                                    ProfileNFO.this.mame.filesl = new File(jrmfile.getParentFile(), attributes.getValue(i));
                                }
                            }
                        }
                    }
                }

                @Override
                public void endElement(String uri, String localName, String qName) throws SAXException {
                    if (qName.equalsIgnoreCase("JRomManager")) {
                        this.in_jrm = false;
                    }
                }
            });
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            JOptionPane.showMessageDialog(null, e, "Exception", 0);
            e.printStackTrace();
        }
    }

    public static File saveJrm(File JrmFile, File roms_file, File sl_file) throws ParserConfigurationException, TransformerException {
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
        Document doc = docBuilder.newDocument();
        Element rootElement = doc.createElement("JRomManager");
        doc.appendChild(rootElement);
        Element profile = doc.createElement("Profile");
        profile.setAttribute("roms", roms_file.getName());
        if (sl_file != null) {
            profile.setAttribute("sl", sl_file.getName());
        }
        rootElement.appendChild(profile);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        DOMSource source = new DOMSource(doc);
        StreamResult result = new StreamResult(JrmFile);
        transformer.transform(source, result);
        return JrmFile;
    }

    public boolean delete() {
        if (this.file.delete()) {
            this.mame.delete();
            new File(this.file.getAbsolutePath() + ".cache").delete();
            new File(this.file.getAbsolutePath() + ".nfo").delete();
            new File(this.file.getAbsolutePath() + ".properties").delete();
            return true;
        }
        return false;
    }
}

