/*
 * Decompiled with CFR 0.152.
 */
package jrm.ui;

import com.eclipsesource.json.Json;
import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.swing.ButtonGroup;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.SwingWorker;
import javax.swing.UIManager;
import javax.swing.border.BevelBorder;
import javax.swing.border.SoftBevelBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.table.TableColumn;
import javax.swing.tree.TreePath;
import jrm.batch.DirUpdater;
import jrm.batch.TorrentChecker;
import jrm.compressors.SevenZipOptions;
import jrm.compressors.ZipOptions;
import jrm.compressors.zipfs.ZipLevel;
import jrm.compressors.zipfs.ZipTempThreshold;
import jrm.io.torrent.options.TrntChkMode;
import jrm.locale.Messages;
import jrm.misc.FindCmd;
import jrm.misc.Settings;
import jrm.profile.Profile;
import jrm.profile.data.Anyware;
import jrm.profile.data.Driver;
import jrm.profile.data.Machine;
import jrm.profile.data.Software;
import jrm.profile.data.Systm;
import jrm.profile.data.Years;
import jrm.profile.filter.CatVer;
import jrm.profile.filter.NPlayers;
import jrm.profile.fix.Fix;
import jrm.profile.manager.Dir;
import jrm.profile.manager.Export;
import jrm.profile.manager.Import;
import jrm.profile.manager.ProfileNFO;
import jrm.profile.manager.ProfileNFOMame;
import jrm.profile.scan.Dir2Dat;
import jrm.profile.scan.DirScan;
import jrm.profile.scan.Scan;
import jrm.profile.scan.options.FormatOptions;
import jrm.profile.scan.options.HashCollisionOptions;
import jrm.profile.scan.options.MergeOptions;
import jrm.ui.basic.AbstractNGTreeNode;
import jrm.ui.basic.JCheckBoxList;
import jrm.ui.basic.JCheckBoxTree;
import jrm.ui.basic.JFileDropList;
import jrm.ui.basic.JFileDropMode;
import jrm.ui.basic.JFileDropTextField;
import jrm.ui.basic.JListHintUI;
import jrm.ui.basic.JRMFileChooser;
import jrm.ui.basic.JSDRDropTable;
import jrm.ui.basic.JTableHintUI;
import jrm.ui.basic.JTextFieldHintUI;
import jrm.ui.basic.NGTreeNode;
import jrm.ui.basic.SDRTableModel;
import jrm.ui.batch.BatchTableModel;
import jrm.ui.profile.ProfileViewer;
import jrm.ui.profile.filter.CatVerModel;
import jrm.ui.profile.manager.DirNode;
import jrm.ui.profile.manager.DirTreeCellEditor;
import jrm.ui.profile.manager.DirTreeCellRenderer;
import jrm.ui.profile.manager.DirTreeModel;
import jrm.ui.profile.manager.DirTreeSelectionListener;
import jrm.ui.profile.manager.FileTableCellRenderer;
import jrm.ui.profile.manager.FileTableModel;
import jrm.ui.profile.report.ReportFrame;
import jrm.ui.progress.Progress;
import jrm.ui.progress.ProgressHandler;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.SerializationUtils;

public class MainFrame
extends JFrame {
    public static ProfileViewer profile_viewer = null;
    public static ReportFrame report_frame = null;
    private JButton btnFix;
    private JButton btnRomsDest;
    private JButton btnScan;
    private JComboBox<SevenZipOptions> cb7zArgs;
    private JComboBox<Driver.StatusType> cbbxDriverStatus;
    private JComboBox<Machine.CabinetType> cbbxFilterCabinetType;
    private JComboBox<Machine.DisplayOrientation> cbbxFilterDisplayOrientation;
    private JComboBox<MergeOptions> cbbxMergeMode;
    private JComboBox<Software.Supported> cbbxSWMinSupportedLvl;
    private JComboBox<String> cbbxYearMax;
    private JComboBox<String> cbbxYearMin;
    private JComboBox<FormatOptions> cbCompression;
    private JComboBox<HashCollisionOptions> cbHashCollision;
    private JComboBox<?> cbLogLevel;
    private JComboBox<ZipOptions> cbZipEArgs;
    private JCheckBox chckbxCreateMissingSets;
    private JCheckBox chckbxCreateOnlyComplete;
    private JCheckBox chckbxIgnoreUnknownContainers;
    private JCheckBox chckbxIgnoreUnneededContainers;
    private JCheckBox chckbxIgnoreUnneededEntries;
    private JCheckBox chckbxIncludeClones;
    private JCheckBox chckbxIncludeDisks;
    private JCheckBox chckbxIncludeSamples;
    private JCheckBox chckbxNeedSHA1;
    private JCheckBox chckbxUseImplicitMerge;
    private JCheckBox chckbxUseParallelism;
    private JCheckBoxList<Systm> checkBoxListSystems;
    private JCheckBox ckbx7zSolid;
    private Scan curr_scan;
    private JCheckBox lblDisksDest;
    private JLabel lblMemoryUsage;
    private JLabel lblProfileinfo;
    private JCheckBox lblSamplesDest;
    private JCheckBox lblSWDest;
    private JCheckBox lblSWDisksDest;
    private JCheckBoxList<NPlayers.NPlayer> listNPlayers;
    private JFileDropList listSrcDir;
    private JTabbedPane mainPane;
    private JMenuItem mntmCreateFolder;
    private JMenuItem mntmDeleteFolder;
    private JMenuItem mntmDeleteProfile;
    private JMenuItem mntmDeleteSelected;
    private JMenuItem mntmDropCache;
    private JMenuItem mntmRenameProfile;
    private JMenuItem mntmUpdateFromMame;
    private JTable profilesList;
    private JTree profilesTree;
    private JTabbedPane scannerTabbedPane;
    private JPanel scannerSubSettingsPanel;
    private JScrollPane scrollPane_1;
    private JTabbedPane settingsPane;
    private JFileDropTextField tf7zCmd;
    private JTextField tf7zThreads;
    private JFileDropTextField tfCatVer;
    private JFileDropTextField tfDisksDest;
    private JFileDropTextField tfNPlayers;
    private JFileDropTextField tfSamplesDest;
    private JFileDropTextField tfSWDest;
    private JFileDropTextField tfSWDisksDest;
    private JFileDropTextField tfZipECmd;
    private JTextField tfZipEThreads;
    private JCheckBoxTree treeCatVer;
    private JFileDropTextField txtRomsDest;
    final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    private JComboBox<ZipLevel> cbbxZipLevel;
    private JComboBox<ZipTempThreshold> cbbxZipTempThreshold;
    private JCheckBox chckbxIgnoreMergeNameRoms;
    private JCheckBox chckbxIgnoreMergeNameDisks;
    private JCheckBox chckbxExcludeGames;
    private JCheckBox chckbxExcludeMachines;
    private JCheckBox chckbxBackup;
    private JFileDropTextField tfDir2DatSrc;
    private JFileDropTextField tfDir2DatDst;
    private final ButtonGroup Dir2DatFormatGroup = new ButtonGroup();
    private JTextField tfDir2DatName;
    private JTextField tfDir2DatDescription;
    private JTextField tfDir2DatVersion;
    private JTextField tfDir2DatAuthor;
    private JTextField tfDir2DatComment;
    private JTextField tfDir2DatCategory;
    private JTextField tfDir2DatDate;
    private JTextField tfDir2DatEMail;
    private JTextField tfDir2DatHomepage;
    private JTextField tfDir2DatURL;
    private JFileDropList listBatchToolsDat2DirSrc;
    private JButton btDisksDest;
    private JButton btnSWDest;
    private JButton btSWDisksDest;
    private JButton btSamplesDest;
    private JMenu mnDat2DirPresets;
    private JSDRDropTable tableBatchToolsDat2Dir;
    private JSDRDropTable tableBatchToolsTrntChk;
    private JComboBox<TrntChkMode> cbBatchToolsTrntChk;

    public MainFrame() {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                Settings.setProperty("MainFrame.Bounds", Hex.encodeHexString(SerializationUtils.serialize((Serializable)MainFrame.this.getBounds())));
            }
        });
        try {
            Settings.loadSettings();
            UIManager.setLookAndFeel(Settings.getProperty("LookAndFeel", UIManager.getSystemLookAndFeelClassName()));
            File workdir = Settings.getWorkPath().toFile();
            File xmldir = new File(workdir, "xmlfiles");
            xmldir.mkdir();
            ResourceBundle.getBundle("jrm.resources.Messages");
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, e, "Exception", 0);
            e.printStackTrace();
        }
        this.build();
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            if (Profile.curr_profile != null) {
                Profile.curr_profile.saveSettings();
            }
            Settings.saveSettings();
        }));
    }

    private String getVersion() {
        String version = "";
        Package pkg = this.getClass().getPackage();
        if (pkg.getSpecificationVersion() != null) {
            version = version + " " + pkg.getSpecificationVersion();
        }
        if (pkg.getImplementationVersion() != null) {
            version = version + " " + pkg.getImplementationVersion();
        }
        return version;
    }

    private void build() {
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(MainFrame.class.getResource("/jrm/resources/rom.png")));
        this.setTitle(Messages.getString("MainFrame.Title") + this.getVersion());
        this.setBounds(50, 50, 1007, 601);
        this.setDefaultCloseOperation(3);
        this.getContentPane().setLayout(new BorderLayout(0, 0));
        this.mainPane = new JTabbedPane(1);
        this.getContentPane().add(this.mainPane);
        report_frame = new ReportFrame((Window)this);
        this.buildProfileTab();
        this.buildScannerTab();
        this.buildDir2DatTab();
        this.buildBatchToolsTab();
        this.buildSettingsTab();
        this.pack();
        try {
            this.setBounds((Rectangle)SerializationUtils.deserialize((byte[])Hex.decodeHex(Settings.getProperty("MainFrame.Bounds", Hex.encodeHexString(SerializationUtils.serialize((Serializable)new Rectangle(50, 50, 720, 300)))))));
        }
        catch (DecoderException e1) {
            e1.printStackTrace();
        }
        this.scheduler.scheduleAtFixedRate(() -> this.updateMemory(), 0L, 1L, TimeUnit.MINUTES);
    }

    private void buildProfileTab() {
        JPanel profilesTab = new JPanel();
        this.mainPane.addTab(Messages.getString("MainFrame.Profiles"), new ImageIcon(MainFrame.class.getResource("/jrm/resources/icons/script.png")), profilesTab, null);
        GridBagLayout gbl_profilesTab = new GridBagLayout();
        gbl_profilesTab.columnWidths = new int[]{0, 0};
        gbl_profilesTab.rowHeights = new int[]{0, 0, 0};
        gbl_profilesTab.columnWeights = new double[]{1.0, Double.MIN_VALUE};
        gbl_profilesTab.rowWeights = new double[]{1.0, 0.0, Double.MIN_VALUE};
        profilesTab.setLayout(gbl_profilesTab);
        JSplitPane profilesPanel = new JSplitPane();
        profilesPanel.setContinuousLayout(true);
        profilesPanel.setResizeWeight(0.2);
        profilesPanel.setOneTouchExpandable(true);
        GridBagConstraints gbc_profilesPanel = new GridBagConstraints();
        gbc_profilesPanel.insets = new Insets(0, 0, 5, 0);
        gbc_profilesPanel.fill = 1;
        gbc_profilesPanel.gridx = 0;
        gbc_profilesPanel.gridy = 0;
        profilesTab.add((Component)profilesPanel, gbc_profilesPanel);
        JScrollPane scrollPane = new JScrollPane();
        profilesPanel.setRightComponent(scrollPane);
        this.profilesList = new JTable();
        DefaultCellEditor editor = (DefaultCellEditor)this.profilesList.getDefaultEditor(Object.class);
        editor.setClickCountToStart(3);
        this.profilesList.setShowVerticalLines(false);
        this.profilesList.setShowHorizontalLines(false);
        this.profilesList.setShowGrid(false);
        this.profilesList.setSelectionMode(0);
        this.profilesList.setPreferredScrollableViewportSize(new Dimension(400, 300));
        this.profilesList.setFillsViewportHeight(true);
        scrollPane.setViewportView(this.profilesList);
        final FileTableModel filemodel = new FileTableModel();
        this.profilesList.setModel(filemodel);
        for (int i = 0; i < this.profilesList.getColumnCount(); ++i) {
            TableColumn column = this.profilesList.getColumnModel().getColumn(i);
            column.setCellRenderer(new FileTableCellRenderer());
            if (filemodel.columnsWidths[i] >= 0) {
                column.setPreferredWidth(filemodel.columnsWidths[i]);
                continue;
            }
            int width = this.profilesList.getFontMetrics(this.profilesList.getFont()).stringWidth(String.format("%0" + -filemodel.columnsWidths[i] + "d", 0));
            column.setMinWidth(width);
            column.setMaxWidth(width);
        }
        this.profilesList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                JTable target;
                int row;
                if (e.getClickCount() == 2 && (row = (target = (JTable)e.getSource()).getSelectedRow()) >= 0) {
                    MainFrame.this.loadProfile(filemodel.getNfoAt(row));
                }
            }
        });
        this.scrollPane_1 = new JScrollPane();
        this.scrollPane_1.setMinimumSize(new Dimension(80, 22));
        profilesPanel.setLeftComponent(this.scrollPane_1);
        this.profilesTree = new JTree();
        this.scrollPane_1.setViewportView(this.profilesTree);
        DirTreeModel profilesTreeModel = new DirTreeModel(new DirNode(Settings.getWorkPath().resolve("xmlfiles").toAbsolutePath().normalize().toFile()));
        this.profilesTree.setModel(profilesTreeModel);
        this.profilesTree.setRootVisible(true);
        this.profilesTree.setShowsRootHandles(true);
        this.profilesTree.setEditable(true);
        DirTreeCellRenderer profilesTreeRenderer = new DirTreeCellRenderer();
        this.profilesTree.setCellRenderer(profilesTreeRenderer);
        this.profilesTree.setCellEditor(new DirTreeCellEditor(this.profilesTree, profilesTreeRenderer));
        this.profilesTree.getSelectionModel().setSelectionMode(1);
        this.profilesTree.addTreeSelectionListener(new DirTreeSelectionListener(this.profilesList));
        JPopupMenu popupMenu_1 = new JPopupMenu();
        popupMenu_1.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                MainFrame.this.mntmDeleteProfile.setEnabled(MainFrame.this.profilesList.getSelectedRowCount() > 0);
                MainFrame.this.mntmRenameProfile.setEnabled(MainFrame.this.profilesList.getSelectedRowCount() > 0);
                MainFrame.this.mntmDropCache.setEnabled(MainFrame.this.profilesList.getSelectedRowCount() > 0);
                MainFrame.this.mntmUpdateFromMame.setEnabled(MainFrame.this.profilesList.getSelectedRowCount() > 0 && EnumSet.of(ProfileNFOMame.MameStatus.NEEDUPDATE, ProfileNFOMame.MameStatus.NOTFOUND).contains((Object)filemodel.getNfoAt((int)((MainFrame)MainFrame.this).profilesList.getSelectedRow()).mame.getStatus()));
                if (MainFrame.this.profilesList.getSelectedRowCount() > 0) {
                    MainFrame.this.mntmUpdateFromMame.setText(Messages.getString("MainFrame.mntmUpdateFromMame.text") + " (" + filemodel.getNfoAt((int)((MainFrame)MainFrame.this).profilesList.getSelectedRow()).mame.getStatus().getMsg() + ")");
                } else {
                    MainFrame.this.mntmUpdateFromMame.setText(Messages.getString("MainFrame.mntmUpdateFromMame.text"));
                }
            }
        });
        MainFrame.addPopup(this.profilesList, popupMenu_1);
        this.mntmDeleteProfile = new JMenuItem(Messages.getString("MainFrame.mntmDeleteProfile.text"));
        this.mntmDeleteProfile.addActionListener(e -> {
            int row = this.profilesList.getSelectedRow();
            if (row >= 0) {
                ProfileNFO nfo = filemodel.getNfoAt(row);
                if ((Profile.curr_profile == null || !Profile.curr_profile.nfo.equals(nfo)) && nfo.delete()) {
                    filemodel.populate();
                }
            }
        });
        this.mntmDeleteProfile.setIcon(new ImageIcon(MainFrame.class.getResource("/jrm/resources/icons/script_delete.png")));
        popupMenu_1.add(this.mntmDeleteProfile);
        this.mntmRenameProfile = new JMenuItem(Messages.getString("MainFrame.mntmRenameProfile.text"));
        this.mntmRenameProfile.addActionListener(e -> {
            int row = this.profilesList.getSelectedRow();
            if (row >= 0) {
                this.profilesList.editCellAt(row, 0);
            }
        });
        this.mntmRenameProfile.setIcon(new ImageIcon(MainFrame.class.getResource("/jrm/resources/icons/script_edit.png")));
        popupMenu_1.add(this.mntmRenameProfile);
        this.mntmDropCache = new JMenuItem(Messages.getString("MainFrame.mntmDropCache.text"));
        this.mntmDropCache.addActionListener(e -> {
            int row = this.profilesList.getSelectedRow();
            if (row >= 0) {
                new File(filemodel.getFileAt(row).getAbsolutePath() + ".cache").delete();
            }
        });
        this.mntmDropCache.setIcon(new ImageIcon(MainFrame.class.getResource("/jrm/resources/icons/bin.png")));
        popupMenu_1.add(this.mntmDropCache);
        JSeparator separator = new JSeparator();
        popupMenu_1.add(separator);
        this.mntmUpdateFromMame = new JMenuItem(Messages.getString("MainFrame.mntmUpdateFromMame.text"));
        this.mntmUpdateFromMame.addActionListener(e -> {
            int row = this.profilesList.getSelectedRow();
            if (row >= 0) {
                try {
                    ProfileNFO nfo = filemodel.getNfoAt(row);
                    if (nfo.mame.getStatus() == ProfileNFOMame.MameStatus.NEEDUPDATE || nfo.mame.getStatus() == ProfileNFOMame.MameStatus.NOTFOUND && new JRMFileChooser<ProfileNFOMame.MameStatus>(0, 0, null, nfo.mame.getFile(), null, Messages.getString("MainFrame.ChooseMameNewLocation"), false).show(this, chooser -> {
                        if (chooser.getSelectedFile().exists()) {
                            return nfo.mame.relocate(chooser.getSelectedFile());
                        }
                        return ProfileNFOMame.MameStatus.NOTFOUND;
                    }) == ProfileNFOMame.MameStatus.NEEDUPDATE) {
                        Import imprt = new Import(nfo.mame.getFile(), nfo.mame.isSL());
                        nfo.mame.delete();
                        nfo.mame.fileroms = new File(nfo.file.getParentFile(), imprt.roms_file.getName());
                        Files.copy(imprt.roms_file.toPath(), nfo.mame.fileroms.toPath(), StandardCopyOption.COPY_ATTRIBUTES, StandardCopyOption.REPLACE_EXISTING);
                        if (nfo.mame.isSL()) {
                            nfo.mame.filesl = new File(nfo.file.getParentFile(), imprt.sl_file.getName());
                            Files.copy(imprt.sl_file.toPath(), nfo.mame.filesl.toPath(), StandardCopyOption.COPY_ATTRIBUTES, StandardCopyOption.REPLACE_EXISTING);
                        }
                        nfo.mame.setUpdated();
                        nfo.stats.reset();
                        nfo.save();
                    }
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        });
        popupMenu_1.add(this.mntmUpdateFromMame);
        this.profilesTree.setSelectionRow(0);
        JPopupMenu popupMenu = new JPopupMenu();
        popupMenu.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                MainFrame.this.mntmCreateFolder.setEnabled(MainFrame.this.profilesTree.getSelectionCount() > 0);
                MainFrame.this.mntmDeleteFolder.setEnabled(MainFrame.this.profilesTree.getSelectionCount() > 0 && !((DirNode)MainFrame.this.profilesTree.getLastSelectedPathComponent()).isRoot());
            }
        });
        MainFrame.addPopup(this.profilesTree, popupMenu);
        this.mntmCreateFolder = new JMenuItem(Messages.getString("MainFrame.mntmCreateFolder.text"));
        this.mntmCreateFolder.addActionListener(e -> {
            DirNode selectedNode = (DirNode)this.profilesTree.getLastSelectedPathComponent();
            if (selectedNode != null) {
                DirNode newnode = new DirNode(new Dir(new File(selectedNode.getDir().getFile(), Messages.getString("MainFrame.NewFolder"))));
                selectedNode.add(newnode);
                profilesTreeModel.reload(selectedNode);
                TreePath path = new TreePath(newnode.getPath());
                this.profilesTree.setSelectionPath(path);
                this.profilesTree.startEditingAtPath(path);
            }
        });
        this.mntmCreateFolder.setIcon(new ImageIcon(MainFrame.class.getResource("/jrm/resources/icons/folder_add.png")));
        popupMenu.add(this.mntmCreateFolder);
        this.mntmDeleteFolder = new JMenuItem(Messages.getString("MainFrame.mntmDeleteFolder.text"));
        this.mntmDeleteFolder.addActionListener(e -> {
            DirNode selectedNode = (DirNode)this.profilesTree.getLastSelectedPathComponent();
            if (selectedNode != null) {
                DirNode parent = (DirNode)selectedNode.getParent();
                profilesTreeModel.removeNodeFromParent(selectedNode);
                TreePath path = new TreePath(parent.getPath());
                this.profilesTree.setSelectionPath(path);
            }
        });
        this.mntmDeleteFolder.setIcon(new ImageIcon(MainFrame.class.getResource("/jrm/resources/icons/folder_delete.png")));
        popupMenu.add(this.mntmDeleteFolder);
        JPanel profilesBtnPanel = new JPanel();
        GridBagConstraints gbc_profilesBtnPanel = new GridBagConstraints();
        gbc_profilesBtnPanel.fill = 2;
        gbc_profilesBtnPanel.gridx = 0;
        gbc_profilesBtnPanel.gridy = 1;
        profilesTab.add((Component)profilesBtnPanel, gbc_profilesBtnPanel);
        JButton btnLoadProfile = new JButton(Messages.getString("MainFrame.btnLoadProfile.text"));
        btnLoadProfile.setIcon(new ImageIcon(MainFrame.class.getResource("/jrm/resources/icons/add.png")));
        btnLoadProfile.setEnabled(false);
        btnLoadProfile.addActionListener(e -> {});
        profilesBtnPanel.add(btnLoadProfile);
        JButton btnImportDat = new JButton(Messages.getString("MainFrame.btnImportDat.text"));
        btnImportDat.setIcon(new ImageIcon(MainFrame.class.getResource("/jrm/resources/icons/script_go.png")));
        btnImportDat.addActionListener(e -> this.importDat(false));
        profilesBtnPanel.add(btnImportDat);
        JButton btnImportSL = new JButton(Messages.getString("MainFrame.btnImportSL.text"));
        btnImportSL.addActionListener(e -> this.importDat(true));
        btnImportSL.setIcon(new ImageIcon(MainFrame.class.getResource("/jrm/resources/icons/application_go.png")));
        profilesBtnPanel.add(btnImportSL);
    }

    private void buildScannerTab() {
        JPanel scannerTab = new JPanel();
        this.mainPane.addTab(Messages.getString("MainFrame.Scanner"), new ImageIcon(MainFrame.class.getResource("/jrm/resources/icons/drive_magnify.png")), scannerTab, null);
        this.mainPane.setEnabledAt(1, false);
        GridBagLayout gbl_scannerTab = new GridBagLayout();
        gbl_scannerTab.columnWidths = new int[]{104, 0};
        gbl_scannerTab.rowHeights = new int[]{0, 0, 24, 0};
        gbl_scannerTab.columnWeights = new double[]{1.0, Double.MIN_VALUE};
        gbl_scannerTab.rowWeights = new double[]{0.0, 1.0, 0.0, Double.MIN_VALUE};
        scannerTab.setLayout(gbl_scannerTab);
        JPanel scannerBtnPanel = new JPanel();
        GridBagConstraints gbc_scannerBtnPanel = new GridBagConstraints();
        gbc_scannerBtnPanel.insets = new Insets(0, 0, 5, 0);
        gbc_scannerBtnPanel.fill = 1;
        gbc_scannerBtnPanel.gridx = 0;
        gbc_scannerBtnPanel.gridy = 0;
        scannerTab.add((Component)scannerBtnPanel, gbc_scannerBtnPanel);
        JButton btnInfo = new JButton(Messages.getString("MainFrame.btnInfo.text"));
        btnInfo.addActionListener(e -> {
            if (profile_viewer == null) {
                profile_viewer = new ProfileViewer((Window)this, Profile.curr_profile);
            }
            profile_viewer.setVisible(true);
        });
        btnInfo.setIcon(new ImageIcon(MainFrame.class.getResource("/jrm/resources/icons/information.png")));
        scannerBtnPanel.add(btnInfo);
        this.btnScan = new JButton(Messages.getString("MainFrame.btnScan.text"));
        this.btnScan.setIcon(new ImageIcon(MainFrame.class.getResource("/jrm/resources/icons/magnifier.png")));
        scannerBtnPanel.add(this.btnScan);
        this.btnScan.setEnabled(false);
        JButton btnReport = new JButton(Messages.getString("MainFrame.btnReport.text"));
        btnReport.setIcon(new ImageIcon(MainFrame.class.getResource("/jrm/resources/icons/report.png")));
        btnReport.addActionListener(e -> EventQueue.invokeLater(() -> report_frame.setVisible(true)));
        scannerBtnPanel.add(btnReport);
        this.btnFix = new JButton(Messages.getString("MainFrame.btnFix.text"));
        this.btnFix.setIcon(new ImageIcon(MainFrame.class.getResource("/jrm/resources/icons/tick.png")));
        scannerBtnPanel.add(this.btnFix);
        this.btnFix.addActionListener(e -> this.fix());
        this.btnFix.setEnabled(false);
        this.btnScan.addActionListener(e -> this.scan());
        this.scannerTabbedPane = new JTabbedPane(1);
        GridBagConstraints gbc_scannerTabbedPane = new GridBagConstraints();
        gbc_scannerTabbedPane.fill = 1;
        gbc_scannerTabbedPane.gridx = 0;
        gbc_scannerTabbedPane.gridy = 1;
        scannerTab.add((Component)this.scannerTabbedPane, gbc_scannerTabbedPane);
        this.buildScannerDirTab();
        this.buildScannerSettingsTab();
        this.buildScannerFiltersTab();
        this.buildScannerAdvFiltersTab();
        this.lblProfileinfo = new JLabel("");
        this.lblProfileinfo.setBorder(new BevelBorder(1, null, null, null, null));
        GridBagConstraints gbc_lblProfileinfo = new GridBagConstraints();
        gbc_lblProfileinfo.insets = new Insets(0, 2, 0, 2);
        gbc_lblProfileinfo.fill = 1;
        gbc_lblProfileinfo.gridx = 0;
        gbc_lblProfileinfo.gridy = 2;
        scannerTab.add((Component)this.lblProfileinfo, gbc_lblProfileinfo);
    }

    private void buildScannerDirTab() {
        JPanel scannerDirectories = new JPanel();
        this.scannerTabbedPane.addTab(Messages.getString("MainFrame.scannerDirectories.title"), null, scannerDirectories, null);
        GridBagLayout gbl_scannerDirectories = new GridBagLayout();
        gbl_scannerDirectories.columnWidths = new int[]{109, 65, 0, 0};
        gbl_scannerDirectories.rowHeights = new int[]{26, 0, 0, 0, 0, 0, 0};
        gbl_scannerDirectories.columnWeights = new double[]{0.0, 1.0, 0.0, Double.MIN_VALUE};
        gbl_scannerDirectories.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 1.0, Double.MIN_VALUE};
        scannerDirectories.setLayout(gbl_scannerDirectories);
        JLabel lblRomsDest = new JLabel(Messages.getString("MainFrame.lblRomsDest.text"));
        lblRomsDest.setHorizontalAlignment(11);
        GridBagConstraints gbc_lblRomsDest = new GridBagConstraints();
        gbc_lblRomsDest.fill = 2;
        gbc_lblRomsDest.insets = new Insets(5, 0, 5, 5);
        gbc_lblRomsDest.gridx = 0;
        gbc_lblRomsDest.gridy = 0;
        scannerDirectories.add((Component)lblRomsDest, gbc_lblRomsDest);
        this.txtRomsDest = new JFileDropTextField(txt -> Profile.curr_profile.setProperty("roms_dest_dir", txt));
        this.txtRomsDest.setMode(JFileDropMode.DIRECTORY);
        this.txtRomsDest.setUI(new JTextFieldHintUI(Messages.getString("MainFrame.DropDirHint"), Color.gray));
        this.txtRomsDest.setColumns(10);
        GridBagConstraints gbc_txtRomsDest = new GridBagConstraints();
        gbc_txtRomsDest.fill = 1;
        gbc_txtRomsDest.insets = new Insets(5, 0, 5, 0);
        gbc_txtRomsDest.gridx = 1;
        gbc_txtRomsDest.gridy = 0;
        scannerDirectories.add((Component)this.txtRomsDest, gbc_txtRomsDest);
        this.btnRomsDest = new JButton("");
        GridBagConstraints gbc_btnRomsDest = new GridBagConstraints();
        gbc_btnRomsDest.anchor = 18;
        gbc_btnRomsDest.insets = new Insets(5, 0, 5, 5);
        gbc_btnRomsDest.gridx = 2;
        gbc_btnRomsDest.gridy = 0;
        scannerDirectories.add((Component)this.btnRomsDest, gbc_btnRomsDest);
        this.btnRomsDest.setIcon(new ImageIcon(MainFrame.class.getResource("/jrm/resources/icons/disk.png")));
        this.btnRomsDest.addActionListener(e -> {
            File workdir = Settings.getWorkPath().toFile();
            new JRMFileChooser<Void>(0, 1, new File(Profile.curr_profile.getProperty("MainFrame.ChooseRomsDestination", workdir.getAbsolutePath())), new File(this.txtRomsDest.getText()), null, Messages.getString("MainFrame.ChooseRomsDestination"), false).show(this, chooser -> {
                Profile.curr_profile.setProperty("MainFrame.ChooseRomsDestination", chooser.getCurrentDirectory().getAbsolutePath());
                this.txtRomsDest.setText(chooser.getSelectedFile().getAbsolutePath());
                Profile.curr_profile.setProperty("roms_dest_dir", this.txtRomsDest.getText());
                return null;
            });
        });
        this.lblDisksDest = new JCheckBox(Messages.getString("MainFrame.lblDisksDest.text"));
        this.lblDisksDest.addItemListener(e -> {
            this.tfDisksDest.setEnabled(e.getStateChange() == 1);
            this.btDisksDest.setEnabled(e.getStateChange() == 1);
            Profile.curr_profile.setProperty("disks_dest_dir_enabled", e.getStateChange() == 1);
        });
        this.lblDisksDest.setHorizontalAlignment(11);
        GridBagConstraints gbc_lblDisksDest = new GridBagConstraints();
        gbc_lblDisksDest.fill = 2;
        gbc_lblDisksDest.insets = new Insets(0, 0, 5, 5);
        gbc_lblDisksDest.gridx = 0;
        gbc_lblDisksDest.gridy = 1;
        scannerDirectories.add((Component)this.lblDisksDest, gbc_lblDisksDest);
        this.tfDisksDest = new JFileDropTextField(txt -> Profile.curr_profile.setProperty("disks_dest_dir", txt));
        this.tfDisksDest.setMode(JFileDropMode.DIRECTORY);
        this.tfDisksDest.setEnabled(false);
        this.tfDisksDest.setUI(new JTextFieldHintUI(Messages.getString("MainFrame.DropDirHint"), Color.gray));
        this.tfDisksDest.setText("");
        GridBagConstraints gbc_tfDisksDest = new GridBagConstraints();
        gbc_tfDisksDest.insets = new Insets(0, 0, 5, 0);
        gbc_tfDisksDest.fill = 1;
        gbc_tfDisksDest.gridx = 1;
        gbc_tfDisksDest.gridy = 1;
        scannerDirectories.add((Component)this.tfDisksDest, gbc_tfDisksDest);
        this.tfDisksDest.setColumns(10);
        this.btDisksDest = new JButton("");
        this.btDisksDest.setEnabled(false);
        this.btDisksDest.setIcon(new ImageIcon(MainFrame.class.getResource("/jrm/resources/icons/disk.png")));
        GridBagConstraints gbc_btDisksDest = new GridBagConstraints();
        gbc_btDisksDest.insets = new Insets(0, 0, 5, 5);
        gbc_btDisksDest.gridx = 2;
        gbc_btDisksDest.gridy = 1;
        this.btDisksDest.addActionListener(e -> {
            File workdir = Settings.getWorkPath().toFile();
            new JRMFileChooser<Void>(0, 1, new File(Profile.curr_profile.getProperty("MainFrame.ChooseDisksDestination", workdir.getAbsolutePath())), new File(this.tfDisksDest.getText()), null, Messages.getString("MainFrame.ChooseDisksDestination"), false).show(this, chooser -> {
                Profile.curr_profile.setProperty("MainFrame.ChooseDisksDestination", chooser.getCurrentDirectory().getAbsolutePath());
                this.tfDisksDest.setText(chooser.getSelectedFile().getAbsolutePath());
                Profile.curr_profile.setProperty("disks_dest_dir", this.tfDisksDest.getText());
                return null;
            });
        });
        scannerDirectories.add((Component)this.btDisksDest, gbc_btDisksDest);
        this.lblSWDest = new JCheckBox(Messages.getString("MainFrame.chckbxSoftwareDest.text"));
        this.lblSWDest.addItemListener(e -> {
            this.tfSWDest.setEnabled(e.getStateChange() == 1);
            this.btnSWDest.setEnabled(e.getStateChange() == 1);
            Profile.curr_profile.setProperty("swroms_dest_dir_enabled", e.getStateChange() == 1);
        });
        this.lblSWDest.setHorizontalAlignment(11);
        GridBagConstraints gbc_lblSWDest = new GridBagConstraints();
        gbc_lblSWDest.fill = 2;
        gbc_lblSWDest.insets = new Insets(0, 0, 5, 5);
        gbc_lblSWDest.gridx = 0;
        gbc_lblSWDest.gridy = 2;
        scannerDirectories.add((Component)this.lblSWDest, gbc_lblSWDest);
        this.tfSWDest = new JFileDropTextField(txt -> Profile.curr_profile.setProperty("swroms_dest_dir", txt));
        this.tfSWDest.setMode(JFileDropMode.DIRECTORY);
        this.tfSWDest.setEnabled(false);
        this.tfSWDest.setUI(new JTextFieldHintUI(Messages.getString("MainFrame.DropDirHint"), Color.gray));
        this.tfSWDest.setText("");
        GridBagConstraints gbc_tfSWDest = new GridBagConstraints();
        gbc_tfSWDest.insets = new Insets(0, 0, 5, 0);
        gbc_tfSWDest.fill = 1;
        gbc_tfSWDest.gridx = 1;
        gbc_tfSWDest.gridy = 2;
        scannerDirectories.add((Component)this.tfSWDest, gbc_tfSWDest);
        this.tfSWDest.setColumns(10);
        this.btnSWDest = new JButton("");
        this.btnSWDest.addActionListener(e -> {
            File workdir = Settings.getWorkPath().toFile();
            new JRMFileChooser<Void>(0, 1, new File(Profile.curr_profile.getProperty("MainFrame.ChooseSWRomsDestination", workdir.getAbsolutePath())), new File(this.tfSWDest.getText()), null, Messages.getString("MainFrame.ChooseSWRomsDestination"), false).show(this, chooser -> {
                Profile.curr_profile.setProperty("MainFrame.ChooseSWRomsDestination", chooser.getCurrentDirectory().getAbsolutePath());
                this.tfSWDest.setText(chooser.getSelectedFile().getAbsolutePath());
                Profile.curr_profile.setProperty("swroms_dest_dir", this.tfSWDest.getText());
                return null;
            });
        });
        this.btnSWDest.setEnabled(false);
        this.btnSWDest.setIcon(new ImageIcon(MainFrame.class.getResource("/jrm/resources/icons/disk.png")));
        GridBagConstraints gbc_btnSWDest = new GridBagConstraints();
        gbc_btnSWDest.insets = new Insets(0, 0, 5, 5);
        gbc_btnSWDest.gridx = 2;
        gbc_btnSWDest.gridy = 2;
        scannerDirectories.add((Component)this.btnSWDest, gbc_btnSWDest);
        this.lblSWDisksDest = new JCheckBox(Messages.getString("MainFrame.chckbxSwdisksdest.text"));
        this.lblSWDisksDest.addItemListener(e -> {
            this.tfSWDisksDest.setEnabled(e.getStateChange() == 1);
            this.btSWDisksDest.setEnabled(e.getStateChange() == 1);
            Profile.curr_profile.setProperty("swdisks_dest_dir_enabled", e.getStateChange() == 1);
        });
        GridBagConstraints gbc_lblSWDisksDest = new GridBagConstraints();
        gbc_lblSWDisksDest.insets = new Insets(0, 0, 5, 5);
        gbc_lblSWDisksDest.gridx = 0;
        gbc_lblSWDisksDest.gridy = 3;
        scannerDirectories.add((Component)this.lblSWDisksDest, gbc_lblSWDisksDest);
        this.tfSWDisksDest = new JFileDropTextField(txt -> Profile.curr_profile.setProperty("swdisks_dest_dir", txt));
        this.tfSWDisksDest.setMode(JFileDropMode.DIRECTORY);
        this.tfSWDisksDest.setEnabled(false);
        this.tfSWDisksDest.setUI(new JTextFieldHintUI(Messages.getString("MainFrame.DropDirHint"), Color.gray));
        this.tfSWDisksDest.setText("");
        GridBagConstraints gbc_tfSWDisksDest = new GridBagConstraints();
        gbc_tfSWDisksDest.insets = new Insets(0, 0, 5, 0);
        gbc_tfSWDisksDest.fill = 1;
        gbc_tfSWDisksDest.gridx = 1;
        gbc_tfSWDisksDest.gridy = 3;
        scannerDirectories.add((Component)this.tfSWDisksDest, gbc_tfSWDisksDest);
        this.tfSWDisksDest.setColumns(10);
        this.btSWDisksDest = new JButton("");
        this.btSWDisksDest.addActionListener(e -> {
            File workdir = Settings.getWorkPath().toFile();
            new JRMFileChooser<Boolean>(0, 1, new File(Profile.curr_profile.getProperty("MainFrame.ChooseSWDisksDestination", workdir.getAbsolutePath())), new File(this.tfSWDisksDest.getText()), null, Messages.getString("MainFrame.ChooseSWDisksDestination"), false).show(this, chooser -> {
                Profile.curr_profile.setProperty("MainFrame.ChooseSWDisksDestination", chooser.getCurrentDirectory().getAbsolutePath());
                this.tfSWDisksDest.setText(chooser.getSelectedFile().getAbsolutePath());
                Profile.curr_profile.setProperty("swdisks_dest_dir", this.tfSWDisksDest.getText());
                return true;
            });
        });
        this.btSWDisksDest.setEnabled(false);
        this.btSWDisksDest.setIcon(new ImageIcon(MainFrame.class.getResource("/jrm/resources/icons/disk.png")));
        GridBagConstraints gbc_btSWDisksDest = new GridBagConstraints();
        gbc_btSWDisksDest.insets = new Insets(0, 0, 5, 5);
        gbc_btSWDisksDest.gridx = 2;
        gbc_btSWDisksDest.gridy = 3;
        scannerDirectories.add((Component)this.btSWDisksDest, gbc_btSWDisksDest);
        this.lblSamplesDest = new JCheckBox(Messages.getString("MainFrame.lblSamplesDest.text"));
        this.lblSamplesDest.addItemListener(e -> {
            this.tfSamplesDest.setEnabled(e.getStateChange() == 1);
            this.btSamplesDest.setEnabled(e.getStateChange() == 1);
            Profile.curr_profile.setProperty("samples_dest_dir_enabled", e.getStateChange() == 1);
        });
        this.lblSamplesDest.setHorizontalAlignment(11);
        GridBagConstraints gbc_lblSamplesDest = new GridBagConstraints();
        gbc_lblSamplesDest.fill = 2;
        gbc_lblSamplesDest.insets = new Insets(0, 0, 5, 5);
        gbc_lblSamplesDest.gridx = 0;
        gbc_lblSamplesDest.gridy = 4;
        scannerDirectories.add((Component)this.lblSamplesDest, gbc_lblSamplesDest);
        this.tfSamplesDest = new JFileDropTextField(txt -> Profile.curr_profile.setProperty("samples_dest_dir", txt));
        this.tfSamplesDest.setMode(JFileDropMode.DIRECTORY);
        this.tfSamplesDest.setEnabled(false);
        this.tfSamplesDest.setUI(new JTextFieldHintUI(Messages.getString("MainFrame.DropDirHint"), Color.gray));
        this.tfSamplesDest.setText("");
        GridBagConstraints gbc_tfSamplesDest = new GridBagConstraints();
        gbc_tfSamplesDest.insets = new Insets(0, 0, 5, 0);
        gbc_tfSamplesDest.fill = 1;
        gbc_tfSamplesDest.gridx = 1;
        gbc_tfSamplesDest.gridy = 4;
        scannerDirectories.add((Component)this.tfSamplesDest, gbc_tfSamplesDest);
        this.tfSamplesDest.setColumns(10);
        this.btSamplesDest = new JButton("");
        this.btSamplesDest.addActionListener(e -> {
            File workdir = Settings.getWorkPath().toFile();
            new JRMFileChooser<Boolean>(0, 1, new File(Profile.curr_profile.getProperty("MainFrame.ChooseSamplesDestination", workdir.getAbsolutePath())), new File(this.tfSamplesDest.getText()), null, Messages.getString("MainFrame.ChooseSamplesDestination"), false).show(this, chooser -> {
                Profile.curr_profile.setProperty("MainFrame.ChooseSamplesDestination", chooser.getCurrentDirectory().getAbsolutePath());
                this.tfSamplesDest.setText(chooser.getSelectedFile().getAbsolutePath());
                Profile.curr_profile.setProperty("samples_dest_dir", this.tfSamplesDest.getText());
                return true;
            });
        });
        this.btSamplesDest.setEnabled(false);
        this.btSamplesDest.setIcon(new ImageIcon(MainFrame.class.getResource("/jrm/resources/icons/disk.png")));
        GridBagConstraints gbc_btSamplesDest = new GridBagConstraints();
        gbc_btSamplesDest.insets = new Insets(0, 0, 5, 5);
        gbc_btSamplesDest.gridx = 2;
        gbc_btSamplesDest.gridy = 4;
        scannerDirectories.add((Component)this.btSamplesDest, gbc_btSamplesDest);
        JLabel lblSrcDir = new JLabel(Messages.getString("MainFrame.lblSrcDir.text"));
        lblSrcDir.setHorizontalAlignment(11);
        GridBagConstraints gbc_lblSrcDir = new GridBagConstraints();
        gbc_lblSrcDir.fill = 2;
        gbc_lblSrcDir.anchor = 11;
        gbc_lblSrcDir.insets = new Insets(0, 0, 0, 5);
        gbc_lblSrcDir.gridx = 0;
        gbc_lblSrcDir.gridy = 5;
        scannerDirectories.add((Component)lblSrcDir, gbc_lblSrcDir);
        this.listSrcDir = new JFileDropList(files -> Profile.curr_profile.setProperty("src_dir", String.join((CharSequence)"|", files.stream().map(f -> f.getAbsolutePath()).collect(Collectors.toList()))));
        this.listSrcDir.setMode(JFileDropMode.DIRECTORY);
        this.listSrcDir.setUI(new JListHintUI(Messages.getString("MainFrame.DropDirHint"), Color.gray));
        GridBagConstraints gbc_listSrcDir = new GridBagConstraints();
        gbc_listSrcDir.insets = new Insets(0, 0, 5, 5);
        gbc_listSrcDir.gridwidth = 2;
        gbc_listSrcDir.fill = 1;
        gbc_listSrcDir.gridx = 1;
        gbc_listSrcDir.gridy = 5;
        scannerDirectories.add((Component)this.listSrcDir, gbc_listSrcDir);
        this.listSrcDir.setBorder(new BevelBorder(1, null, null, null, null));
        JPopupMenu popupMenu = new JPopupMenu();
        popupMenu.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                MainFrame.this.mntmDeleteSelected.setEnabled(MainFrame.this.listSrcDir.getSelectedValuesList().size() > 0);
            }
        });
        MainFrame.addPopup(this.listSrcDir, popupMenu);
        this.mntmDeleteSelected = new JMenuItem(Messages.getString("MainFrame.mntmDeleteSelected.text"));
        this.mntmDeleteSelected.addActionListener(e -> this.listSrcDir.del(this.listSrcDir.getSelectedValuesList()));
        this.mntmDeleteSelected.setIcon(new ImageIcon(MainFrame.class.getResource("/jrm/resources/icons/folder_delete.png")));
        popupMenu.add(this.mntmDeleteSelected);
        JMenuItem mntmAddDirectory = new JMenuItem(Messages.getString("MainFrame.mntmAddDirectory.text"));
        mntmAddDirectory.addActionListener(e -> {
            File workdir = Settings.getWorkPath().toFile();
            new JRMFileChooser<Boolean>(0, 1, new File(Profile.curr_profile.getProperty("MainFrame.ChooseRomsSource", workdir.getAbsolutePath())), null, null, null, true).show(this, chooser -> {
                Profile.curr_profile.setProperty("MainFrame.ChooseRomsSource", chooser.getCurrentDirectory().getAbsolutePath());
                this.listSrcDir.add(chooser.getSelectedFiles());
                return true;
            });
        });
        mntmAddDirectory.setIcon(new ImageIcon(MainFrame.class.getResource("/jrm/resources/icons/folder_add.png")));
        popupMenu.add(mntmAddDirectory);
    }

    private void buildScannerSettingsTab() {
        JPanel scannerSettingsPanel = new JPanel();
        this.scannerTabbedPane.addTab(Messages.getString("MainFrame.scannerSettingsPanel.title"), null, scannerSettingsPanel, null);
        scannerSettingsPanel.setBackground(UIManager.getColor("Panel.background"));
        JPopupMenu popupMenu_4 = new JPopupMenu();
        MainFrame.addPopup(scannerSettingsPanel, popupMenu_4);
        JMenu mnPresets = new JMenu(Messages.getString("MainFrame.mnPresets.text"));
        popupMenu_4.add(mnPresets);
        JMenu mnPdMame = new JMenu(Messages.getString("MainFrame.mnPdMame.text"));
        mnPresets.add(mnPdMame);
        JMenuItem mntmPleasuredome = new JMenuItem(Messages.getString("MainFrame.mntmPleasuredome.text"));
        mnPdMame.add(mntmPleasuredome);
        JMenuItem mntmPdMameNon = new JMenuItem(Messages.getString("MainFrame.mntmPdMameNon.text"));
        mnPdMame.add(mntmPdMameNon);
        JMenuItem mntmPdMameSplit = new JMenuItem(Messages.getString("MainFrame.mntmPdMameSplit.text"));
        mnPdMame.add(mntmPdMameSplit);
        mntmPdMameSplit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame.this.chckbxCreateMissingSets.setSelected(true);
                MainFrame.this.chckbxCreateOnlyComplete.setSelected(false);
                MainFrame.this.chckbxIgnoreUnneededContainers.setSelected(false);
                MainFrame.this.chckbxIgnoreUnneededEntries.setSelected(false);
                MainFrame.this.chckbxIgnoreUnknownContainers.setSelected(true);
                MainFrame.this.chckbxUseImplicitMerge.setSelected(true);
                MainFrame.this.chckbxIgnoreMergeNameDisks.setSelected(true);
                MainFrame.this.chckbxIgnoreMergeNameRoms.setSelected(false);
                MainFrame.this.cbCompression.setSelectedItem((Object)FormatOptions.TZIP);
                MainFrame.this.cbbxMergeMode.setSelectedItem((Object)MergeOptions.SPLIT);
            }
        });
        mntmPdMameNon.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame.this.chckbxCreateMissingSets.setSelected(true);
                MainFrame.this.chckbxCreateOnlyComplete.setSelected(false);
                MainFrame.this.chckbxIgnoreUnneededContainers.setSelected(false);
                MainFrame.this.chckbxIgnoreUnneededEntries.setSelected(false);
                MainFrame.this.chckbxIgnoreUnknownContainers.setSelected(true);
                MainFrame.this.chckbxUseImplicitMerge.setSelected(true);
                MainFrame.this.chckbxIgnoreMergeNameDisks.setSelected(true);
                MainFrame.this.chckbxIgnoreMergeNameRoms.setSelected(false);
                MainFrame.this.cbCompression.setSelectedItem((Object)FormatOptions.TZIP);
                MainFrame.this.cbbxMergeMode.setSelectedItem((Object)MergeOptions.SUPERFULLNOMERGE);
            }
        });
        mntmPleasuredome.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame.this.chckbxCreateMissingSets.setSelected(true);
                MainFrame.this.chckbxCreateOnlyComplete.setSelected(false);
                MainFrame.this.chckbxIgnoreUnneededContainers.setSelected(false);
                MainFrame.this.chckbxIgnoreUnneededEntries.setSelected(false);
                MainFrame.this.chckbxIgnoreUnknownContainers.setSelected(true);
                MainFrame.this.chckbxUseImplicitMerge.setSelected(true);
                MainFrame.this.chckbxIgnoreMergeNameDisks.setSelected(true);
                MainFrame.this.chckbxIgnoreMergeNameRoms.setSelected(false);
                MainFrame.this.cbCompression.setSelectedItem((Object)FormatOptions.TZIP);
                MainFrame.this.cbbxMergeMode.setSelectedItem((Object)MergeOptions.MERGE);
                MainFrame.this.cbHashCollision.setSelectedItem((Object)HashCollisionOptions.HALFDUMB);
            }
        });
        GridBagLayout gbl_scannerSettingsPanel = new GridBagLayout();
        gbl_scannerSettingsPanel.columnWidths = new int[]{0, 0, 0};
        gbl_scannerSettingsPanel.rowHeights = new int[]{20, 20, 0, 0, 0, 0, 0, 20, 0};
        gbl_scannerSettingsPanel.columnWeights = new double[]{1.0, 1.0, Double.MIN_VALUE};
        gbl_scannerSettingsPanel.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, Double.MIN_VALUE};
        scannerSettingsPanel.setLayout(gbl_scannerSettingsPanel);
        this.chckbxNeedSHA1 = new JCheckBox(Messages.getString("MainFrame.chckbxNeedSHA1.text"));
        this.chckbxNeedSHA1.addItemListener(e -> Profile.curr_profile.setProperty("need_sha1_or_md5", e.getStateChange() == 1));
        this.chckbxNeedSHA1.setToolTipText(Messages.getString("MainFrame.chckbxNeedSHA1.toolTipText"));
        GridBagConstraints gbc_chckbxNeedSHA1 = new GridBagConstraints();
        gbc_chckbxNeedSHA1.fill = 1;
        gbc_chckbxNeedSHA1.insets = new Insets(0, 0, 5, 5);
        gbc_chckbxNeedSHA1.gridx = 0;
        gbc_chckbxNeedSHA1.gridy = 0;
        scannerSettingsPanel.add((Component)this.chckbxNeedSHA1, gbc_chckbxNeedSHA1);
        this.chckbxUseParallelism = new JCheckBox(Messages.getString("MainFrame.chckbxUseParallelism.text"));
        this.chckbxUseParallelism.addItemListener(e -> Profile.curr_profile.setProperty("use_parallelism", e.getStateChange() == 1));
        this.chckbxCreateMissingSets = new JCheckBox(Messages.getString("MainFrame.chckbxCreateMissingSets.text"));
        this.chckbxCreateMissingSets.addItemListener(e -> {
            Profile.curr_profile.setProperty("create_mode", e.getStateChange() == 1);
            if (e.getStateChange() != 1) {
                this.chckbxCreateOnlyComplete.setSelected(false);
            }
            this.chckbxCreateOnlyComplete.setEnabled(e.getStateChange() == 1);
        });
        GridBagConstraints gbc_chckbxCreateMissingSets = new GridBagConstraints();
        gbc_chckbxCreateMissingSets.fill = 2;
        gbc_chckbxCreateMissingSets.insets = new Insets(0, 0, 5, 0);
        gbc_chckbxCreateMissingSets.gridx = 1;
        gbc_chckbxCreateMissingSets.gridy = 0;
        scannerSettingsPanel.add((Component)this.chckbxCreateMissingSets, gbc_chckbxCreateMissingSets);
        this.chckbxUseParallelism.setToolTipText(Messages.getString("MainFrame.chckbxUseParallelism.toolTipText"));
        GridBagConstraints gbc_chckbxUseParallelism = new GridBagConstraints();
        gbc_chckbxUseParallelism.insets = new Insets(0, 0, 5, 5);
        gbc_chckbxUseParallelism.fill = 1;
        gbc_chckbxUseParallelism.gridx = 0;
        gbc_chckbxUseParallelism.gridy = 1;
        scannerSettingsPanel.add((Component)this.chckbxUseParallelism, gbc_chckbxUseParallelism);
        this.chckbxCreateOnlyComplete = new JCheckBox(Messages.getString("MainFrame.chckbxCreateOnlyComplete.text"));
        this.chckbxCreateOnlyComplete.addItemListener(e -> Profile.curr_profile.setProperty("createfull_mode", e.getStateChange() == 1));
        GridBagConstraints gbc_chckbxCreateOnlyComplete = new GridBagConstraints();
        gbc_chckbxCreateOnlyComplete.fill = 2;
        gbc_chckbxCreateOnlyComplete.insets = new Insets(0, 0, 5, 0);
        gbc_chckbxCreateOnlyComplete.gridx = 1;
        gbc_chckbxCreateOnlyComplete.gridy = 1;
        scannerSettingsPanel.add((Component)this.chckbxCreateOnlyComplete, gbc_chckbxCreateOnlyComplete);
        this.chckbxIgnoreUnneededContainers = new JCheckBox(Messages.getString("MainFrame.chckbxIgnoreUnneededContainers.text"));
        this.chckbxIgnoreUnneededContainers.addItemListener(e -> Profile.curr_profile.setProperty("ignore_unneeded_containers", e.getStateChange() == 1));
        GridBagConstraints gbc_chckbxIgnoreUnneededContainers = new GridBagConstraints();
        gbc_chckbxIgnoreUnneededContainers.fill = 2;
        gbc_chckbxIgnoreUnneededContainers.insets = new Insets(0, 0, 5, 5);
        gbc_chckbxIgnoreUnneededContainers.gridx = 0;
        gbc_chckbxIgnoreUnneededContainers.gridy = 2;
        scannerSettingsPanel.add((Component)this.chckbxIgnoreUnneededContainers, gbc_chckbxIgnoreUnneededContainers);
        this.chckbxIgnoreUnneededEntries = new JCheckBox(Messages.getString("MainFrame.chckbxIgnoreUnneededEntries.text"));
        this.chckbxIgnoreUnneededEntries.addItemListener(e -> Profile.curr_profile.setProperty("ignore_unneeded_entries", e.getStateChange() == 1));
        GridBagConstraints gbc_chckbxIgnoreUnneededEntries = new GridBagConstraints();
        gbc_chckbxIgnoreUnneededEntries.fill = 2;
        gbc_chckbxIgnoreUnneededEntries.insets = new Insets(0, 0, 5, 0);
        gbc_chckbxIgnoreUnneededEntries.gridx = 1;
        gbc_chckbxIgnoreUnneededEntries.gridy = 2;
        scannerSettingsPanel.add((Component)this.chckbxIgnoreUnneededEntries, gbc_chckbxIgnoreUnneededEntries);
        this.chckbxIgnoreUnknownContainers = new JCheckBox(Messages.getString("MainFrame.chckbxIgnoreUnknownContainers.text"));
        this.chckbxIgnoreUnknownContainers.addItemListener(e -> Profile.curr_profile.setProperty("ignore_unknown_containers", e.getStateChange() == 1));
        GridBagConstraints gbc_chckbxIgnoreUnknownContainers = new GridBagConstraints();
        gbc_chckbxIgnoreUnknownContainers.fill = 2;
        gbc_chckbxIgnoreUnknownContainers.insets = new Insets(0, 0, 5, 5);
        gbc_chckbxIgnoreUnknownContainers.gridx = 0;
        gbc_chckbxIgnoreUnknownContainers.gridy = 3;
        scannerSettingsPanel.add((Component)this.chckbxIgnoreUnknownContainers, gbc_chckbxIgnoreUnknownContainers);
        this.chckbxUseImplicitMerge = new JCheckBox(Messages.getString("MainFrame.chckbxUseImplicitMerge.text"));
        this.chckbxUseImplicitMerge.addItemListener(e -> Profile.curr_profile.setProperty("implicit_merge", e.getStateChange() == 1));
        GridBagConstraints gbc_chckbxUseImplicitMerge = new GridBagConstraints();
        gbc_chckbxUseImplicitMerge.fill = 2;
        gbc_chckbxUseImplicitMerge.insets = new Insets(0, 0, 5, 0);
        gbc_chckbxUseImplicitMerge.gridx = 1;
        gbc_chckbxUseImplicitMerge.gridy = 3;
        scannerSettingsPanel.add((Component)this.chckbxUseImplicitMerge, gbc_chckbxUseImplicitMerge);
        this.chckbxIgnoreMergeNameRoms = new JCheckBox(Messages.getString("MainFrame.chckbxIgnoreMergeName.text"));
        this.chckbxIgnoreMergeNameRoms.addItemListener(e -> Profile.curr_profile.setProperty("ignore_merge_name_roms", e.getStateChange() == 1));
        GridBagConstraints gbc_chckbxIgnoreMergeNameRoms = new GridBagConstraints();
        gbc_chckbxIgnoreMergeNameRoms.fill = 2;
        gbc_chckbxIgnoreMergeNameRoms.insets = new Insets(0, 0, 5, 5);
        gbc_chckbxIgnoreMergeNameRoms.gridx = 0;
        gbc_chckbxIgnoreMergeNameRoms.gridy = 4;
        scannerSettingsPanel.add((Component)this.chckbxIgnoreMergeNameRoms, gbc_chckbxIgnoreMergeNameRoms);
        this.chckbxIgnoreMergeNameDisks = new JCheckBox(Messages.getString("MainFrame.chckbxIgnoreMergeName_1.text"));
        this.chckbxIgnoreMergeNameDisks.addItemListener(e -> Profile.curr_profile.setProperty("ignore_merge_name_disks", e.getStateChange() == 1));
        GridBagConstraints gbc_chckbxIgnoreMergeNameDisks = new GridBagConstraints();
        gbc_chckbxIgnoreMergeNameDisks.fill = 2;
        gbc_chckbxIgnoreMergeNameDisks.insets = new Insets(0, 0, 5, 0);
        gbc_chckbxIgnoreMergeNameDisks.gridx = 1;
        gbc_chckbxIgnoreMergeNameDisks.gridy = 4;
        scannerSettingsPanel.add((Component)this.chckbxIgnoreMergeNameDisks, gbc_chckbxIgnoreMergeNameDisks);
        this.chckbxExcludeGames = new JCheckBox(Messages.getString("MainFrame.chckbxExcludeGames.text"));
        this.chckbxExcludeGames.addItemListener(e -> Profile.curr_profile.setProperty("exclude_games", e.getStateChange() == 1));
        GridBagConstraints gbc_chckbxExcludeGames = new GridBagConstraints();
        gbc_chckbxExcludeGames.fill = 2;
        gbc_chckbxExcludeGames.insets = new Insets(0, 0, 5, 5);
        gbc_chckbxExcludeGames.gridx = 0;
        gbc_chckbxExcludeGames.gridy = 5;
        scannerSettingsPanel.add((Component)this.chckbxExcludeGames, gbc_chckbxExcludeGames);
        this.chckbxExcludeMachines = new JCheckBox(Messages.getString("MainFrame.chckbxExcludeMachines.text"));
        this.chckbxExcludeMachines.addItemListener(e -> Profile.curr_profile.setProperty("exclude_machines", e.getStateChange() == 1));
        GridBagConstraints gbc_chckbxExcludeMachines = new GridBagConstraints();
        gbc_chckbxExcludeMachines.fill = 2;
        gbc_chckbxExcludeMachines.insets = new Insets(0, 0, 5, 0);
        gbc_chckbxExcludeMachines.gridx = 1;
        gbc_chckbxExcludeMachines.gridy = 5;
        scannerSettingsPanel.add((Component)this.chckbxExcludeMachines, gbc_chckbxExcludeMachines);
        this.chckbxBackup = new JCheckBox(Messages.getString("MainFrame.chckbxBackup.text"));
        this.chckbxBackup.addItemListener(e -> Profile.curr_profile.setProperty("backup", e.getStateChange() == 1));
        GridBagConstraints gbc_chckbxBackup = new GridBagConstraints();
        gbc_chckbxBackup.fill = 2;
        gbc_chckbxBackup.insets = new Insets(0, 0, 5, 5);
        gbc_chckbxBackup.gridx = 0;
        gbc_chckbxBackup.gridy = 6;
        scannerSettingsPanel.add((Component)this.chckbxBackup, gbc_chckbxBackup);
        this.scannerSubSettingsPanel = new JPanel();
        GridBagConstraints gbc_scannerSubSettingsPanel = new GridBagConstraints();
        gbc_scannerSubSettingsPanel.gridwidth = 2;
        gbc_scannerSubSettingsPanel.fill = 1;
        gbc_scannerSubSettingsPanel.gridx = 0;
        gbc_scannerSubSettingsPanel.gridy = 7;
        scannerSettingsPanel.add((Component)this.scannerSubSettingsPanel, gbc_scannerSubSettingsPanel);
        GridBagLayout gbl_scannerSubSettingsPanel = new GridBagLayout();
        gbl_scannerSubSettingsPanel.columnWidths = new int[]{0, 0, 0, 0};
        gbl_scannerSubSettingsPanel.rowHeights = new int[]{0, 0, 0, 8, 100, 0};
        gbl_scannerSubSettingsPanel.columnWeights = new double[]{0.0, 1.0, 0.0, Double.MIN_VALUE};
        gbl_scannerSubSettingsPanel.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 1.0, Double.MIN_VALUE};
        this.scannerSubSettingsPanel.setLayout(gbl_scannerSubSettingsPanel);
        JLabel lblCompression = new JLabel(Messages.getString("MainFrame.lblCompression.text"));
        GridBagConstraints gbc_lblCompression = new GridBagConstraints();
        gbc_lblCompression.anchor = 13;
        gbc_lblCompression.insets = new Insets(0, 5, 5, 5);
        gbc_lblCompression.gridx = 0;
        gbc_lblCompression.gridy = 0;
        this.scannerSubSettingsPanel.add((Component)lblCompression, gbc_lblCompression);
        this.cbCompression = new JComboBox();
        this.cbCompression.setModel(new DefaultComboBoxModel<FormatOptions>(FormatOptions.values()));
        this.cbCompression.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                this.setText(((FormatOptions)((Object)value)).getDesc());
                return this;
            }
        });
        this.cbCompression.addActionListener(e -> Profile.curr_profile.settings.setProperty("format", this.cbCompression.getSelectedItem().toString()));
        GridBagConstraints gbc_cbCompression = new GridBagConstraints();
        gbc_cbCompression.gridwidth = 2;
        gbc_cbCompression.insets = new Insets(0, 0, 5, 5);
        gbc_cbCompression.fill = 2;
        gbc_cbCompression.gridx = 1;
        gbc_cbCompression.gridy = 0;
        this.scannerSubSettingsPanel.add(this.cbCompression, gbc_cbCompression);
        JLabel lblMergeMode = new JLabel(Messages.getString("MainFrame.lblMergeMode.text"));
        GridBagConstraints gbc_lblMergeMode = new GridBagConstraints();
        gbc_lblMergeMode.insets = new Insets(0, 0, 5, 5);
        gbc_lblMergeMode.anchor = 13;
        gbc_lblMergeMode.gridx = 0;
        gbc_lblMergeMode.gridy = 1;
        this.scannerSubSettingsPanel.add((Component)lblMergeMode, gbc_lblMergeMode);
        this.cbbxMergeMode = new JComboBox();
        GridBagConstraints gbc_cbbxMergeMode = new GridBagConstraints();
        gbc_cbbxMergeMode.insets = new Insets(0, 0, 5, 5);
        gbc_cbbxMergeMode.gridwidth = 2;
        gbc_cbbxMergeMode.fill = 2;
        gbc_cbbxMergeMode.gridx = 1;
        gbc_cbbxMergeMode.gridy = 1;
        this.scannerSubSettingsPanel.add(this.cbbxMergeMode, gbc_cbbxMergeMode);
        this.cbbxMergeMode.setToolTipText(Messages.getString("MainFrame.cbbxMergeMode.toolTipText"));
        this.cbbxMergeMode.setModel(new DefaultComboBoxModel<MergeOptions>(MergeOptions.values()));
        this.cbbxMergeMode.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                this.setText(((MergeOptions)((Object)value)).getDesc());
                return this;
            }
        });
        this.cbbxMergeMode.addActionListener(e -> {
            Profile.curr_profile.settings.setProperty("merge_mode", this.cbbxMergeMode.getSelectedItem().toString());
            this.cbHashCollision.setEnabled(((MergeOptions)((Object)((Object)this.cbbxMergeMode.getSelectedItem()))).isMerge());
        });
        JLabel lblHashCollision = new JLabel(Messages.getString("MainFrame.lblHashCollision.text"));
        GridBagConstraints gbc_lblHashCollision = new GridBagConstraints();
        gbc_lblHashCollision.insets = new Insets(0, 0, 5, 5);
        gbc_lblHashCollision.anchor = 13;
        gbc_lblHashCollision.gridx = 0;
        gbc_lblHashCollision.gridy = 2;
        this.scannerSubSettingsPanel.add((Component)lblHashCollision, gbc_lblHashCollision);
        this.cbHashCollision = new JComboBox();
        this.cbHashCollision.setModel(new DefaultComboBoxModel<HashCollisionOptions>(HashCollisionOptions.values()));
        this.cbHashCollision.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                this.setText(((HashCollisionOptions)((Object)value)).getDesc());
                return this;
            }
        });
        this.cbHashCollision.addActionListener(e -> Profile.curr_profile.settings.setProperty("hash_collision_mode", this.cbHashCollision.getSelectedItem().toString()));
        GridBagConstraints gbc_cbHashCollision = new GridBagConstraints();
        gbc_cbHashCollision.gridwidth = 2;
        gbc_cbHashCollision.insets = new Insets(0, 0, 5, 5);
        gbc_cbHashCollision.fill = 2;
        gbc_cbHashCollision.gridx = 1;
        gbc_cbHashCollision.gridy = 2;
        this.scannerSubSettingsPanel.add(this.cbHashCollision, gbc_cbHashCollision);
    }

    private void buildScannerFiltersTab() {
        JSplitPane scannerFilters = new JSplitPane();
        scannerFilters.setResizeWeight(0.5);
        scannerFilters.setOneTouchExpandable(true);
        scannerFilters.setContinuousLayout(true);
        this.scannerTabbedPane.addTab(Messages.getString("MainFrame.Filters"), null, scannerFilters, null);
        JScrollPane scrollPane_2 = new JScrollPane();
        scannerFilters.setRightComponent(scrollPane_2);
        scrollPane_2.setViewportBorder(new TitledBorder(null, Messages.getString("MainFrame.scrollPane_2.viewportBorderTitle"), 4, 2, null, null));
        this.checkBoxListSystems = new JCheckBoxList();
        this.checkBoxListSystems.setCellRenderer(new JCheckBoxList.CellRenderer(this.checkBoxListSystems){

            @Override
            public Component getListCellRendererComponent(JList<? extends Systm> list, Systm value, int index, boolean isSelected, boolean cellHasFocus) {
                JCheckBox checkbox = (JCheckBox)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                checkbox.setSelected(value.isSelected());
                return checkbox;
            }
        });
        this.checkBoxListSystems.addListSelectionListener(e -> {
            if (!e.getValueIsAdjusting() && e.getFirstIndex() != -1) {
                for (int index = e.getFirstIndex(); index <= e.getLastIndex(); ++index) {
                    ((Systm)this.checkBoxListSystems.getModel().getElementAt(index)).setSelected(this.checkBoxListSystems.isSelectedIndex(index));
                }
                if (profile_viewer != null) {
                    profile_viewer.reset(Profile.curr_profile);
                }
            }
        });
        scrollPane_2.setViewportView(this.checkBoxListSystems);
        JPopupMenu popupMenu = new JPopupMenu();
        MainFrame.addPopup(this.checkBoxListSystems, popupMenu);
        JMenu mnSelect = new JMenu(Messages.getString("MainFrame.mnSelect.text"));
        popupMenu.add(mnSelect);
        JMenuItem mntmSelectAll = new JMenuItem(Messages.getString("MainFrame.mntmSelectAll.text"));
        mnSelect.add(mntmSelectAll);
        JMenuItem mntmSelectAllBios = new JMenuItem(Messages.getString("MainFrame.mntmAllBios.text"));
        mntmSelectAllBios.addActionListener(e -> this.checkBoxListSystems.select(sys -> sys.getType() == Systm.Type.BIOS, true));
        mnSelect.add(mntmSelectAllBios);
        JMenuItem mntmSelectAllSoftwares = new JMenuItem(Messages.getString("MainFrame.mntmAllSoftwares.text"));
        mntmSelectAllSoftwares.addActionListener(e -> this.checkBoxListSystems.select(sys -> sys.getType() == Systm.Type.SOFTWARELIST, true));
        mnSelect.add(mntmSelectAllSoftwares);
        JMenu mnUnselect = new JMenu(Messages.getString("MainFrame.mnUnselect.text"));
        popupMenu.add(mnUnselect);
        JMenuItem mntmUnselectAll = new JMenuItem(Messages.getString("MainFrame.mntmSelectNone.text"));
        mnUnselect.add(mntmUnselectAll);
        JMenuItem mntmUnselectAllBios = new JMenuItem(Messages.getString("MainFrame.mntmAllBios.text"));
        mntmUnselectAllBios.addActionListener(e -> this.checkBoxListSystems.select(sys -> sys.getType() == Systm.Type.BIOS, false));
        mnUnselect.add(mntmUnselectAllBios);
        JMenuItem mntmUnselectAllSoftwares = new JMenuItem(Messages.getString("MainFrame.mntmAllSoftwares.text"));
        mntmUnselectAllSoftwares.addActionListener(e -> this.checkBoxListSystems.select(sys -> sys.getType() == Systm.Type.SOFTWARELIST, false));
        mnUnselect.add(mntmUnselectAllSoftwares);
        JMenuItem mntmInvertSelection = new JMenuItem(Messages.getString("MainFrame.mntmInvertSelection.text"));
        mntmInvertSelection.addActionListener(e -> this.checkBoxListSystems.selectInvert());
        popupMenu.add(mntmInvertSelection);
        mntmUnselectAll.addActionListener(e -> this.checkBoxListSystems.selectNone());
        mntmSelectAll.addActionListener(e -> this.checkBoxListSystems.selectAll());
        JPanel panel = new JPanel();
        scannerFilters.setLeftComponent(panel);
        GridBagLayout gbl_panel = new GridBagLayout();
        gbl_panel.columnWidths = new int[]{20, 100, 0, 100, 20, 0};
        gbl_panel.rowHeights = new int[]{0, 24, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        gbl_panel.columnWeights = new double[]{1.0, 1.0, 0.0, 1.0, 1.0, Double.MIN_VALUE};
        gbl_panel.rowWeights = new double[]{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, Double.MIN_VALUE};
        panel.setLayout(gbl_panel);
        this.chckbxIncludeClones = new JCheckBox(Messages.getString("MainFrame.chckbxIncludeClones.text"));
        GridBagConstraints gbc_chckbxIncludeClones = new GridBagConstraints();
        gbc_chckbxIncludeClones.gridwidth = 3;
        gbc_chckbxIncludeClones.fill = 2;
        gbc_chckbxIncludeClones.insets = new Insets(0, 0, 5, 5);
        gbc_chckbxIncludeClones.anchor = 11;
        gbc_chckbxIncludeClones.gridx = 1;
        gbc_chckbxIncludeClones.gridy = 1;
        panel.add((Component)this.chckbxIncludeClones, gbc_chckbxIncludeClones);
        this.chckbxIncludeDisks = new JCheckBox(Messages.getString("MainFrame.chckbxIncludeDisks.text"));
        GridBagConstraints gbc_chckbxIncludeDisks = new GridBagConstraints();
        gbc_chckbxIncludeDisks.gridwidth = 3;
        gbc_chckbxIncludeDisks.fill = 2;
        gbc_chckbxIncludeDisks.insets = new Insets(0, 0, 5, 5);
        gbc_chckbxIncludeDisks.gridx = 1;
        gbc_chckbxIncludeDisks.gridy = 2;
        panel.add((Component)this.chckbxIncludeDisks, gbc_chckbxIncludeDisks);
        this.chckbxIncludeSamples = new JCheckBox(Messages.getString("MainFrame.chckbxIncludeSamples.text"));
        GridBagConstraints gbc_chckbxIncludeSamples = new GridBagConstraints();
        gbc_chckbxIncludeSamples.gridwidth = 3;
        gbc_chckbxIncludeSamples.fill = 2;
        gbc_chckbxIncludeSamples.insets = new Insets(0, 0, 5, 5);
        gbc_chckbxIncludeSamples.gridx = 1;
        gbc_chckbxIncludeSamples.gridy = 3;
        panel.add((Component)this.chckbxIncludeSamples, gbc_chckbxIncludeSamples);
        this.chckbxIncludeSamples.setSelected(true);
        JLabel lblCabinetType = new JLabel(Messages.getString("MainFrame.lblMachineType.text"));
        GridBagConstraints gbc_lblCabinetType = new GridBagConstraints();
        gbc_lblCabinetType.gridwidth = 2;
        gbc_lblCabinetType.fill = 2;
        gbc_lblCabinetType.insets = new Insets(0, 0, 5, 5);
        gbc_lblCabinetType.gridx = 1;
        gbc_lblCabinetType.gridy = 4;
        panel.add((Component)lblCabinetType, gbc_lblCabinetType);
        lblCabinetType.setHorizontalAlignment(11);
        this.cbbxFilterCabinetType = new JComboBox();
        GridBagConstraints gbc_cbbxFilterCabinetType = new GridBagConstraints();
        gbc_cbbxFilterCabinetType.fill = 2;
        gbc_cbbxFilterCabinetType.insets = new Insets(0, 0, 5, 5);
        gbc_cbbxFilterCabinetType.gridx = 3;
        gbc_cbbxFilterCabinetType.gridy = 4;
        panel.add(this.cbbxFilterCabinetType, gbc_cbbxFilterCabinetType);
        this.cbbxFilterCabinetType.addItemListener(e -> {
            if (e.getStateChange() == 1) {
                Profile.curr_profile.setProperty("filter.CabinetType", e.getItem().toString());
                if (profile_viewer != null) {
                    profile_viewer.reset(Profile.curr_profile);
                }
            }
        });
        this.cbbxFilterCabinetType.setModel(new DefaultComboBoxModel<Machine.CabinetType>(Machine.CabinetType.values()));
        JLabel lblDisplayOrientation = new JLabel(Messages.getString("MainFrame.lblOrientation.text"));
        GridBagConstraints gbc_lblDisplayOrientation = new GridBagConstraints();
        gbc_lblDisplayOrientation.gridwidth = 2;
        gbc_lblDisplayOrientation.fill = 2;
        gbc_lblDisplayOrientation.insets = new Insets(0, 0, 5, 5);
        gbc_lblDisplayOrientation.gridx = 1;
        gbc_lblDisplayOrientation.gridy = 5;
        panel.add((Component)lblDisplayOrientation, gbc_lblDisplayOrientation);
        lblDisplayOrientation.setHorizontalAlignment(11);
        this.cbbxFilterDisplayOrientation = new JComboBox();
        GridBagConstraints gbc_cbbxFilterDisplayOrientation = new GridBagConstraints();
        gbc_cbbxFilterDisplayOrientation.fill = 2;
        gbc_cbbxFilterDisplayOrientation.insets = new Insets(0, 0, 5, 5);
        gbc_cbbxFilterDisplayOrientation.gridx = 3;
        gbc_cbbxFilterDisplayOrientation.gridy = 5;
        panel.add(this.cbbxFilterDisplayOrientation, gbc_cbbxFilterDisplayOrientation);
        this.cbbxFilterDisplayOrientation.addItemListener(e -> {
            if (e.getStateChange() == 1) {
                Profile.curr_profile.setProperty("filter.DisplayOrientation", e.getItem().toString());
                if (profile_viewer != null) {
                    profile_viewer.reset(Profile.curr_profile);
                }
            }
        });
        this.cbbxFilterDisplayOrientation.setModel(new DefaultComboBoxModel<Machine.DisplayOrientation>(Machine.DisplayOrientation.values()));
        JLabel lblDriverStatus = new JLabel(Messages.getString("MainFrame.lblDriverStatus.text"));
        GridBagConstraints gbc_lblDriverStatus = new GridBagConstraints();
        gbc_lblDriverStatus.gridwidth = 2;
        gbc_lblDriverStatus.fill = 2;
        gbc_lblDriverStatus.insets = new Insets(0, 0, 5, 5);
        gbc_lblDriverStatus.gridx = 1;
        gbc_lblDriverStatus.gridy = 6;
        panel.add((Component)lblDriverStatus, gbc_lblDriverStatus);
        lblDriverStatus.setHorizontalAlignment(11);
        this.cbbxDriverStatus = new JComboBox();
        GridBagConstraints gbc_cbbxDriverStatus = new GridBagConstraints();
        gbc_cbbxDriverStatus.fill = 2;
        gbc_cbbxDriverStatus.insets = new Insets(0, 0, 5, 5);
        gbc_cbbxDriverStatus.gridx = 3;
        gbc_cbbxDriverStatus.gridy = 6;
        panel.add(this.cbbxDriverStatus, gbc_cbbxDriverStatus);
        this.cbbxDriverStatus.setModel(new DefaultComboBoxModel<Driver.StatusType>(Driver.StatusType.values()));
        JLabel lblSwMinSupportedLvl = new JLabel(Messages.getString("MainFrame.lblSwMinSupport.text"));
        GridBagConstraints gbc_lblSwMinSupportedLvl = new GridBagConstraints();
        gbc_lblSwMinSupportedLvl.gridwidth = 2;
        gbc_lblSwMinSupportedLvl.fill = 2;
        gbc_lblSwMinSupportedLvl.insets = new Insets(0, 0, 5, 5);
        gbc_lblSwMinSupportedLvl.gridx = 1;
        gbc_lblSwMinSupportedLvl.gridy = 7;
        panel.add((Component)lblSwMinSupportedLvl, gbc_lblSwMinSupportedLvl);
        lblSwMinSupportedLvl.setHorizontalAlignment(11);
        this.cbbxSWMinSupportedLvl = new JComboBox();
        GridBagConstraints gbc_cbbxSWMinSupportedLvl = new GridBagConstraints();
        gbc_cbbxSWMinSupportedLvl.fill = 2;
        gbc_cbbxSWMinSupportedLvl.insets = new Insets(0, 0, 5, 5);
        gbc_cbbxSWMinSupportedLvl.gridx = 3;
        gbc_cbbxSWMinSupportedLvl.gridy = 7;
        panel.add(this.cbbxSWMinSupportedLvl, gbc_cbbxSWMinSupportedLvl);
        this.cbbxSWMinSupportedLvl.addItemListener(e -> {
            if (e.getStateChange() == 1) {
                Profile.curr_profile.setProperty("filter.MinSoftwareSupportedLevel", e.getItem().toString());
                if (profile_viewer != null) {
                    profile_viewer.reset(Profile.curr_profile);
                }
            }
        });
        this.cbbxSWMinSupportedLvl.setModel(new DefaultComboBoxModel<Software.Supported>(Software.Supported.values()));
        this.cbbxSWMinSupportedLvl.setSelectedIndex(0);
        this.cbbxYearMin = new JComboBox();
        this.cbbxYearMin.addItemListener(e -> {
            if (e.getStateChange() == 1) {
                Profile.curr_profile.setProperty("filter.YearMin", e.getItem().toString());
                if (profile_viewer != null) {
                    profile_viewer.reset(Profile.curr_profile);
                }
            }
        });
        GridBagConstraints gbc_cbbxYearMin = new GridBagConstraints();
        gbc_cbbxYearMin.fill = 2;
        gbc_cbbxYearMin.insets = new Insets(0, 0, 5, 5);
        gbc_cbbxYearMin.gridx = 1;
        gbc_cbbxYearMin.gridy = 8;
        panel.add(this.cbbxYearMin, gbc_cbbxYearMin);
        JLabel lblYear = new JLabel(Messages.getString("MainFrame.lblYear.text"));
        GridBagConstraints gbc_lblYear = new GridBagConstraints();
        gbc_lblYear.insets = new Insets(0, 0, 5, 5);
        gbc_lblYear.gridx = 2;
        gbc_lblYear.gridy = 8;
        panel.add((Component)lblYear, gbc_lblYear);
        lblYear.setHorizontalAlignment(0);
        this.cbbxYearMax = new JComboBox();
        this.cbbxYearMax.addItemListener(e -> {
            if (e.getStateChange() == 1) {
                Profile.curr_profile.setProperty("filter.YearMax", e.getItem().toString());
                if (profile_viewer != null) {
                    profile_viewer.reset(Profile.curr_profile);
                }
            }
        });
        GridBagConstraints gbc_cbbxYearMax = new GridBagConstraints();
        gbc_cbbxYearMax.fill = 2;
        gbc_cbbxYearMax.insets = new Insets(0, 0, 5, 5);
        gbc_cbbxYearMax.gridx = 3;
        gbc_cbbxYearMax.gridy = 8;
        panel.add(this.cbbxYearMax, gbc_cbbxYearMax);
        this.cbbxDriverStatus.addItemListener(e -> {
            if (e.getStateChange() == 1) {
                Profile.curr_profile.setProperty("filter.DriverStatus", e.getItem().toString());
                if (profile_viewer != null) {
                    profile_viewer.reset(Profile.curr_profile);
                }
            }
        });
        this.chckbxIncludeDisks.addItemListener(e -> {
            Profile.curr_profile.setProperty("filter.InclDisks", e.getStateChange() == 1);
            if (profile_viewer != null) {
                profile_viewer.reset(Profile.curr_profile);
            }
        });
        this.chckbxIncludeClones.addItemListener(e -> {
            Profile.curr_profile.setProperty("filter.InclClones", e.getStateChange() == 1);
            if (profile_viewer != null) {
                profile_viewer.reset(Profile.curr_profile);
            }
        });
        this.chckbxIncludeSamples.addItemListener(e -> {
            Profile.curr_profile.setProperty("filter.InclSamples", e.getStateChange() == 1);
            if (profile_viewer != null) {
                profile_viewer.reset(Profile.curr_profile);
            }
        });
    }

    private void buildScannerAdvFiltersTab() {
        JPanel scannerAdvFilters = new JPanel();
        this.scannerTabbedPane.addTab(Messages.getString("MainFrame.AdvFilters"), null, scannerAdvFilters, null);
        GridBagLayout gbl_scannerAdvFilters = new GridBagLayout();
        gbl_scannerAdvFilters.columnWidths = new int[]{0, 0, 0};
        gbl_scannerAdvFilters.rowHeights = new int[]{0, 0, 0};
        gbl_scannerAdvFilters.columnWeights = new double[]{1.0, 1.0, Double.MIN_VALUE};
        gbl_scannerAdvFilters.rowWeights = new double[]{0.0, 1.0, Double.MIN_VALUE};
        scannerAdvFilters.setLayout(gbl_scannerAdvFilters);
        this.tfNPlayers = new JFileDropTextField(txt -> {
            Profile.curr_profile.setProperty("filter.nplayers.ini", txt);
            Profile.curr_profile.loadNPlayers(null);
            Profile.curr_profile.saveSettings();
            this.listNPlayers.setModel(Profile.curr_profile.nplayers != null ? Profile.curr_profile.nplayers : new DefaultListModel());
        });
        this.tfNPlayers.setMode(JFileDropMode.FILE);
        this.tfNPlayers.setUI(new JTextFieldHintUI(Messages.getString("MainFrame.DropNPlayersIniHere"), Color.gray));
        this.tfNPlayers.setEditable(false);
        GridBagConstraints gbc_tfNPlayers = new GridBagConstraints();
        gbc_tfNPlayers.insets = new Insets(0, 0, 5, 5);
        gbc_tfNPlayers.fill = 2;
        gbc_tfNPlayers.gridx = 0;
        gbc_tfNPlayers.gridy = 0;
        scannerAdvFilters.add((Component)this.tfNPlayers, gbc_tfNPlayers);
        this.tfCatVer = new JFileDropTextField(txt -> {
            Profile.curr_profile.setProperty("filter.catver.ini", txt);
            Profile.curr_profile.loadCatVer(null);
            Profile.curr_profile.saveSettings();
            this.treeCatVer.setModel(Profile.curr_profile.catver != null ? new CatVerModel(Profile.curr_profile.catver) : new CatVerModel());
        });
        this.tfCatVer.setMode(JFileDropMode.FILE);
        this.tfCatVer.setUI(new JTextFieldHintUI(Messages.getString("MainFrame.DropCatVerIniHere"), Color.gray));
        this.tfCatVer.setEditable(false);
        GridBagConstraints gbc_tfCatVer = new GridBagConstraints();
        gbc_tfCatVer.insets = new Insets(0, 0, 5, 0);
        gbc_tfCatVer.fill = 2;
        gbc_tfCatVer.gridx = 1;
        gbc_tfCatVer.gridy = 0;
        scannerAdvFilters.add((Component)this.tfCatVer, gbc_tfCatVer);
        JScrollPane scrollPaneNPlayers = new JScrollPane();
        scrollPaneNPlayers.setViewportBorder(new TitledBorder(null, Messages.getString("MainFrame.NPlayers"), 4, 2, null, null));
        GridBagConstraints gbc_scrollPaneNPlayers = new GridBagConstraints();
        gbc_scrollPaneNPlayers.insets = new Insets(0, 0, 0, 5);
        gbc_scrollPaneNPlayers.fill = 1;
        gbc_scrollPaneNPlayers.gridx = 0;
        gbc_scrollPaneNPlayers.gridy = 1;
        scannerAdvFilters.add((Component)scrollPaneNPlayers, gbc_scrollPaneNPlayers);
        this.listNPlayers = new JCheckBoxList();
        this.listNPlayers.setCellRenderer(new JCheckBoxList.CellRenderer(this.listNPlayers){

            @Override
            public Component getListCellRendererComponent(JList<? extends NPlayers.NPlayer> list, NPlayers.NPlayer value, int index, boolean isSelected, boolean cellHasFocus) {
                JCheckBox checkbox = (JCheckBox)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                checkbox.setSelected(value.isSelected());
                return checkbox;
            }
        });
        this.listNPlayers.addListSelectionListener(e -> {
            if (!e.getValueIsAdjusting() && e.getFirstIndex() != -1) {
                for (int index = e.getFirstIndex(); index <= e.getLastIndex() && index < this.listNPlayers.getModel().getSize(); ++index) {
                    ((NPlayers.NPlayer)this.listNPlayers.getModel().getElementAt(index)).setSelected(this.listNPlayers.isSelectedIndex(index));
                }
                if (profile_viewer != null) {
                    profile_viewer.reset(Profile.curr_profile);
                }
            }
        });
        this.listNPlayers.setEnabled(false);
        scrollPaneNPlayers.setViewportView(this.listNPlayers);
        JPopupMenu popupMenuNPlay = new JPopupMenu();
        MainFrame.addPopup(this.listNPlayers, popupMenuNPlay);
        JMenuItem mntmSelectAllNPlay = new JMenuItem(Messages.getString("MainFrame.SelectAll"));
        mntmSelectAllNPlay.addActionListener(e -> this.listNPlayers.selectAll());
        popupMenuNPlay.add(mntmSelectAllNPlay);
        JMenuItem mntmSelectNoneNPlay = new JMenuItem(Messages.getString("MainFrame.SelectNone"));
        mntmSelectNoneNPlay.addActionListener(e -> this.listNPlayers.selectNone());
        popupMenuNPlay.add(mntmSelectNoneNPlay);
        JMenuItem mntmInvertSelectionNPlay = new JMenuItem(Messages.getString("MainFrame.InvertSelection"));
        mntmInvertSelectionNPlay.addActionListener(e -> this.listNPlayers.selectInvert());
        popupMenuNPlay.add(mntmInvertSelectionNPlay);
        JScrollPane scrollPaneCatVer = new JScrollPane();
        scrollPaneCatVer.setViewportBorder(new TitledBorder(null, Messages.getString("MainFrame.Categories"), 4, 2, null, null));
        GridBagConstraints gbc_scrollPaneCatVer = new GridBagConstraints();
        gbc_scrollPaneCatVer.fill = 1;
        gbc_scrollPaneCatVer.gridx = 1;
        gbc_scrollPaneCatVer.gridy = 1;
        scannerAdvFilters.add((Component)scrollPaneCatVer, gbc_scrollPaneCatVer);
        this.treeCatVer = new JCheckBoxTree(new CatVerModel());
        this.treeCatVer.addCheckChangeEventListener(event -> {
            Profile.curr_profile.saveSettings();
            if (profile_viewer != null) {
                profile_viewer.reset(Profile.curr_profile);
            }
        });
        this.treeCatVer.setEnabled(false);
        scrollPaneCatVer.setViewportView(this.treeCatVer);
        JPopupMenu popupMenuCat = new JPopupMenu();
        popupMenuCat.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            }
        });
        MainFrame.addPopup(this.treeCatVer, popupMenuCat);
        JMenu mnSelectCat = new JMenu(Messages.getString("MainFrame.Select"));
        popupMenuCat.add(mnSelectCat);
        JMenuItem mntmSelectAllCat = new JMenuItem(Messages.getString("MainFrame.All"));
        mntmSelectAllCat.addActionListener(e -> this.treeCatVer.selectAll());
        mnSelectCat.add(mntmSelectAllCat);
        JMenuItem mntmSelectMatureCat = new JMenuItem(Messages.getString("MainFrame.Mature"));
        mntmSelectMatureCat.addActionListener(e -> {
            ArrayList<AbstractNGTreeNode> mature_nodes = new ArrayList<AbstractNGTreeNode>();
            for (CatVer.Category cat : Profile.curr_profile.catver) {
                if (cat.name.endsWith("* Mature *")) {
                    mature_nodes.add(cat);
                    continue;
                }
                for (CatVer.SubCategory subcat : cat) {
                    if (!subcat.name.endsWith("* Mature *")) continue;
                    mature_nodes.add(subcat);
                }
            }
            this.treeCatVer.select(mature_nodes.toArray(new NGTreeNode[0]));
        });
        mnSelectCat.add(mntmSelectMatureCat);
        JMenu mnUnselectCat = new JMenu(Messages.getString("MainFrame.Unselect"));
        popupMenuCat.add(mnUnselectCat);
        JMenuItem mntmUnselectAllCat = new JMenuItem(Messages.getString("MainFrame.All"));
        mntmUnselectAllCat.addActionListener(e -> this.treeCatVer.selectNone());
        mnUnselectCat.add(mntmUnselectAllCat);
        JMenuItem mntmUnselectMatureCat = new JMenuItem(Messages.getString("MainFrame.Mature"));
        mntmUnselectMatureCat.addActionListener(e -> {
            ArrayList<AbstractNGTreeNode> mature_nodes = new ArrayList<AbstractNGTreeNode>();
            for (CatVer.Category cat : Profile.curr_profile.catver) {
                if (cat.name.endsWith("* Mature *")) {
                    mature_nodes.add(cat);
                    continue;
                }
                for (CatVer.SubCategory subcat : cat) {
                    if (!subcat.name.endsWith("* Mature *")) continue;
                    mature_nodes.add(subcat);
                }
            }
            this.treeCatVer.unselect(mature_nodes.toArray(new NGTreeNode[0]));
        });
        mnUnselectCat.add(mntmUnselectMatureCat);
    }

    private void buildDir2DatTab() {
        JPanel dir2datTab = new JPanel();
        this.mainPane.addTab(Messages.getString("MainFrame.Dir2Dat"), new ImageIcon(MainFrame.class.getResource("/jrm/resources/icons/drive_go.png")), dir2datTab, null);
        GridBagLayout gbl_dir2datTab = new GridBagLayout();
        gbl_dir2datTab.columnWidths = new int[]{0, 0, 0};
        gbl_dir2datTab.rowHeights = new int[]{0, 0, 0};
        gbl_dir2datTab.columnWeights = new double[]{1.0, 1.0, Double.MIN_VALUE};
        gbl_dir2datTab.rowWeights = new double[]{1.0, 0.0, Double.MIN_VALUE};
        dir2datTab.setLayout(gbl_dir2datTab);
        JPanel panelDir2DatOptions = new JPanel();
        panelDir2DatOptions.setBorder(new TitledBorder(null, Messages.getString("MainFrame.Options"), 4, 2, null, null));
        GridBagConstraints gbc_panelDir2DatOptions = new GridBagConstraints();
        gbc_panelDir2DatOptions.insets = new Insets(0, 5, 5, 5);
        gbc_panelDir2DatOptions.fill = 1;
        gbc_panelDir2DatOptions.gridx = 0;
        gbc_panelDir2DatOptions.gridy = 0;
        dir2datTab.add((Component)panelDir2DatOptions, gbc_panelDir2DatOptions);
        GridBagLayout gbl_panelDir2DatOptions = new GridBagLayout();
        gbl_panelDir2DatOptions.columnWidths = new int[]{0, 0, 0, 0};
        gbl_panelDir2DatOptions.rowHeights = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        gbl_panelDir2DatOptions.columnWeights = new double[]{1.0, 0.0, 1.0, Double.MIN_VALUE};
        gbl_panelDir2DatOptions.rowWeights = new double[]{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, Double.MIN_VALUE};
        panelDir2DatOptions.setLayout(gbl_panelDir2DatOptions);
        JCheckBox cbDir2DatScanSubfolders = new JCheckBox(Messages.getString("MainFrame.chckbxScanSubfolders.text"));
        cbDir2DatScanSubfolders.setSelected(Settings.getProperty("dir2dat.scan_subfolders", true));
        cbDir2DatScanSubfolders.addItemListener(e -> Settings.setProperty("dir2dat.scan_subfolders", e.getStateChange() == 1));
        GridBagConstraints gbc_cbDir2DatScanSubfolders = new GridBagConstraints();
        gbc_cbDir2DatScanSubfolders.anchor = 17;
        gbc_cbDir2DatScanSubfolders.insets = new Insets(0, 0, 5, 5);
        gbc_cbDir2DatScanSubfolders.gridx = 1;
        gbc_cbDir2DatScanSubfolders.gridy = 1;
        panelDir2DatOptions.add((Component)cbDir2DatScanSubfolders, gbc_cbDir2DatScanSubfolders);
        JCheckBox cbDir2DatDeepScan = new JCheckBox(Messages.getString("MainFrame.chckbxDeepScanFor.text"));
        cbDir2DatDeepScan.setSelected(Settings.getProperty("dir2dat.deep_scan", false));
        cbDir2DatDeepScan.addItemListener(e -> Settings.setProperty("dir2dat.deep_scan", e.getStateChange() == 1));
        GridBagConstraints gbc_cbDir2DatDeepScan = new GridBagConstraints();
        gbc_cbDir2DatDeepScan.anchor = 17;
        gbc_cbDir2DatDeepScan.insets = new Insets(0, 0, 5, 5);
        gbc_cbDir2DatDeepScan.gridx = 1;
        gbc_cbDir2DatDeepScan.gridy = 2;
        panelDir2DatOptions.add((Component)cbDir2DatDeepScan, gbc_cbDir2DatDeepScan);
        JCheckBox cbDir2DatAddMd5 = new JCheckBox(Messages.getString("MainFrame.chckbxAddMd.text"));
        cbDir2DatAddMd5.setSelected(Settings.getProperty("dir2dat.add_md5", false));
        cbDir2DatAddMd5.addItemListener(e -> Settings.setProperty("dir2dat.add_md5", e.getStateChange() == 1));
        GridBagConstraints gbc_cbDir2DatAddMd5 = new GridBagConstraints();
        gbc_cbDir2DatAddMd5.anchor = 17;
        gbc_cbDir2DatAddMd5.insets = new Insets(0, 0, 5, 5);
        gbc_cbDir2DatAddMd5.gridx = 1;
        gbc_cbDir2DatAddMd5.gridy = 3;
        panelDir2DatOptions.add((Component)cbDir2DatAddMd5, gbc_cbDir2DatAddMd5);
        JCheckBox cbDir2DatAddSha1 = new JCheckBox(Messages.getString("MainFrame.chckbxAddShamd.text"));
        cbDir2DatAddSha1.setSelected(Settings.getProperty("dir2dat.add_sha1", false));
        cbDir2DatAddSha1.addItemListener(e -> Settings.setProperty("dir2dat.add_sha1", e.getStateChange() == 1));
        GridBagConstraints gbc_cbDir2DatAddSha1 = new GridBagConstraints();
        gbc_cbDir2DatAddSha1.anchor = 17;
        gbc_cbDir2DatAddSha1.insets = new Insets(0, 0, 5, 5);
        gbc_cbDir2DatAddSha1.gridx = 1;
        gbc_cbDir2DatAddSha1.gridy = 4;
        panelDir2DatOptions.add((Component)cbDir2DatAddSha1, gbc_cbDir2DatAddSha1);
        JCheckBox cbDir2DatJunkSubfolders = new JCheckBox(Messages.getString("MainFrame.chckbxJunkSubfolders.text"));
        cbDir2DatJunkSubfolders.setSelected(Settings.getProperty("dir2dat.junk_folders", false));
        cbDir2DatJunkSubfolders.addItemListener(e -> Settings.setProperty("dir2dat.junk_folders", e.getStateChange() == 1));
        GridBagConstraints gbc_cbDir2DatJunkSubfolders = new GridBagConstraints();
        gbc_cbDir2DatJunkSubfolders.anchor = 17;
        gbc_cbDir2DatJunkSubfolders.insets = new Insets(0, 0, 5, 5);
        gbc_cbDir2DatJunkSubfolders.gridx = 1;
        gbc_cbDir2DatJunkSubfolders.gridy = 5;
        panelDir2DatOptions.add((Component)cbDir2DatJunkSubfolders, gbc_cbDir2DatJunkSubfolders);
        JCheckBox cbDir2DatDoNotScan = new JCheckBox(Messages.getString("MainFrame.chckbxDoNotScan.text"));
        cbDir2DatDoNotScan.setSelected(Settings.getProperty("dir2dat.do_not_scan_archives", false));
        cbDir2DatDoNotScan.addItemListener(e -> Settings.setProperty("dir2dat.do_not_scan_archives", e.getStateChange() == 1));
        GridBagConstraints gbc_cbDir2DatDoNotScan = new GridBagConstraints();
        gbc_cbDir2DatDoNotScan.anchor = 17;
        gbc_cbDir2DatDoNotScan.insets = new Insets(0, 0, 5, 5);
        gbc_cbDir2DatDoNotScan.gridx = 1;
        gbc_cbDir2DatDoNotScan.gridy = 6;
        panelDir2DatOptions.add((Component)cbDir2DatDoNotScan, gbc_cbDir2DatDoNotScan);
        JCheckBox cbDir2DatMatchCurrentProfile = new JCheckBox(Messages.getString("MainFrame.chckbxMatchCurrentProfile.text"));
        cbDir2DatMatchCurrentProfile.setSelected(Settings.getProperty("dir2dat.match_profile", false));
        cbDir2DatMatchCurrentProfile.addItemListener(e -> Settings.setProperty("dir2dat.match_profile", e.getStateChange() == 1));
        GridBagConstraints gbc_cbDir2DatMatchCurrentProfile = new GridBagConstraints();
        gbc_cbDir2DatMatchCurrentProfile.anchor = 17;
        gbc_cbDir2DatMatchCurrentProfile.insets = new Insets(0, 0, 5, 5);
        gbc_cbDir2DatMatchCurrentProfile.gridx = 1;
        gbc_cbDir2DatMatchCurrentProfile.gridy = 7;
        panelDir2DatOptions.add((Component)cbDir2DatMatchCurrentProfile, gbc_cbDir2DatMatchCurrentProfile);
        JCheckBox cbDir2DatIncludeEmptyDirs = new JCheckBox(Messages.getString("MainFrame.chckbxIncludeEmptyDirs.text"));
        cbDir2DatIncludeEmptyDirs.setSelected(Settings.getProperty("dir2dat.include_empty_dirs", false));
        cbDir2DatIncludeEmptyDirs.addItemListener(e -> Settings.setProperty("dir2dat.include_empty_dirs", e.getStateChange() == 1));
        GridBagConstraints gbc_cbDir2DatIncludeEmptyDirs = new GridBagConstraints();
        gbc_cbDir2DatIncludeEmptyDirs.anchor = 17;
        gbc_cbDir2DatIncludeEmptyDirs.insets = new Insets(0, 0, 5, 5);
        gbc_cbDir2DatIncludeEmptyDirs.gridx = 1;
        gbc_cbDir2DatIncludeEmptyDirs.gridy = 8;
        panelDir2DatOptions.add((Component)cbDir2DatIncludeEmptyDirs, gbc_cbDir2DatIncludeEmptyDirs);
        JPanel panelDir2DatHeaders = new JPanel();
        panelDir2DatHeaders.setBorder(new TitledBorder(null, Messages.getString("MainFrame.Headers"), 4, 2, null, null));
        GridBagConstraints gbc_panelDir2DatHeaders = new GridBagConstraints();
        gbc_panelDir2DatHeaders.insets = new Insets(0, 0, 5, 5);
        gbc_panelDir2DatHeaders.fill = 1;
        gbc_panelDir2DatHeaders.gridx = 1;
        gbc_panelDir2DatHeaders.gridy = 0;
        dir2datTab.add((Component)panelDir2DatHeaders, gbc_panelDir2DatHeaders);
        GridBagLayout gbl_panelDir2DatHeaders = new GridBagLayout();
        gbl_panelDir2DatHeaders.columnWidths = new int[]{0, 0, 0};
        gbl_panelDir2DatHeaders.rowHeights = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        gbl_panelDir2DatHeaders.columnWeights = new double[]{0.0, 1.0, Double.MIN_VALUE};
        gbl_panelDir2DatHeaders.rowWeights = new double[]{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, Double.MIN_VALUE};
        panelDir2DatHeaders.setLayout(gbl_panelDir2DatHeaders);
        JLabel lblDir2DatName = new JLabel(Messages.getString("MainFrame.lblName.text"));
        GridBagConstraints gbc_lblDir2DatName = new GridBagConstraints();
        gbc_lblDir2DatName.anchor = 13;
        gbc_lblDir2DatName.insets = new Insets(0, 0, 5, 5);
        gbc_lblDir2DatName.gridx = 0;
        gbc_lblDir2DatName.gridy = 1;
        panelDir2DatHeaders.add((Component)lblDir2DatName, gbc_lblDir2DatName);
        this.tfDir2DatName = new JTextField();
        this.tfDir2DatName.setText("");
        GridBagConstraints gbc_tfDir2DatName = new GridBagConstraints();
        gbc_tfDir2DatName.insets = new Insets(0, 0, 5, 0);
        gbc_tfDir2DatName.fill = 2;
        gbc_tfDir2DatName.gridx = 1;
        gbc_tfDir2DatName.gridy = 1;
        panelDir2DatHeaders.add((Component)this.tfDir2DatName, gbc_tfDir2DatName);
        this.tfDir2DatName.setColumns(20);
        JLabel lblDir2DatDescription = new JLabel(Messages.getString("MainFrame.lblDescription.text"));
        GridBagConstraints gbc_lblDir2DatDescription = new GridBagConstraints();
        gbc_lblDir2DatDescription.anchor = 13;
        gbc_lblDir2DatDescription.insets = new Insets(0, 0, 5, 5);
        gbc_lblDir2DatDescription.gridx = 0;
        gbc_lblDir2DatDescription.gridy = 2;
        panelDir2DatHeaders.add((Component)lblDir2DatDescription, gbc_lblDir2DatDescription);
        this.tfDir2DatDescription = new JTextField();
        this.tfDir2DatDescription.setText("");
        this.tfDir2DatDescription.setColumns(20);
        GridBagConstraints gbc_tfDir2DatDescription = new GridBagConstraints();
        gbc_tfDir2DatDescription.insets = new Insets(0, 0, 5, 0);
        gbc_tfDir2DatDescription.fill = 2;
        gbc_tfDir2DatDescription.gridx = 1;
        gbc_tfDir2DatDescription.gridy = 2;
        panelDir2DatHeaders.add((Component)this.tfDir2DatDescription, gbc_tfDir2DatDescription);
        JLabel lblDir2DatVersion = new JLabel(Messages.getString("MainFrame.lblVersion.text"));
        GridBagConstraints gbc_lblDir2DatVersion = new GridBagConstraints();
        gbc_lblDir2DatVersion.anchor = 13;
        gbc_lblDir2DatVersion.insets = new Insets(0, 0, 5, 5);
        gbc_lblDir2DatVersion.gridx = 0;
        gbc_lblDir2DatVersion.gridy = 3;
        panelDir2DatHeaders.add((Component)lblDir2DatVersion, gbc_lblDir2DatVersion);
        this.tfDir2DatVersion = new JTextField();
        this.tfDir2DatVersion.setText("");
        this.tfDir2DatVersion.setColumns(20);
        GridBagConstraints gbc_tfDir2DatVersion = new GridBagConstraints();
        gbc_tfDir2DatVersion.insets = new Insets(0, 0, 5, 0);
        gbc_tfDir2DatVersion.fill = 2;
        gbc_tfDir2DatVersion.gridx = 1;
        gbc_tfDir2DatVersion.gridy = 3;
        panelDir2DatHeaders.add((Component)this.tfDir2DatVersion, gbc_tfDir2DatVersion);
        JLabel lblDir2DatAuthor = new JLabel(Messages.getString("MainFrame.lblAuthor.text"));
        GridBagConstraints gbc_lblDir2DatAuthor = new GridBagConstraints();
        gbc_lblDir2DatAuthor.anchor = 13;
        gbc_lblDir2DatAuthor.insets = new Insets(0, 0, 5, 5);
        gbc_lblDir2DatAuthor.gridx = 0;
        gbc_lblDir2DatAuthor.gridy = 4;
        panelDir2DatHeaders.add((Component)lblDir2DatAuthor, gbc_lblDir2DatAuthor);
        this.tfDir2DatAuthor = new JTextField();
        this.tfDir2DatAuthor.setText("");
        this.tfDir2DatAuthor.setColumns(20);
        GridBagConstraints gbc_tfDir2DatAuthor = new GridBagConstraints();
        gbc_tfDir2DatAuthor.insets = new Insets(0, 0, 5, 0);
        gbc_tfDir2DatAuthor.fill = 2;
        gbc_tfDir2DatAuthor.gridx = 1;
        gbc_tfDir2DatAuthor.gridy = 4;
        panelDir2DatHeaders.add((Component)this.tfDir2DatAuthor, gbc_tfDir2DatAuthor);
        JLabel lblDir2DatComment = new JLabel(Messages.getString("MainFrame.lblComment.text"));
        GridBagConstraints gbc_lblDir2DatComment = new GridBagConstraints();
        gbc_lblDir2DatComment.insets = new Insets(0, 0, 5, 5);
        gbc_lblDir2DatComment.anchor = 13;
        gbc_lblDir2DatComment.gridx = 0;
        gbc_lblDir2DatComment.gridy = 5;
        panelDir2DatHeaders.add((Component)lblDir2DatComment, gbc_lblDir2DatComment);
        this.tfDir2DatComment = new JTextField();
        this.tfDir2DatComment.setText("");
        this.tfDir2DatComment.setColumns(20);
        GridBagConstraints gbc_tfDir2DatComment = new GridBagConstraints();
        gbc_tfDir2DatComment.insets = new Insets(0, 0, 5, 0);
        gbc_tfDir2DatComment.fill = 2;
        gbc_tfDir2DatComment.gridx = 1;
        gbc_tfDir2DatComment.gridy = 5;
        panelDir2DatHeaders.add((Component)this.tfDir2DatComment, gbc_tfDir2DatComment);
        JLabel lblDir2DatCategory = new JLabel(Messages.getString("MainFrame.lblCategory.text"));
        GridBagConstraints gbc_lblDir2DatCategory = new GridBagConstraints();
        gbc_lblDir2DatCategory.anchor = 13;
        gbc_lblDir2DatCategory.insets = new Insets(0, 0, 5, 5);
        gbc_lblDir2DatCategory.gridx = 0;
        gbc_lblDir2DatCategory.gridy = 6;
        panelDir2DatHeaders.add((Component)lblDir2DatCategory, gbc_lblDir2DatCategory);
        this.tfDir2DatCategory = new JTextField();
        this.tfDir2DatCategory.setText("");
        this.tfDir2DatCategory.setColumns(20);
        GridBagConstraints gbc_tfDir2DatCategory = new GridBagConstraints();
        gbc_tfDir2DatCategory.insets = new Insets(0, 0, 5, 0);
        gbc_tfDir2DatCategory.fill = 2;
        gbc_tfDir2DatCategory.gridx = 1;
        gbc_tfDir2DatCategory.gridy = 6;
        panelDir2DatHeaders.add((Component)this.tfDir2DatCategory, gbc_tfDir2DatCategory);
        JLabel lblDir2DatDate = new JLabel(Messages.getString("MainFrame.lblDate.text"));
        GridBagConstraints gbc_lblDir2DatDate = new GridBagConstraints();
        gbc_lblDir2DatDate.anchor = 13;
        gbc_lblDir2DatDate.insets = new Insets(0, 0, 5, 5);
        gbc_lblDir2DatDate.gridx = 0;
        gbc_lblDir2DatDate.gridy = 7;
        panelDir2DatHeaders.add((Component)lblDir2DatDate, gbc_lblDir2DatDate);
        this.tfDir2DatDate = new JTextField();
        this.tfDir2DatDate.setText("");
        this.tfDir2DatDate.setColumns(20);
        GridBagConstraints gbc_tfDir2DatDate = new GridBagConstraints();
        gbc_tfDir2DatDate.insets = new Insets(0, 0, 5, 0);
        gbc_tfDir2DatDate.fill = 2;
        gbc_tfDir2DatDate.gridx = 1;
        gbc_tfDir2DatDate.gridy = 7;
        panelDir2DatHeaders.add((Component)this.tfDir2DatDate, gbc_tfDir2DatDate);
        JLabel lblDir2DatEmail = new JLabel(Messages.getString("MainFrame.lblEmail.text"));
        GridBagConstraints gbc_lblDir2DatEmail = new GridBagConstraints();
        gbc_lblDir2DatEmail.anchor = 13;
        gbc_lblDir2DatEmail.insets = new Insets(0, 0, 5, 5);
        gbc_lblDir2DatEmail.gridx = 0;
        gbc_lblDir2DatEmail.gridy = 8;
        panelDir2DatHeaders.add((Component)lblDir2DatEmail, gbc_lblDir2DatEmail);
        this.tfDir2DatEMail = new JTextField();
        this.tfDir2DatEMail.setText("");
        this.tfDir2DatEMail.setColumns(20);
        GridBagConstraints gbc_tfDir2DatEMail = new GridBagConstraints();
        gbc_tfDir2DatEMail.insets = new Insets(0, 0, 5, 0);
        gbc_tfDir2DatEMail.fill = 2;
        gbc_tfDir2DatEMail.gridx = 1;
        gbc_tfDir2DatEMail.gridy = 8;
        panelDir2DatHeaders.add((Component)this.tfDir2DatEMail, gbc_tfDir2DatEMail);
        JLabel lblDir2DatHomepage = new JLabel(Messages.getString("MainFrame.lblHomepage.text"));
        GridBagConstraints gbc_lblDir2DatHomepage = new GridBagConstraints();
        gbc_lblDir2DatHomepage.anchor = 13;
        gbc_lblDir2DatHomepage.insets = new Insets(0, 0, 5, 5);
        gbc_lblDir2DatHomepage.gridx = 0;
        gbc_lblDir2DatHomepage.gridy = 9;
        panelDir2DatHeaders.add((Component)lblDir2DatHomepage, gbc_lblDir2DatHomepage);
        this.tfDir2DatHomepage = new JTextField();
        this.tfDir2DatHomepage.setText("");
        this.tfDir2DatHomepage.setColumns(20);
        GridBagConstraints gbc_tfDir2DatHomepage = new GridBagConstraints();
        gbc_tfDir2DatHomepage.insets = new Insets(0, 0, 5, 0);
        gbc_tfDir2DatHomepage.fill = 2;
        gbc_tfDir2DatHomepage.gridx = 1;
        gbc_tfDir2DatHomepage.gridy = 9;
        panelDir2DatHeaders.add((Component)this.tfDir2DatHomepage, gbc_tfDir2DatHomepage);
        JLabel lblDir2DatUrl = new JLabel(Messages.getString("MainFrame.lblUrl.text"));
        GridBagConstraints gbc_lblDir2DatUrl = new GridBagConstraints();
        gbc_lblDir2DatUrl.insets = new Insets(0, 0, 5, 5);
        gbc_lblDir2DatUrl.anchor = 13;
        gbc_lblDir2DatUrl.gridx = 0;
        gbc_lblDir2DatUrl.gridy = 10;
        panelDir2DatHeaders.add((Component)lblDir2DatUrl, gbc_lblDir2DatUrl);
        this.tfDir2DatURL = new JTextField();
        this.tfDir2DatURL.setText("");
        this.tfDir2DatURL.setColumns(20);
        GridBagConstraints gbc_tfDir2DatURL = new GridBagConstraints();
        gbc_tfDir2DatURL.insets = new Insets(0, 0, 5, 0);
        gbc_tfDir2DatURL.fill = 2;
        gbc_tfDir2DatURL.gridx = 1;
        gbc_tfDir2DatURL.gridy = 10;
        panelDir2DatHeaders.add((Component)this.tfDir2DatURL, gbc_tfDir2DatURL);
        JPanel panelDir2DatIO = new JPanel();
        panelDir2DatIO.setBorder(new TitledBorder(UIManager.getBorder("TitledBorder.border"), Messages.getString("MainFrame.IO"), 4, 2, null, new Color(0, 0, 0)));
        GridBagConstraints gbc_panelDir2DatIO = new GridBagConstraints();
        gbc_panelDir2DatIO.insets = new Insets(0, 5, 5, 5);
        gbc_panelDir2DatIO.gridwidth = 2;
        gbc_panelDir2DatIO.fill = 1;
        gbc_panelDir2DatIO.gridx = 0;
        gbc_panelDir2DatIO.gridy = 1;
        dir2datTab.add((Component)panelDir2DatIO, gbc_panelDir2DatIO);
        GridBagLayout gbl_panelDir2DatIO = new GridBagLayout();
        gbl_panelDir2DatIO.columnWidths = new int[]{0, 0, 0, 0, 0, 0, 0};
        gbl_panelDir2DatIO.rowHeights = new int[]{0, 0, 0, 0};
        gbl_panelDir2DatIO.columnWeights = new double[]{0.0, 1.0, 1.0, 1.0, 0.0, 0.0, Double.MIN_VALUE};
        gbl_panelDir2DatIO.rowWeights = new double[]{0.0, 0.0, 0.0, Double.MIN_VALUE};
        panelDir2DatIO.setLayout(gbl_panelDir2DatIO);
        JLabel lblDir2DatSrc = new JLabel(Messages.getString("MainFrame.lblSrcDir_1.text"));
        GridBagConstraints gbc_lblDir2DatSrc = new GridBagConstraints();
        gbc_lblDir2DatSrc.fill = 2;
        gbc_lblDir2DatSrc.insets = new Insets(0, 5, 5, 5);
        gbc_lblDir2DatSrc.gridx = 0;
        gbc_lblDir2DatSrc.gridy = 0;
        panelDir2DatIO.add((Component)lblDir2DatSrc, gbc_lblDir2DatSrc);
        this.tfDir2DatSrc = new JFileDropTextField(txt -> Settings.setProperty("dir2dat_src_dir", txt));
        this.tfDir2DatSrc.setText(Settings.getProperty("dir2dat_src_dir", ""));
        this.tfDir2DatSrc.setMode(JFileDropMode.DIRECTORY);
        this.tfDir2DatSrc.setUI(new JTextFieldHintUI(Messages.getString("MainFrame.DropDirHint"), Color.gray));
        this.tfDir2DatSrc.setColumns(10);
        GridBagConstraints gbc_tfDir2DatSrc = new GridBagConstraints();
        gbc_tfDir2DatSrc.gridwidth = 3;
        gbc_tfDir2DatSrc.insets = new Insets(0, 0, 5, 0);
        gbc_tfDir2DatSrc.fill = 1;
        gbc_tfDir2DatSrc.gridx = 1;
        gbc_tfDir2DatSrc.gridy = 0;
        panelDir2DatIO.add((Component)this.tfDir2DatSrc, gbc_tfDir2DatSrc);
        JButton btnDir2DatSrc = new JButton("");
        btnDir2DatSrc.setIcon(new ImageIcon(MainFrame.class.getResource("/jrm/resources/icons/disk.png")));
        btnDir2DatSrc.addActionListener(e -> {
            File workdir = Settings.getWorkPath().toFile();
            new JRMFileChooser<Void>(0, 1, new File(Settings.getProperty("MainFrame.ChooseDatSrc", workdir.getAbsolutePath())), new File(this.tfDir2DatSrc.getText()), null, Messages.getString("MainFrame.ChooseDatSrc"), false).show(this, chooser -> {
                Settings.setProperty("MainFrame.ChooseDatSrc", chooser.getCurrentDirectory().getAbsolutePath());
                this.tfDir2DatSrc.setText(chooser.getSelectedFile().getAbsolutePath());
                Settings.setProperty("dir2dat_src_dir", this.tfDir2DatSrc.getText());
                return null;
            });
        });
        GridBagConstraints gbc_btnDir2DatSrc = new GridBagConstraints();
        gbc_btnDir2DatSrc.insets = new Insets(0, 0, 5, 5);
        gbc_btnDir2DatSrc.gridx = 4;
        gbc_btnDir2DatSrc.gridy = 0;
        panelDir2DatIO.add((Component)btnDir2DatSrc, gbc_btnDir2DatSrc);
        JButton btnDir2DatGenerate = new JButton(Messages.getString("MainFrame.btnGenerate.text"));
        btnDir2DatGenerate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame.this.dir2dat();
            }
        });
        GridBagConstraints gbc_btnDir2DatGenerate = new GridBagConstraints();
        gbc_btnDir2DatGenerate.fill = 1;
        gbc_btnDir2DatGenerate.gridheight = 3;
        gbc_btnDir2DatGenerate.gridx = 5;
        gbc_btnDir2DatGenerate.gridy = 0;
        panelDir2DatIO.add((Component)btnDir2DatGenerate, gbc_btnDir2DatGenerate);
        JLabel lblDir2DatDst = new JLabel(Messages.getString("MainFrame.lblDstDat.text"));
        GridBagConstraints gbc_lblDir2DatDst = new GridBagConstraints();
        gbc_lblDir2DatDst.fill = 2;
        gbc_lblDir2DatDst.insets = new Insets(0, 5, 5, 5);
        gbc_lblDir2DatDst.gridx = 0;
        gbc_lblDir2DatDst.gridy = 1;
        panelDir2DatIO.add((Component)lblDir2DatDst, gbc_lblDir2DatDst);
        this.tfDir2DatDst = new JFileDropTextField(txt -> Settings.setProperty("dir2dat_dst_file", txt));
        this.tfDir2DatDst.setText(Settings.getProperty("dir2dat_dst_file", ""));
        this.tfDir2DatDst.setMode(JFileDropMode.FILE);
        this.tfDir2DatDst.setUI(new JTextFieldHintUI(Messages.getString("MainFrame.DropFileHint"), Color.gray));
        this.tfDir2DatDst.setColumns(10);
        GridBagConstraints gbc_tfDir2DatDst = new GridBagConstraints();
        gbc_tfDir2DatDst.gridwidth = 3;
        gbc_tfDir2DatDst.insets = new Insets(0, 0, 5, 0);
        gbc_tfDir2DatDst.fill = 1;
        gbc_tfDir2DatDst.gridx = 1;
        gbc_tfDir2DatDst.gridy = 1;
        panelDir2DatIO.add((Component)this.tfDir2DatDst, gbc_tfDir2DatDst);
        JButton btnDir2DatDst = new JButton("");
        btnDir2DatDst.setIcon(new ImageIcon(MainFrame.class.getResource("/jrm/resources/icons/disk.png")));
        btnDir2DatDst.addActionListener(e -> {
            File workdir = Settings.getWorkPath().toFile();
            new JRMFileChooser<Void>(1, 0, new File(Settings.getProperty("MainFrame.ChooseDatDst", workdir.getAbsolutePath())), new File(this.tfDir2DatDst.getText()), null, Messages.getString("MainFrame.ChooseDatDst"), false).show(this, chooser -> {
                Settings.setProperty("MainFrame.ChooseDatDst", chooser.getCurrentDirectory().getAbsolutePath());
                this.tfDir2DatDst.setText(chooser.getSelectedFile().getAbsolutePath());
                Settings.setProperty("dir2dat_dst_file", this.tfDir2DatDst.getText());
                return null;
            });
        });
        GridBagConstraints gbc_btnDir2DatDst = new GridBagConstraints();
        gbc_btnDir2DatDst.insets = new Insets(0, 0, 5, 5);
        gbc_btnDir2DatDst.gridx = 4;
        gbc_btnDir2DatDst.gridy = 1;
        panelDir2DatIO.add((Component)btnDir2DatDst, gbc_btnDir2DatDst);
        JLabel lblDir2DatFormat = new JLabel(Messages.getString("MainFrame.lblFormat.text"));
        lblDir2DatFormat.setHorizontalAlignment(11);
        GridBagConstraints gbc_lblDir2DatFormat = new GridBagConstraints();
        gbc_lblDir2DatFormat.fill = 2;
        gbc_lblDir2DatFormat.insets = new Insets(0, 0, 0, 5);
        gbc_lblDir2DatFormat.gridx = 0;
        gbc_lblDir2DatFormat.gridy = 2;
        panelDir2DatIO.add((Component)lblDir2DatFormat, gbc_lblDir2DatFormat);
        JRadioButton rdbtnDir2DatMame = new JRadioButton(Messages.getString("MainFrame.rdbtnMame.text"));
        rdbtnDir2DatMame.setSelected(Export.ExportType.valueOf(Settings.getProperty("dir2dat_format", Export.ExportType.MAME.toString())) == Export.ExportType.MAME);
        rdbtnDir2DatMame.addActionListener(e -> Settings.setProperty("dir2dat_format", Export.ExportType.MAME.toString()));
        this.Dir2DatFormatGroup.add(rdbtnDir2DatMame);
        GridBagConstraints gbc_rdbtnDir2DatMame = new GridBagConstraints();
        gbc_rdbtnDir2DatMame.insets = new Insets(0, 0, 0, 5);
        gbc_rdbtnDir2DatMame.gridx = 1;
        gbc_rdbtnDir2DatMame.gridy = 2;
        panelDir2DatIO.add((Component)rdbtnDir2DatMame, gbc_rdbtnDir2DatMame);
        JRadioButton rdbtnDir2DatLogiqxDat = new JRadioButton(Messages.getString("MainFrame.rdbtnLogiqxDat.text"));
        rdbtnDir2DatLogiqxDat.setSelected(Export.ExportType.valueOf(Settings.getProperty("dir2dat_format", Export.ExportType.MAME.toString())) == Export.ExportType.DATAFILE);
        rdbtnDir2DatLogiqxDat.addActionListener(e -> Settings.setProperty("dir2dat_format", Export.ExportType.DATAFILE.toString()));
        this.Dir2DatFormatGroup.add(rdbtnDir2DatLogiqxDat);
        GridBagConstraints gbc_rdbtnDir2DatLogiqxDat = new GridBagConstraints();
        gbc_rdbtnDir2DatLogiqxDat.insets = new Insets(0, 0, 0, 5);
        gbc_rdbtnDir2DatLogiqxDat.gridx = 2;
        gbc_rdbtnDir2DatLogiqxDat.gridy = 2;
        panelDir2DatIO.add((Component)rdbtnDir2DatLogiqxDat, gbc_rdbtnDir2DatLogiqxDat);
        JRadioButton rdbtnDir2DatSwList = new JRadioButton(Messages.getString("MainFrame.rdbtnSwList.text"));
        rdbtnDir2DatSwList.setSelected(Export.ExportType.valueOf(Settings.getProperty("dir2dat_format", Export.ExportType.MAME.toString())) == Export.ExportType.SOFTWARELIST);
        rdbtnDir2DatSwList.addActionListener(e -> Settings.setProperty("dir2dat_format", Export.ExportType.SOFTWARELIST.toString()));
        this.Dir2DatFormatGroup.add(rdbtnDir2DatSwList);
        GridBagConstraints gbc_rdbtnDir2DatSwList = new GridBagConstraints();
        gbc_rdbtnDir2DatSwList.gridwidth = 2;
        gbc_rdbtnDir2DatSwList.insets = new Insets(0, 0, 0, 5);
        gbc_rdbtnDir2DatSwList.gridx = 3;
        gbc_rdbtnDir2DatSwList.gridy = 2;
        panelDir2DatIO.add((Component)rdbtnDir2DatSwList, gbc_rdbtnDir2DatSwList);
    }

    private void buildBatchToolsTab() {
        JPanel batchToolsTab = new JPanel();
        this.mainPane.addTab(Messages.getString("MainFrame.BatchTools"), new ImageIcon(MainFrame.class.getResource("/jrm/resources/icons/application_osx_terminal.png")), batchToolsTab, null);
        batchToolsTab.setLayout(new BorderLayout(0, 0));
        JTabbedPane batchToolsTabbedPane = new JTabbedPane(1);
        batchToolsTab.add(batchToolsTabbedPane);
        JPanel panelBatchToolsDat2Dir = new JPanel();
        batchToolsTabbedPane.addTab(Messages.getString("MainFrame.panelBatchToolsDat2Dir.title"), null, panelBatchToolsDat2Dir, null);
        GridBagLayout gbl_panelBatchToolsDat2Dir = new GridBagLayout();
        gbl_panelBatchToolsDat2Dir.columnWidths = new int[]{0, 0, 0, 0};
        gbl_panelBatchToolsDat2Dir.rowHeights = new int[]{0, 0, 0, 0};
        gbl_panelBatchToolsDat2Dir.columnWeights = new double[]{1.0, 0.0, 0.0, Double.MIN_VALUE};
        gbl_panelBatchToolsDat2Dir.rowWeights = new double[]{1.0, 1.0, 0.0, Double.MIN_VALUE};
        panelBatchToolsDat2Dir.setLayout(gbl_panelBatchToolsDat2Dir);
        JScrollPane scrollPane_5 = new JScrollPane();
        scrollPane_5.setPreferredSize(new Dimension(2, 200));
        scrollPane_5.setBorder(new TitledBorder(null, Messages.getString("MainFrame.SrcDirs"), 4, 2, null, null));
        GridBagConstraints gbc_scrollPane_5 = new GridBagConstraints();
        gbc_scrollPane_5.gridwidth = 3;
        gbc_scrollPane_5.insets = new Insets(0, 0, 5, 0);
        gbc_scrollPane_5.fill = 1;
        gbc_scrollPane_5.gridx = 0;
        gbc_scrollPane_5.gridy = 0;
        panelBatchToolsDat2Dir.add((Component)scrollPane_5, gbc_scrollPane_5);
        this.listBatchToolsDat2DirSrc = new JFileDropList(files -> Settings.setProperty("dat2dir.srcdirs", String.join((CharSequence)"|", files.stream().map(f -> f.getAbsolutePath()).collect(Collectors.toList()))));
        for (String s : Settings.getProperty("dat2dir.srcdirs", "").split("\\|")) {
            if (s.isEmpty()) continue;
            ((DefaultListModel)this.listBatchToolsDat2DirSrc.getModel()).addElement(new File(s));
        }
        this.listBatchToolsDat2DirSrc.setMode(JFileDropMode.DIRECTORY);
        this.listBatchToolsDat2DirSrc.setUI(new JListHintUI(Messages.getString("MainFrame.DropDirHint"), Color.gray));
        this.listBatchToolsDat2DirSrc.setToolTipText(Messages.getString("MainFrame.listBatchToolsDat2DirSrc.toolTipText"));
        scrollPane_5.setViewportView(this.listBatchToolsDat2DirSrc);
        JPopupMenu popupMenu_2 = new JPopupMenu();
        MainFrame.addPopup(this.listBatchToolsDat2DirSrc, popupMenu_2);
        JMenuItem mnDat2DirAddSrcDir = new JMenuItem(Messages.getString("MainFrame.AddSrcDir"));
        mnDat2DirAddSrcDir.setEnabled(false);
        popupMenu_2.add(mnDat2DirAddSrcDir);
        JMenuItem mnDat2DirDelSrcDir = new JMenuItem(Messages.getString("MainFrame.DelSrcDir"));
        mnDat2DirDelSrcDir.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame.this.listBatchToolsDat2DirSrc.del(MainFrame.this.listBatchToolsDat2DirSrc.getSelectedValuesList());
            }
        });
        popupMenu_2.add(mnDat2DirDelSrcDir);
        JScrollPane scrollPane_6 = new JScrollPane();
        scrollPane_6.setPreferredSize(new Dimension(2, 200));
        GridBagConstraints gbc_scrollPane_6 = new GridBagConstraints();
        gbc_scrollPane_6.gridwidth = 3;
        gbc_scrollPane_6.insets = new Insets(0, 0, 5, 0);
        gbc_scrollPane_6.fill = 1;
        gbc_scrollPane_6.gridx = 0;
        gbc_scrollPane_6.gridy = 1;
        panelBatchToolsDat2Dir.add((Component)scrollPane_6, gbc_scrollPane_6);
        this.tableBatchToolsDat2Dir = new JSDRDropTable(new BatchTableModel(), new JSDRDropTable.AddDelCallBack(){

            @Override
            public void call(List<SDRTableModel.SrcDstResult> files) {
                JsonArray array = Json.array();
                for (SDRTableModel.SrcDstResult sdr : files) {
                    JsonObject jso = Json.object();
                    jso.add("src", sdr.src != null ? sdr.src.getAbsolutePath() : null);
                    jso.add("dst", sdr.dst != null ? sdr.dst.getAbsolutePath() : null);
                    jso.add("result", sdr.result);
                    jso.add("selected", sdr.selected);
                    array.add((JsonValue)jso);
                }
                Settings.setProperty("dat2dir.sdr", array.toString());
            }
        });
        ArrayList<SDRTableModel.SrcDstResult> sdrl = new ArrayList<SDRTableModel.SrcDstResult>();
        for (JsonValue arrv : Json.parse((String)Settings.getProperty("dat2dir.sdr", "[]")).asArray()) {
            JsonValue dst;
            SDRTableModel.SrcDstResult sdr = new SDRTableModel.SrcDstResult();
            JsonObject jso = arrv.asObject();
            JsonValue src = jso.get("src");
            if (src != Json.NULL) {
                sdr.src = new File(src.asString());
            }
            if ((dst = jso.get("dst")) != Json.NULL) {
                sdr.dst = new File(dst.asString());
            }
            JsonValue result = jso.get("result");
            sdr.result = result.asString();
            sdr.selected = jso.getBoolean("selected", true);
            sdrl.add(sdr);
        }
        this.tableBatchToolsDat2Dir.setUI(new JTableHintUI(Messages.getString("MainFrame.DropDatHint"), Color.gray));
        this.tableBatchToolsDat2Dir.getSDRModel().setData(sdrl);
        this.tableBatchToolsDat2Dir.setCellSelectionEnabled(false);
        this.tableBatchToolsDat2Dir.setRowSelectionAllowed(true);
        this.tableBatchToolsDat2Dir.getSDRModel().setSrcFilter(file -> {
            List<String> exts = Arrays.asList("xml", "dat");
            if (file.isFile()) {
                return exts.contains(FilenameUtils.getExtension(file.getName()));
            }
            if (file.isDirectory()) {
                return file.listFiles(f -> f.isFile() && exts.contains(FilenameUtils.getExtension(f.getName()))).length > 0;
            }
            return false;
        });
        this.tableBatchToolsDat2Dir.getSDRModel().setDstFilter(file -> file.isDirectory());
        this.tableBatchToolsDat2Dir.setSelectionMode(2);
        this.tableBatchToolsDat2Dir.setFillsViewportHeight(true);
        ((BatchTableModel)this.tableBatchToolsDat2Dir.getModel()).applyColumnsWidths(this.tableBatchToolsDat2Dir);
        scrollPane_6.setViewportView(this.tableBatchToolsDat2Dir);
        JPopupMenu popupMenu = new JPopupMenu();
        MainFrame.addPopup(this.tableBatchToolsDat2Dir, popupMenu);
        popupMenu.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                MainFrame.this.mnDat2DirPresets.setEnabled(MainFrame.this.tableBatchToolsDat2Dir.getSelectedRowCount() > 0);
            }
        });
        JMenuItem mnDat2DirAddDat = new JMenuItem(Messages.getString("MainFrame.AddDat"));
        mnDat2DirAddDat.setEnabled(false);
        popupMenu.add(mnDat2DirAddDat);
        JMenuItem mnDat2DirDelDat = new JMenuItem(Messages.getString("MainFrame.DelDat"));
        mnDat2DirDelDat.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame.this.tableBatchToolsDat2Dir.del(MainFrame.this.tableBatchToolsDat2Dir.getSelectedValuesList());
            }
        });
        popupMenu.add(mnDat2DirDelDat);
        this.mnDat2DirPresets = new JMenu(Messages.getString("MainFrame.Presets"));
        popupMenu.add(this.mnDat2DirPresets);
        JMenu mnDat2DirD2D = new JMenu(Messages.getString("MainFrame.Dir2DatMenu"));
        this.mnDat2DirPresets.add(mnDat2DirD2D);
        JMenuItem mntmDat2DirD2DTzip = new JMenuItem(Messages.getString("MainFrame.TZIP"));
        mntmDat2DirD2DTzip.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (SDRTableModel.SrcDstResult sdr : MainFrame.this.tableBatchToolsDat2Dir.getSelectedValuesList()) {
                    Properties settings = new Properties();
                    try {
                        settings.setProperty("need_sha1_or_md5", Boolean.FALSE.toString());
                        settings.setProperty("use_parallelism", Boolean.TRUE.toString());
                        settings.setProperty("create_mode", Boolean.TRUE.toString());
                        settings.setProperty("createfull_mode", Boolean.FALSE.toString());
                        settings.setProperty("ignore_unneeded_containers", Boolean.FALSE.toString());
                        settings.setProperty("ignore_unneeded_entries", Boolean.FALSE.toString());
                        settings.setProperty("ignore_unknown_containers", Boolean.TRUE.toString());
                        settings.setProperty("implicit_merge", Boolean.FALSE.toString());
                        settings.setProperty("ignore_merge_name_roms", Boolean.FALSE.toString());
                        settings.setProperty("ignore_merge_name_disks", Boolean.FALSE.toString());
                        settings.setProperty("exclude_games", Boolean.FALSE.toString());
                        settings.setProperty("exclude_machines", Boolean.FALSE.toString());
                        settings.setProperty("backup", Boolean.TRUE.toString());
                        settings.setProperty("format", FormatOptions.TZIP.toString());
                        settings.setProperty("merge_mode", MergeOptions.NOMERGE.toString());
                        settings.setProperty("archives_and_chd_as_roms", Boolean.FALSE.toString());
                        Profile.saveSettings(sdr.src, settings);
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                }
            }
        });
        mnDat2DirD2D.add(mntmDat2DirD2DTzip);
        JMenuItem mntmDat2DirD2DDir = new JMenuItem(Messages.getString("MainFrame.DIR"));
        mntmDat2DirD2DDir.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (SDRTableModel.SrcDstResult sdr : MainFrame.this.tableBatchToolsDat2Dir.getSelectedValuesList()) {
                    Properties settings = new Properties();
                    try {
                        settings.setProperty("need_sha1_or_md5", Boolean.FALSE.toString());
                        settings.setProperty("use_parallelism", Boolean.TRUE.toString());
                        settings.setProperty("create_mode", Boolean.TRUE.toString());
                        settings.setProperty("createfull_mode", Boolean.FALSE.toString());
                        settings.setProperty("ignore_unneeded_containers", Boolean.FALSE.toString());
                        settings.setProperty("ignore_unneeded_entries", Boolean.FALSE.toString());
                        settings.setProperty("ignore_unknown_containers", Boolean.TRUE.toString());
                        settings.setProperty("implicit_merge", Boolean.FALSE.toString());
                        settings.setProperty("ignore_merge_name_roms", Boolean.FALSE.toString());
                        settings.setProperty("ignore_merge_name_disks", Boolean.FALSE.toString());
                        settings.setProperty("exclude_games", Boolean.FALSE.toString());
                        settings.setProperty("exclude_machines", Boolean.FALSE.toString());
                        settings.setProperty("backup", Boolean.TRUE.toString());
                        settings.setProperty("format", FormatOptions.DIR.toString());
                        settings.setProperty("merge_mode", MergeOptions.NOMERGE.toString());
                        settings.setProperty("archives_and_chd_as_roms", Boolean.TRUE.toString());
                        Profile.saveSettings(sdr.src, settings);
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                }
            }
        });
        mnDat2DirD2D.add(mntmDat2DirD2DDir);
        JCheckBox cbBatchToolsDat2DirDryRun = new JCheckBox(Messages.getString("MainFrame.cbBatchToolsDat2DirDryRun.text"));
        cbBatchToolsDat2DirDryRun.setSelected(Settings.getProperty("dat2dir.dry_run", false));
        cbBatchToolsDat2DirDryRun.addItemListener(e -> Settings.setProperty("dat2dir.dry_run", e.getStateChange() == 1));
        JButton btnBatchToolsDir2DatStart = new JButton(Messages.getString("MainFrame.btnStart.text"));
        btnBatchToolsDir2DatStart.addActionListener(e -> this.dat2dir(cbBatchToolsDat2DirDryRun.isSelected()));
        GridBagConstraints gbc_cbBatchToolsDat2DirDryRun = new GridBagConstraints();
        gbc_cbBatchToolsDat2DirDryRun.insets = new Insets(0, 0, 0, 5);
        gbc_cbBatchToolsDat2DirDryRun.gridx = 1;
        gbc_cbBatchToolsDat2DirDryRun.gridy = 2;
        panelBatchToolsDat2Dir.add((Component)cbBatchToolsDat2DirDryRun, gbc_cbBatchToolsDat2DirDryRun);
        GridBagConstraints gbc_btnBatchToolsDir2DatStart = new GridBagConstraints();
        gbc_btnBatchToolsDir2DatStart.fill = 2;
        gbc_btnBatchToolsDir2DatStart.gridx = 2;
        gbc_btnBatchToolsDir2DatStart.gridy = 2;
        panelBatchToolsDat2Dir.add((Component)btnBatchToolsDir2DatStart, gbc_btnBatchToolsDir2DatStart);
        JPanel panelBatchToolsDir2Torrent = new JPanel();
        batchToolsTabbedPane.addTab(Messages.getString("MainFrame.panelBatchToolsDir2Torrent.title"), null, panelBatchToolsDir2Torrent, null);
        GridBagLayout gbl_panelBatchToolsDir2Torrent = new GridBagLayout();
        gbl_panelBatchToolsDir2Torrent.columnWidths = new int[]{0, 0, 0, 0};
        gbl_panelBatchToolsDir2Torrent.rowHeights = new int[]{0, 0, 0};
        gbl_panelBatchToolsDir2Torrent.columnWeights = new double[]{1.0, 0.0, 0.0, Double.MIN_VALUE};
        gbl_panelBatchToolsDir2Torrent.rowWeights = new double[]{1.0, 0.0, Double.MIN_VALUE};
        panelBatchToolsDir2Torrent.setLayout(gbl_panelBatchToolsDir2Torrent);
        JScrollPane scrollPane = new JScrollPane();
        GridBagConstraints gbc_scrollPane = new GridBagConstraints();
        gbc_scrollPane.gridwidth = 3;
        gbc_scrollPane.insets = new Insets(0, 0, 5, 0);
        gbc_scrollPane.fill = 1;
        gbc_scrollPane.gridx = 0;
        gbc_scrollPane.gridy = 0;
        panelBatchToolsDir2Torrent.add((Component)scrollPane, gbc_scrollPane);
        this.tableBatchToolsTrntChk = new JSDRDropTable(new BatchTableModel(new String[]{Messages.getString("MainFrame.TorrentFiles"), Messages.getString("MainFrame.DstDirs"), Messages.getString("MainFrame.Result"), "Selected"}), new JSDRDropTable.AddDelCallBack(){

            @Override
            public void call(List<SDRTableModel.SrcDstResult> files) {
                JsonArray array = Json.array();
                for (SDRTableModel.SrcDstResult sdr : files) {
                    JsonObject jso = Json.object();
                    jso.add("src", sdr.src != null ? sdr.src.getAbsolutePath() : null);
                    jso.add("dst", sdr.dst != null ? sdr.dst.getAbsolutePath() : null);
                    jso.add("result", sdr.result);
                    jso.add("selected", sdr.selected);
                    array.add((JsonValue)jso);
                }
                Settings.setProperty("trntchk.sdr", array.toString());
            }
        });
        ((BatchTableModel)this.tableBatchToolsTrntChk.getModel()).applyColumnsWidths(this.tableBatchToolsTrntChk);
        ArrayList<SDRTableModel.SrcDstResult> sdrl2 = new ArrayList<SDRTableModel.SrcDstResult>();
        for (JsonValue arrv : Json.parse((String)Settings.getProperty("trntchk.sdr", "[]")).asArray()) {
            JsonValue dst;
            SDRTableModel.SrcDstResult sdr = new SDRTableModel.SrcDstResult();
            JsonObject jso = arrv.asObject();
            JsonValue src = jso.get("src");
            if (src != Json.NULL) {
                sdr.src = new File(src.asString());
            }
            if ((dst = jso.get("dst")) != Json.NULL) {
                sdr.dst = new File(dst.asString());
            }
            JsonValue result = jso.get("result");
            sdr.result = result.asString();
            sdr.selected = jso.getBoolean("selected", true);
            sdrl2.add(sdr);
        }
        this.tableBatchToolsTrntChk.getSDRModel().setData(sdrl2);
        this.tableBatchToolsTrntChk.setUI(new JTableHintUI(Messages.getString("MainFrame.DropTrntHint"), Color.gray));
        this.tableBatchToolsTrntChk.setCellSelectionEnabled(false);
        this.tableBatchToolsTrntChk.setRowSelectionAllowed(true);
        this.tableBatchToolsTrntChk.getSDRModel().setSrcFilter(file -> {
            List<String> exts = Arrays.asList("torrent");
            if (file.isFile()) {
                return exts.contains(FilenameUtils.getExtension(file.getName()));
            }
            return false;
        });
        this.tableBatchToolsTrntChk.getSDRModel().setDstFilter(file -> file.isDirectory());
        this.tableBatchToolsTrntChk.setSelectionMode(2);
        this.tableBatchToolsTrntChk.setFillsViewportHeight(true);
        scrollPane.setViewportView(this.tableBatchToolsTrntChk);
        JPopupMenu pmTrntChk = new JPopupMenu();
        MainFrame.addPopup(this.tableBatchToolsTrntChk, pmTrntChk);
        JMenuItem mntmAddTorrent = new JMenuItem(Messages.getString("MainFrame.mntmAddTorrent.text"));
        mntmAddTorrent.setEnabled(false);
        pmTrntChk.add(mntmAddTorrent);
        JMenuItem mntmDelTorrent = new JMenuItem(Messages.getString("MainFrame.mntmDelTorrent.text"));
        mntmDelTorrent.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame.this.tableBatchToolsTrntChk.del(MainFrame.this.tableBatchToolsTrntChk.getSelectedValuesList());
            }
        });
        pmTrntChk.add(mntmDelTorrent);
        JLabel lblCheckMode = new JLabel(Messages.getString("MainFrame.lblCheckMode.text"));
        GridBagConstraints gbc_lblCheckMode = new GridBagConstraints();
        gbc_lblCheckMode.insets = new Insets(0, 0, 0, 5);
        gbc_lblCheckMode.anchor = 13;
        gbc_lblCheckMode.gridx = 0;
        gbc_lblCheckMode.gridy = 1;
        panelBatchToolsDir2Torrent.add((Component)lblCheckMode, gbc_lblCheckMode);
        this.cbBatchToolsTrntChk = new JComboBox();
        this.cbBatchToolsTrntChk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Settings.setProperty("trntchk.mode", MainFrame.this.cbBatchToolsTrntChk.getSelectedItem().toString());
            }
        });
        this.cbBatchToolsTrntChk.setModel(new DefaultComboBoxModel<TrntChkMode>(TrntChkMode.values()));
        this.cbBatchToolsTrntChk.setSelectedItem((Object)TrntChkMode.valueOf(Settings.getProperty("trntchk.mode", TrntChkMode.FILENAME.toString())));
        GridBagConstraints gbc_cbBatchToolsTrntChk = new GridBagConstraints();
        gbc_cbBatchToolsTrntChk.anchor = 13;
        gbc_cbBatchToolsTrntChk.insets = new Insets(0, 0, 0, 5);
        gbc_cbBatchToolsTrntChk.gridx = 1;
        gbc_cbBatchToolsTrntChk.gridy = 1;
        panelBatchToolsDir2Torrent.add(this.cbBatchToolsTrntChk, gbc_cbBatchToolsTrntChk);
        JButton btnBatchToolsTrntChkStart = new JButton(Messages.getString("MainFrame.btnStart_1.text"));
        btnBatchToolsTrntChkStart.addActionListener(e -> this.trrntChk());
        GridBagConstraints gbc_btnBatchToolsTrntChkStart = new GridBagConstraints();
        gbc_btnBatchToolsTrntChkStart.anchor = 13;
        gbc_btnBatchToolsTrntChkStart.gridx = 2;
        gbc_btnBatchToolsTrntChkStart.gridy = 1;
        panelBatchToolsDir2Torrent.add((Component)btnBatchToolsTrntChkStart, gbc_btnBatchToolsTrntChkStart);
    }

    private void buildSettingsTab() {
        JPanel settingsTab = new JPanel();
        this.mainPane.addTab(Messages.getString("MainFrame.Settings"), new ImageIcon(MainFrame.class.getResource("/jrm/resources/icons/cog.png")), settingsTab, null);
        settingsTab.setLayout(new BorderLayout(0, 0));
        this.settingsPane = new JTabbedPane(1);
        settingsTab.add(this.settingsPane);
        JPanel compressors = new JPanel();
        this.settingsPane.addTab(Messages.getString("MainFrame.Compressors"), new ImageIcon(MainFrame.class.getResource("/jrm/resources/icons/compress.png")), compressors, null);
        this.settingsPane.setEnabledAt(0, true);
        compressors.setLayout(new BorderLayout(0, 0));
        JTabbedPane compressorsPane = new JTabbedPane(1);
        compressors.add(compressorsPane);
        JPanel panelZip = new JPanel();
        compressorsPane.addTab(Messages.getString("MainFrame.Zip"), null, panelZip, null);
        GridBagLayout gbl_panelZip = new GridBagLayout();
        gbl_panelZip.columnWidths = new int[]{1, 0, 1, 0};
        gbl_panelZip.rowHeights = new int[]{0, 20, 20, 0, 0};
        gbl_panelZip.columnWeights = new double[]{1.0, 1.0, 1.0, Double.MIN_VALUE};
        gbl_panelZip.rowWeights = new double[]{1.0, 0.0, 0.0, 1.0, Double.MIN_VALUE};
        panelZip.setLayout(gbl_panelZip);
        JLabel lblTemporaryFilesThreshold = new JLabel(Messages.getString("MainFrame.lblTemporaryFilesThreshold.text"));
        lblTemporaryFilesThreshold.setHorizontalAlignment(11);
        GridBagConstraints gbc_lblTemporaryFilesThreshold = new GridBagConstraints();
        gbc_lblTemporaryFilesThreshold.fill = 2;
        gbc_lblTemporaryFilesThreshold.insets = new Insets(0, 0, 5, 5);
        gbc_lblTemporaryFilesThreshold.gridx = 0;
        gbc_lblTemporaryFilesThreshold.gridy = 1;
        panelZip.add((Component)lblTemporaryFilesThreshold, gbc_lblTemporaryFilesThreshold);
        this.cbbxZipTempThreshold = new JComboBox();
        this.cbbxZipTempThreshold.setModel(new DefaultComboBoxModel<ZipTempThreshold>(ZipTempThreshold.values()));
        this.cbbxZipTempThreshold.setSelectedItem((Object)ZipTempThreshold.valueOf(Settings.getProperty("zip_temp_threshold", ZipTempThreshold._10MB.toString())));
        this.cbbxZipTempThreshold.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Settings.setProperty("zip_temp_threshold", MainFrame.this.cbbxZipTempThreshold.getSelectedItem().toString());
            }
        });
        this.cbbxZipTempThreshold.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                this.setText(((ZipTempThreshold)((Object)value)).getName());
                return this;
            }
        });
        GridBagConstraints gbc_cbbxZipTempThreshold = new GridBagConstraints();
        gbc_cbbxZipTempThreshold.insets = new Insets(0, 0, 5, 5);
        gbc_cbbxZipTempThreshold.fill = 2;
        gbc_cbbxZipTempThreshold.gridx = 1;
        gbc_cbbxZipTempThreshold.gridy = 1;
        panelZip.add(this.cbbxZipTempThreshold, gbc_cbbxZipTempThreshold);
        JLabel lblCompressionLevel = new JLabel(Messages.getString("MainFrame.lblCompressionLevel.text"));
        lblCompressionLevel.setHorizontalAlignment(11);
        GridBagConstraints gbc_lblCompressionLevel = new GridBagConstraints();
        gbc_lblCompressionLevel.fill = 2;
        gbc_lblCompressionLevel.insets = new Insets(0, 0, 5, 5);
        gbc_lblCompressionLevel.gridx = 0;
        gbc_lblCompressionLevel.gridy = 2;
        panelZip.add((Component)lblCompressionLevel, gbc_lblCompressionLevel);
        this.cbbxZipLevel = new JComboBox();
        this.cbbxZipLevel.setModel(new DefaultComboBoxModel<ZipLevel>(ZipLevel.values()));
        this.cbbxZipLevel.setSelectedItem((Object)ZipLevel.valueOf(Settings.getProperty("zip_compression_level", ZipLevel.DEFAULT.toString())));
        this.cbbxZipLevel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Settings.setProperty("zip_compression_level", MainFrame.this.cbbxZipLevel.getSelectedItem().toString());
            }
        });
        this.cbbxZipLevel.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                this.setText(((ZipLevel)((Object)value)).getName());
                return this;
            }
        });
        GridBagConstraints gbc_cbbxZipLevel = new GridBagConstraints();
        gbc_cbbxZipLevel.fill = 1;
        gbc_cbbxZipLevel.insets = new Insets(0, 0, 5, 5);
        gbc_cbbxZipLevel.gridx = 1;
        gbc_cbbxZipLevel.gridy = 2;
        panelZip.add(this.cbbxZipLevel, gbc_cbbxZipLevel);
        JPanel panelZipE = new JPanel();
        compressorsPane.addTab(Messages.getString("MainFrame.ZipExternal"), null, panelZipE, null);
        GridBagLayout gbl_panelZipE = new GridBagLayout();
        gbl_panelZipE.columnWidths = new int[]{85, 246, 40, 0};
        gbl_panelZipE.rowHeights = new int[]{0, 28, 28, 28, 0, 0};
        gbl_panelZipE.columnWeights = new double[]{0.0, 1.0, 0.0, Double.MIN_VALUE};
        gbl_panelZipE.rowWeights = new double[]{1.0, 0.0, 0.0, 0.0, 1.0, Double.MIN_VALUE};
        panelZipE.setLayout(gbl_panelZipE);
        JLabel lblZipECmd = new JLabel(Messages.getString("MainFrame.lblZipECmd.text"));
        GridBagConstraints gbc_lblZipECmd = new GridBagConstraints();
        gbc_lblZipECmd.anchor = 13;
        gbc_lblZipECmd.insets = new Insets(5, 5, 5, 5);
        gbc_lblZipECmd.gridx = 0;
        gbc_lblZipECmd.gridy = 1;
        panelZipE.add((Component)lblZipECmd, gbc_lblZipECmd);
        this.tfZipECmd = new JFileDropTextField(txt -> Settings.setProperty("zip_cmd", txt));
        this.tfZipECmd.setMode(JFileDropMode.FILE);
        this.tfZipECmd.setUI(new JTextFieldHintUI(Messages.getString("MainFrame.DropDirHint"), Color.gray));
        this.tfZipECmd.setText(Settings.getProperty("zip_cmd", FindCmd.find7z()));
        GridBagConstraints gbc_tfZipECmd = new GridBagConstraints();
        gbc_tfZipECmd.insets = new Insets(0, 0, 5, 0);
        gbc_tfZipECmd.fill = 1;
        gbc_tfZipECmd.gridx = 1;
        gbc_tfZipECmd.gridy = 1;
        panelZipE.add((Component)this.tfZipECmd, gbc_tfZipECmd);
        this.tfZipECmd.setColumns(30);
        JButton btZipECmd = new JButton("");
        btZipECmd.setIcon(new ImageIcon(MainFrame.class.getResource("/jrm/resources/icons/disk.png")));
        GridBagConstraints gbc_btZipECmd = new GridBagConstraints();
        gbc_btZipECmd.fill = 1;
        gbc_btZipECmd.insets = new Insets(0, 0, 5, 5);
        gbc_btZipECmd.gridx = 2;
        gbc_btZipECmd.gridy = 1;
        panelZipE.add((Component)btZipECmd, gbc_btZipECmd);
        JLabel lblZipEArgs = new JLabel(Messages.getString("MainFrame.lblZipEArgs.text"));
        GridBagConstraints gbc_lblZipEArgs = new GridBagConstraints();
        gbc_lblZipEArgs.anchor = 13;
        gbc_lblZipEArgs.insets = new Insets(0, 5, 5, 5);
        gbc_lblZipEArgs.gridx = 0;
        gbc_lblZipEArgs.gridy = 2;
        panelZipE.add((Component)lblZipEArgs, gbc_lblZipEArgs);
        this.cbZipEArgs = new JComboBox();
        this.cbZipEArgs.setEditable(false);
        this.cbZipEArgs.setModel(new DefaultComboBoxModel<ZipOptions>(ZipOptions.values()));
        this.cbZipEArgs.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                this.setText(((ZipOptions)((Object)value)).getName());
                return this;
            }
        });
        this.cbZipEArgs.addActionListener(arg0 -> Settings.setProperty("zip_level", this.cbZipEArgs.getSelectedItem().toString()));
        this.cbZipEArgs.setSelectedItem((Object)ZipOptions.valueOf(Settings.getProperty("zip_level", ZipOptions.NORMAL.toString())));
        GridBagConstraints gbc_cbZipEArgs = new GridBagConstraints();
        gbc_cbZipEArgs.insets = new Insets(0, 0, 5, 5);
        gbc_cbZipEArgs.gridwidth = 2;
        gbc_cbZipEArgs.fill = 1;
        gbc_cbZipEArgs.gridx = 1;
        gbc_cbZipEArgs.gridy = 2;
        panelZipE.add(this.cbZipEArgs, gbc_cbZipEArgs);
        JLabel lblZipEThreads = new JLabel(Messages.getString("MainFrame.lblZipEThreads.text"));
        GridBagConstraints gbc_lblZipEThreads = new GridBagConstraints();
        gbc_lblZipEThreads.insets = new Insets(0, 0, 5, 5);
        gbc_lblZipEThreads.anchor = 13;
        gbc_lblZipEThreads.gridx = 0;
        gbc_lblZipEThreads.gridy = 3;
        panelZipE.add((Component)lblZipEThreads, gbc_lblZipEThreads);
        this.tfZipEThreads = new JTextField();
        this.tfZipEThreads.setText("1");
        GridBagConstraints gbc_tfZipEThreads = new GridBagConstraints();
        gbc_tfZipEThreads.fill = 3;
        gbc_tfZipEThreads.anchor = 17;
        gbc_tfZipEThreads.insets = new Insets(0, 0, 5, 5);
        gbc_tfZipEThreads.gridx = 1;
        gbc_tfZipEThreads.gridy = 3;
        panelZipE.add((Component)this.tfZipEThreads, gbc_tfZipEThreads);
        this.tfZipEThreads.setColumns(4);
        JLabel lblZipEWarning = new JLabel();
        lblZipEWarning.setVerticalAlignment(1);
        lblZipEWarning.setText(Messages.getString("MainFrame.lblZipEWarning.text"));
        lblZipEWarning.setHorizontalAlignment(0);
        lblZipEWarning.setFont(new Font("Tahoma", 3, 11));
        lblZipEWarning.setBackground(UIManager.getColor("Button.background"));
        GridBagConstraints gbc_lblZipEWarning = new GridBagConstraints();
        gbc_lblZipEWarning.gridwidth = 3;
        gbc_lblZipEWarning.gridx = 0;
        gbc_lblZipEWarning.gridy = 4;
        panelZipE.add((Component)lblZipEWarning, gbc_lblZipEWarning);
        JPanel panel7Zip = new JPanel();
        compressorsPane.addTab(Messages.getString("MainFrame.7zExternal"), null, panel7Zip, null);
        compressorsPane.setEnabledAt(2, true);
        GridBagLayout gbl_panel7Zip = new GridBagLayout();
        gbl_panel7Zip.columnWidths = new int[]{85, 123, 0, 40, 0};
        gbl_panel7Zip.rowHeights = new int[]{0, 28, 28, 28, 0, 0};
        gbl_panel7Zip.columnWeights = new double[]{0.0, 1.0, 1.0, 0.0, Double.MIN_VALUE};
        gbl_panel7Zip.rowWeights = new double[]{1.0, 0.0, 0.0, 0.0, 1.0, Double.MIN_VALUE};
        panel7Zip.setLayout(gbl_panel7Zip);
        JLabel lbl7zCmd = new JLabel(Messages.getString("MainFrame.lbl7zCmd.text"));
        GridBagConstraints gbc_lbl7zCmd = new GridBagConstraints();
        gbc_lbl7zCmd.anchor = 13;
        gbc_lbl7zCmd.insets = new Insets(5, 5, 5, 5);
        gbc_lbl7zCmd.gridx = 0;
        gbc_lbl7zCmd.gridy = 1;
        panel7Zip.add((Component)lbl7zCmd, gbc_lbl7zCmd);
        this.tf7zCmd = new JFileDropTextField(txt -> Settings.setProperty("7z_cmd", txt));
        this.tf7zCmd.setUI(new JTextFieldHintUI(Messages.getString("MainFrame.DropDirHint"), Color.gray));
        this.tf7zCmd.setMode(JFileDropMode.FILE);
        this.tf7zCmd.setText(Settings.getProperty("7z_cmd", FindCmd.find7z()));
        this.tf7zCmd.setColumns(30);
        GridBagConstraints gbc_tf7zCmd = new GridBagConstraints();
        gbc_tf7zCmd.gridwidth = 2;
        gbc_tf7zCmd.fill = 1;
        gbc_tf7zCmd.insets = new Insets(0, 0, 5, 0);
        gbc_tf7zCmd.gridx = 1;
        gbc_tf7zCmd.gridy = 1;
        panel7Zip.add((Component)this.tf7zCmd, gbc_tf7zCmd);
        JButton btn7zCmd = new JButton("");
        btn7zCmd.setIcon(new ImageIcon(MainFrame.class.getResource("/jrm/resources/icons/disk.png")));
        GridBagConstraints gbc_btn7zCmd = new GridBagConstraints();
        gbc_btn7zCmd.fill = 1;
        gbc_btn7zCmd.insets = new Insets(0, 0, 5, 5);
        gbc_btn7zCmd.gridx = 3;
        gbc_btn7zCmd.gridy = 1;
        panel7Zip.add((Component)btn7zCmd, gbc_btn7zCmd);
        JLabel lbl7zArgs = new JLabel(Messages.getString("MainFrame.lbl7zArgs.text"));
        GridBagConstraints gbc_lbl7zArgs = new GridBagConstraints();
        gbc_lbl7zArgs.anchor = 13;
        gbc_lbl7zArgs.insets = new Insets(0, 5, 5, 5);
        gbc_lbl7zArgs.gridx = 0;
        gbc_lbl7zArgs.gridy = 2;
        panel7Zip.add((Component)lbl7zArgs, gbc_lbl7zArgs);
        this.cb7zArgs = new JComboBox();
        this.cb7zArgs.addActionListener(arg0 -> Settings.setProperty("7z_level", this.cb7zArgs.getSelectedItem().toString()));
        this.cb7zArgs.setEditable(false);
        this.cb7zArgs.setModel(new DefaultComboBoxModel<SevenZipOptions>(SevenZipOptions.values()));
        this.cb7zArgs.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                this.setText(((SevenZipOptions)((Object)value)).getName());
                return this;
            }
        });
        this.cb7zArgs.setSelectedItem((Object)SevenZipOptions.valueOf(Settings.getProperty("7z_level", SevenZipOptions.NORMAL.toString())));
        GridBagConstraints gbc_cb7zArgs = new GridBagConstraints();
        gbc_cb7zArgs.fill = 1;
        gbc_cb7zArgs.gridwidth = 3;
        gbc_cb7zArgs.insets = new Insets(0, 0, 5, 5);
        gbc_cb7zArgs.gridx = 1;
        gbc_cb7zArgs.gridy = 2;
        panel7Zip.add(this.cb7zArgs, gbc_cb7zArgs);
        JLabel lbl7zThreads = new JLabel(Messages.getString("MainFrame.lbl7zThreads.text"));
        GridBagConstraints gbc_lbl7zThreads = new GridBagConstraints();
        gbc_lbl7zThreads.insets = new Insets(0, 0, 5, 5);
        gbc_lbl7zThreads.anchor = 13;
        gbc_lbl7zThreads.gridx = 0;
        gbc_lbl7zThreads.gridy = 3;
        panel7Zip.add((Component)lbl7zThreads, gbc_lbl7zThreads);
        this.tf7zThreads = new JTextField();
        this.tf7zThreads.setText(Integer.toString(Settings.getProperty("7z_threads", -1)));
        this.tf7zThreads.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                Settings.setProperty("7z_threads", MainFrame.this.tf7zThreads.getText());
            }
        });
        this.tf7zThreads.addActionListener(arg0 -> Settings.setProperty("7z_threads", this.tf7zThreads.getText()));
        GridBagConstraints gbc_tf7zThreads = new GridBagConstraints();
        gbc_tf7zThreads.fill = 3;
        gbc_tf7zThreads.anchor = 17;
        gbc_tf7zThreads.insets = new Insets(0, 0, 5, 5);
        gbc_tf7zThreads.gridx = 1;
        gbc_tf7zThreads.gridy = 3;
        panel7Zip.add((Component)this.tf7zThreads, gbc_tf7zThreads);
        this.tf7zThreads.setColumns(4);
        this.ckbx7zSolid = new JCheckBox(Messages.getString("MainFrame.ckbx7zSolid.text"));
        this.ckbx7zSolid.setSelected(Settings.getProperty("7z_solid", true));
        this.cb7zArgs.setEnabled(this.ckbx7zSolid.isSelected());
        this.ckbx7zSolid.addActionListener(arg0 -> {
            this.cb7zArgs.setEnabled(this.ckbx7zSolid.isSelected());
            Settings.setProperty("7z_solid", this.ckbx7zSolid.isSelected());
        });
        GridBagConstraints gbc_ckbx7zSolid = new GridBagConstraints();
        gbc_ckbx7zSolid.insets = new Insets(0, 0, 5, 5);
        gbc_ckbx7zSolid.gridx = 2;
        gbc_ckbx7zSolid.gridy = 3;
        panel7Zip.add((Component)this.ckbx7zSolid, gbc_ckbx7zSolid);
        JLabel lbl7zWarning = new JLabel();
        lbl7zWarning.setVerticalAlignment(1);
        lbl7zWarning.setText(Messages.getString("MainFrame.lbl7zWarning.text"));
        lbl7zWarning.setHorizontalAlignment(0);
        lbl7zWarning.setFont(new Font("Tahoma", 3, 11));
        lbl7zWarning.setBackground(UIManager.getColor("Button.background"));
        GridBagConstraints gbc_lbl7zWarning = new GridBagConstraints();
        gbc_lbl7zWarning.gridwidth = 4;
        gbc_lbl7zWarning.gridx = 0;
        gbc_lbl7zWarning.gridy = 4;
        panel7Zip.add((Component)lbl7zWarning, gbc_lbl7zWarning);
        this.buildSettingsDebugTab();
    }

    private void buildSettingsDebugTab() {
        JPanel debug = new JPanel();
        this.settingsPane.addTab(Messages.getString("MainFrame.Debug"), new ImageIcon(MainFrame.class.getResource("/jrm/resources/icons/bug.png")), debug, null);
        GridBagLayout gbl_debug = new GridBagLayout();
        gbl_debug.columnWidths = new int[]{100, 0, 0, 0};
        gbl_debug.rowHeights = new int[]{0, 0, 0, 0, 0, 0, 0};
        gbl_debug.columnWeights = new double[]{0.0, 1.0, 0.0, Double.MIN_VALUE};
        gbl_debug.rowWeights = new double[]{1.0, 0.0, 0.0, 0.0, 0.0, 1.0, Double.MIN_VALUE};
        debug.setLayout(gbl_debug);
        JLabel lblLogLevel = new JLabel(Messages.getString("MainFrame.lblLogLevel.text"));
        GridBagConstraints gbc_lblLogLevel = new GridBagConstraints();
        gbc_lblLogLevel.anchor = 13;
        gbc_lblLogLevel.fill = 3;
        gbc_lblLogLevel.insets = new Insets(0, 0, 5, 5);
        gbc_lblLogLevel.gridx = 0;
        gbc_lblLogLevel.gridy = 1;
        debug.add((Component)lblLogLevel, gbc_lblLogLevel);
        this.cbLogLevel = new JComboBox();
        this.cbLogLevel.setEnabled(false);
        GridBagConstraints gbc_cbLogLevel = new GridBagConstraints();
        gbc_cbLogLevel.gridwidth = 2;
        gbc_cbLogLevel.insets = new Insets(0, 0, 5, 5);
        gbc_cbLogLevel.fill = 2;
        gbc_cbLogLevel.gridx = 1;
        gbc_cbLogLevel.gridy = 1;
        debug.add(this.cbLogLevel, gbc_cbLogLevel);
        JLabel lblMemory = new JLabel(Messages.getString("MainFrame.lblMemory.text"));
        lblMemory.setHorizontalAlignment(11);
        GridBagConstraints gbc_lblMemory = new GridBagConstraints();
        gbc_lblMemory.fill = 2;
        gbc_lblMemory.insets = new Insets(0, 0, 5, 5);
        gbc_lblMemory.gridx = 0;
        gbc_lblMemory.gridy = 2;
        debug.add((Component)lblMemory, gbc_lblMemory);
        this.lblMemoryUsage = new JLabel(" ");
        this.lblMemoryUsage.setBorder(new SoftBevelBorder(1, null, null, null, null));
        GridBagConstraints gbc_lblMemoryUsage = new GridBagConstraints();
        gbc_lblMemoryUsage.fill = 1;
        gbc_lblMemoryUsage.insets = new Insets(0, 0, 5, 2);
        gbc_lblMemoryUsage.gridx = 1;
        gbc_lblMemoryUsage.gridy = 2;
        debug.add((Component)this.lblMemoryUsage, gbc_lblMemoryUsage);
        JButton btnGc = new JButton(Messages.getString("MainFrame.btnGc.text"));
        btnGc.addActionListener(e -> {
            System.gc();
            this.updateMemory();
        });
        GridBagConstraints gbc_btnGc = new GridBagConstraints();
        gbc_btnGc.fill = 2;
        gbc_btnGc.insets = new Insets(0, 0, 5, 5);
        gbc_btnGc.gridx = 2;
        gbc_btnGc.gridy = 2;
        debug.add((Component)btnGc, gbc_btnGc);
    }

    public void initProfileSettings() {
        this.chckbxNeedSHA1.setSelected(Profile.curr_profile.getProperty("need_sha1_or_md5", false));
        this.chckbxUseParallelism.setSelected(Profile.curr_profile.getProperty("use_parallelism", false));
        this.chckbxCreateMissingSets.setSelected(Profile.curr_profile.getProperty("create_mode", false));
        this.chckbxCreateOnlyComplete.setSelected(Profile.curr_profile.getProperty("createfull_mode", false) && this.chckbxCreateMissingSets.isSelected());
        this.chckbxIgnoreUnneededContainers.setSelected(Profile.curr_profile.getProperty("ignore_unneeded_containers", false));
        this.chckbxIgnoreUnneededEntries.setSelected(Profile.curr_profile.getProperty("ignore_unneeded_entries", false));
        this.chckbxIgnoreUnknownContainers.setSelected(Profile.curr_profile.getProperty("ignore_unknown_containers", false));
        this.chckbxCreateOnlyComplete.setEnabled(this.chckbxCreateMissingSets.isSelected());
        this.chckbxUseImplicitMerge.setSelected(Profile.curr_profile.getProperty("implicit_merge", false));
        this.chckbxIgnoreMergeNameRoms.setSelected(Profile.curr_profile.getProperty("ignore_merge_name_roms", false));
        this.chckbxIgnoreMergeNameDisks.setSelected(Profile.curr_profile.getProperty("ignore_merge_name_disks", false));
        this.chckbxExcludeGames.setSelected(Profile.curr_profile.getProperty("exclude_games", false));
        this.chckbxExcludeMachines.setSelected(Profile.curr_profile.getProperty("exclude_machines", false));
        this.chckbxBackup.setSelected(Profile.curr_profile.getProperty("backup", true));
        this.txtRomsDest.setText(Profile.curr_profile.getProperty("roms_dest_dir", ""));
        this.lblDisksDest.setSelected(Profile.curr_profile.getProperty("disks_dest_dir_enabled", false));
        this.tfDisksDest.setText(Profile.curr_profile.getProperty("disks_dest_dir", ""));
        this.lblSWDest.setSelected(Profile.curr_profile.getProperty("swroms_dest_dir_enabled", false));
        this.tfSWDest.setText(Profile.curr_profile.getProperty("swroms_dest_dir", ""));
        this.lblSWDisksDest.setSelected(Profile.curr_profile.getProperty("swdisks_dest_dir_enabled", false));
        this.tfSWDisksDest.setText(Profile.curr_profile.getProperty("swdisks_dest_dir", ""));
        this.lblSamplesDest.setSelected(Profile.curr_profile.getProperty("samples_dest_dir_enabled", false));
        this.tfSamplesDest.setText(Profile.curr_profile.getProperty("samples_dest_dir", ""));
        ((DefaultListModel)this.listSrcDir.getModel()).removeAllElements();
        for (String s : Profile.curr_profile.getProperty("src_dir", "").split("\\|")) {
            if (s.isEmpty()) continue;
            ((DefaultListModel)this.listSrcDir.getModel()).addElement(new File(s));
        }
        this.cbCompression.setSelectedItem((Object)FormatOptions.valueOf(Profile.curr_profile.settings.getProperty("format", FormatOptions.ZIP.toString())));
        this.cbbxMergeMode.setSelectedItem((Object)MergeOptions.valueOf(Profile.curr_profile.settings.getProperty("merge_mode", MergeOptions.SPLIT.toString())));
        Anyware.merge_mode = (MergeOptions)((Object)this.cbbxMergeMode.getSelectedItem());
        this.cbHashCollision.setEnabled(((MergeOptions)((Object)this.cbbxMergeMode.getSelectedItem())).isMerge());
        this.cbHashCollision.setSelectedItem((Object)HashCollisionOptions.valueOf(Profile.curr_profile.settings.getProperty("hash_collision_mode", HashCollisionOptions.SINGLEFILE.toString())));
        Anyware.hash_collision_mode = (HashCollisionOptions)((Object)this.cbHashCollision.getSelectedItem());
        this.chckbxIncludeClones.setSelected(Profile.curr_profile.getProperty("filter.InclClones", true));
        this.chckbxIncludeDisks.setSelected(Profile.curr_profile.getProperty("filter.InclDisks", true));
        this.chckbxIncludeSamples.setSelected(Profile.curr_profile.getProperty("filter.InclSamples", true));
        this.cbbxDriverStatus.setSelectedItem((Object)Driver.StatusType.valueOf(Profile.curr_profile.getProperty("filter.DriverStatus", Driver.StatusType.preliminary.toString())));
        this.cbbxFilterCabinetType.setSelectedItem((Object)Machine.CabinetType.valueOf(Profile.curr_profile.getProperty("filter.CabinetType", Machine.CabinetType.any.toString())));
        this.cbbxFilterDisplayOrientation.setSelectedItem((Object)Machine.DisplayOrientation.valueOf(Profile.curr_profile.getProperty("filter.DisplayOrientation", Machine.DisplayOrientation.any.toString())));
        this.cbbxSWMinSupportedLvl.setSelectedItem(Software.Supported.valueOf(Profile.curr_profile.getProperty("filter.MinSoftwareSupportedLevel", Software.Supported.no.toString())));
        this.cbbxYearMin.setModel(new Years(Profile.curr_profile.years));
        this.cbbxYearMin.setSelectedItem(Profile.curr_profile.getProperty("filter.YearMin", (String)this.cbbxYearMin.getModel().getElementAt(0)));
        this.cbbxYearMax.setModel(new Years(Profile.curr_profile.years));
        this.cbbxYearMax.setSelectedItem(Profile.curr_profile.getProperty("filter.YearMax", (String)this.cbbxYearMax.getModel().getElementAt(this.cbbxYearMax.getModel().getSize() - 1)));
        this.tfNPlayers.setText(Profile.curr_profile.nplayers != null ? Profile.curr_profile.nplayers.file.getAbsolutePath() : null);
        this.listNPlayers.setModel(Profile.curr_profile.nplayers != null ? Profile.curr_profile.nplayers : new DefaultListModel());
        this.tfCatVer.setText(Profile.curr_profile.catver != null ? Profile.curr_profile.catver.file.getAbsolutePath() : null);
        this.treeCatVer.setModel(Profile.curr_profile.catver != null ? new CatVerModel(Profile.curr_profile.catver) : new CatVerModel());
    }

    private void importDat(boolean sl) {
        new Thread(() -> {
            List<FileFilter> filters = Arrays.asList(new FileFilter(){

                @Override
                public boolean accept(File f) {
                    return f.isDirectory() || FilenameUtils.isExtension(f.getName(), "exe") || f.canExecute();
                }

                @Override
                public String getDescription() {
                    return Messages.getString("MainFrame.MameExecutable");
                }
            }, new FileNameExtensionFilter(Messages.getString("MainFrame.DatFile"), "dat", "xml"));
            new JRMFileChooser<Void>(0, 0, Optional.ofNullable(Settings.getProperty("MainFrame.ChooseExeOrDatToImport", null)).map(File::new).orElse(null), null, filters, Messages.getString("MainFrame.ChooseExeOrDatToImport"), true).show(this, chooser -> {
                Progress progress = new Progress((Window)this);
                Settings.setProperty("MainFrame.ChooseExeOrDatToImport", chooser.getCurrentDirectory().getAbsolutePath());
                for (File selectedfile : chooser.getSelectedFiles()) {
                    progress.setVisible(true);
                    progress.setProgress(Messages.getString("MainFrame.ImportingFromMame"), -1);
                    Import imprt = new Import(selectedfile, sl);
                    progress.dispose();
                    File workdir = Settings.getWorkPath().toFile();
                    File xmldir = new File(workdir, "xmlfiles");
                    new JRMFileChooser(new JRMFileChooser.OneRootFileSystemView(xmldir)).setup(1, 0, null, new File(xmldir, imprt.file.getName()), Collections.singletonList(new FileNameExtensionFilter(Messages.getString("MainFrame.DatFile"), "dat", "xml", "jrm")), Messages.getString("MainFrame.ChooseFileName"), false).show(this, chooser1 -> {
                        try {
                            DirTreeModel model;
                            DirNode root;
                            DirNode theNode;
                            File file = chooser1.getSelectedFile();
                            File parent = file.getParentFile();
                            FileUtils.copyFile(imprt.file, file);
                            if (imprt.is_mame) {
                                ProfileNFO pnfo = ProfileNFO.load(file);
                                pnfo.mame.set(imprt.org_file, sl);
                                if (imprt.roms_file != null) {
                                    FileUtils.copyFileToDirectory(imprt.roms_file, parent);
                                    pnfo.mame.fileroms = new File(parent, imprt.roms_file.getName());
                                    if (imprt.sl_file != null) {
                                        FileUtils.copyFileToDirectory(imprt.sl_file, parent);
                                        pnfo.mame.filesl = new File(parent, imprt.sl_file.getName());
                                    }
                                }
                                pnfo.save();
                            }
                            if ((theNode = (root = (DirNode)(model = (DirTreeModel)this.profilesTree.getModel()).getRoot()).find(parent)) != null) {
                                theNode.reload();
                                model.reload(theNode);
                                theNode = root.find(parent);
                                if (theNode != null) {
                                    this.profilesTree.clearSelection();
                                    this.profilesTree.setSelectionPath(new TreePath(model.getPathToRoot(theNode)));
                                } else {
                                    System.err.println(Messages.getString("MainFrame.FinalNodeNotFound"));
                                }
                            } else {
                                System.err.println(Messages.getString("MainFrame.NodeNotFound"));
                            }
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        return null;
                    });
                }
                return null;
            });
        }).start();
    }

    private void loadProfile(final ProfileNFO profile) {
        if (Profile.curr_profile != null) {
            Profile.curr_profile.saveSettings();
        }
        final Progress progress = new Progress((Window)this);
        SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){
            boolean success = false;

            @Override
            protected Void doInBackground() throws Exception {
                if (profile_viewer != null) {
                    profile_viewer.clear();
                }
                this.success = null != (Profile.curr_profile = Profile.load(profile, (ProgressHandler)progress));
                Scan.report.setProfile(Profile.curr_profile);
                if (profile_viewer != null) {
                    profile_viewer.reset(Profile.curr_profile);
                }
                MainFrame.this.mainPane.setEnabledAt(1, this.success);
                MainFrame.this.btnScan.setEnabled(this.success);
                MainFrame.this.btnFix.setEnabled(false);
                MainFrame.this.lblProfileinfo.setText(Profile.curr_profile.getName());
                MainFrame.this.checkBoxListSystems.setModel(Profile.curr_profile.systems);
                return null;
            }

            @Override
            protected void done() {
                progress.dispose();
                if (this.success && Profile.curr_profile != null) {
                    MainFrame.this.initProfileSettings();
                    MainFrame.this.mainPane.setSelectedIndex(1);
                }
            }
        };
        worker.execute();
        progress.setVisible(true);
    }

    private void scan() {
        String txtdstdir = this.txtRomsDest.getText();
        if (txtdstdir.isEmpty()) {
            this.btnRomsDest.doClick();
            txtdstdir = this.txtRomsDest.getText();
        }
        if (txtdstdir.isEmpty()) {
            return;
        }
        final Progress progress = new Progress((Window)this);
        SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                MainFrame.this.curr_scan = new Scan(Profile.curr_profile, progress);
                MainFrame.this.btnFix.setEnabled(((MainFrame)MainFrame.this).curr_scan.actions.stream().mapToInt(Collection::size).sum() > 0);
                return null;
            }

            @Override
            protected void done() {
                progress.dispose();
            }
        };
        worker.execute();
        progress.setVisible(true);
    }

    private void fix() {
        final Progress progress = new Progress((Window)this);
        SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                if (Profile.curr_profile.hasPropsChanged()) {
                    switch (JOptionPane.showConfirmDialog(MainFrame.this, Messages.getString("MainFrame.WarnSettingsChanged"), Messages.getString("MainFrame.RescanBeforeFix"), 1)) {
                        case 0: {
                            MainFrame.this.curr_scan = new Scan(Profile.curr_profile, progress);
                            MainFrame.this.btnFix.setEnabled(((MainFrame)MainFrame.this).curr_scan.actions.stream().mapToInt(Collection::size).sum() > 0);
                            if (MainFrame.this.btnFix.isEnabled()) break;
                            return null;
                        }
                        case 1: {
                            break;
                        }
                        default: {
                            return null;
                        }
                    }
                }
                Fix fix = new Fix(Profile.curr_profile, MainFrame.this.curr_scan, progress);
                MainFrame.this.btnFix.setEnabled(fix.getActionsRemain() > 0);
                return null;
            }

            @Override
            protected void done() {
                progress.dispose();
            }
        };
        worker.execute();
        progress.setVisible(true);
    }

    private void updateMemory() {
        Runtime rt = Runtime.getRuntime();
        this.lblMemoryUsage.setText(String.format(Messages.getString("MainFrame.MemoryUsage"), String.format("%.2f MiB", (double)rt.totalMemory() / 1048576.0), String.format("%.2f MiB", (double)(rt.totalMemory() - rt.freeMemory()) / 1048576.0), String.format("%.2f MiB", (double)rt.freeMemory() / 1048576.0), String.format("%.2f MiB", (double)rt.maxMemory() / 1048576.0)));
    }

    private void dir2dat() {
        final Progress progress = new Progress((Window)this);
        SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                File dstdat;
                File srcdir;
                String src = MainFrame.this.tfDir2DatSrc.getText();
                String dst = MainFrame.this.tfDir2DatDst.getText();
                if (src != null && src.length() > 0 && dst != null && dst.length() > 0 && (srcdir = new File(src)).isDirectory() && (dstdat = new File(dst)).getParentFile().isDirectory() && (dstdat.exists() || dstdat.createNewFile())) {
                    EnumSet<DirScan.Options> options = EnumSet.of(DirScan.Options.USE_PARALLELISM, DirScan.Options.MD5_DISKS, DirScan.Options.SHA1_DISKS);
                    if (Settings.getProperty("dir2dat.scan_subfolders", true)) {
                        options.add(DirScan.Options.RECURSE);
                    }
                    if (!Settings.getProperty("dir2dat.deep_scan", false)) {
                        options.add(DirScan.Options.IS_DEST);
                    }
                    if (Settings.getProperty("dir2dat.add_md5", false)) {
                        options.add(DirScan.Options.NEED_MD5);
                    }
                    if (Settings.getProperty("dir2dat.add_sha1", false)) {
                        options.add(DirScan.Options.NEED_SHA1);
                    }
                    if (Settings.getProperty("dir2dat.junk_folders", false)) {
                        options.add(DirScan.Options.JUNK_SUBFOLDERS);
                    }
                    if (Settings.getProperty("dir2dat.do_not_scan_archives", false)) {
                        options.add(DirScan.Options.ARCHIVES_AND_CHD_AS_ROMS);
                    }
                    if (Settings.getProperty("dir2dat.match_profile", false)) {
                        options.add(DirScan.Options.MATCH_PROFILE);
                    }
                    if (Settings.getProperty("dir2dat.include_empty_dirs", false)) {
                        options.add(DirScan.Options.EMPTY_DIRS);
                    }
                    Export.ExportType type = Export.ExportType.valueOf(Settings.getProperty("dir2dat_format", Export.ExportType.MAME.toString()));
                    HashMap<String, String> headers = new HashMap<String, String>();
                    headers.put("name", MainFrame.this.tfDir2DatName.getText());
                    headers.put("description", MainFrame.this.tfDir2DatDescription.getText());
                    headers.put("version", MainFrame.this.tfDir2DatVersion.getText());
                    headers.put("author", MainFrame.this.tfDir2DatAuthor.getText());
                    headers.put("comment", MainFrame.this.tfDir2DatComment.getText());
                    headers.put("category", MainFrame.this.tfDir2DatCategory.getText());
                    headers.put("date", MainFrame.this.tfDir2DatDate.getText());
                    headers.put("email", MainFrame.this.tfDir2DatEMail.getText());
                    headers.put("homepage", MainFrame.this.tfDir2DatHomepage.getText());
                    headers.put("url", MainFrame.this.tfDir2DatURL.getText());
                    new Dir2Dat(srcdir, dstdat, progress, options, type, headers);
                }
                return null;
            }

            @Override
            protected void done() {
                progress.dispose();
            }
        };
        worker.execute();
        progress.setVisible(true);
    }

    private void dat2dir(final boolean dryrun) {
        if (((DefaultListModel)this.listBatchToolsDat2DirSrc.getModel()).getSize() > 0) {
            final List<SDRTableModel.SrcDstResult> sdrl = ((SDRTableModel)this.tableBatchToolsDat2Dir.getModel()).getData();
            if (sdrl.stream().filter(sdr -> !Profile.getSettingsFile(sdr.src).exists()).count() > 0L) {
                JOptionPane.showMessageDialog(this, Messages.getString("MainFrame.AllDatsPresetsAssigned"));
            } else {
                final Progress progress = new Progress((Window)this);
                SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

                    @Override
                    protected Void doInBackground() throws Exception {
                        new DirUpdater(sdrl, progress, Collections.list(((DefaultListModel)MainFrame.this.listBatchToolsDat2DirSrc.getModel()).elements()), MainFrame.this.tableBatchToolsDat2Dir, dryrun);
                        return null;
                    }

                    @Override
                    protected void done() {
                        progress.dispose();
                    }
                };
                worker.execute();
                progress.setVisible(true);
            }
        } else {
            JOptionPane.showMessageDialog(this, Messages.getString("MainFrame.AtLeastOneSrcDir"));
        }
    }

    private void trrntChk() {
        final Progress progress = new Progress((Window)this);
        SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                List<SDRTableModel.SrcDstResult> sdrl = ((SDRTableModel)MainFrame.this.tableBatchToolsTrntChk.getModel()).getData();
                TrntChkMode mode = (TrntChkMode)((Object)MainFrame.this.cbBatchToolsTrntChk.getSelectedItem());
                JSDRDropTable updater = MainFrame.this.tableBatchToolsTrntChk;
                new TorrentChecker(progress, sdrl, mode, updater);
                return null;
            }

            @Override
            protected void done() {
                progress.dispose();
            }
        };
        worker.execute();
        progress.setVisible(true);
    }

    private static void addPopup(Component component, final JPopupMenu popup) {
        component.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.showMenu(e);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.showMenu(e);
                }
            }

            private void showMenu(MouseEvent e) {
                popup.show(e.getComponent(), e.getX(), e.getY());
            }
        });
    }
}

