/*
 * Decompiled with CFR 0.152.
 */
package org.dbuml.base.controller.ui;

import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.table.AbstractTableModel;
import org.dbuml.base.controller.Util;
import org.dbuml.base.controller.ui.Counter;
import org.dbuml.base.database.QueryTransaction;
import org.dbuml.base.factory.Factory;
import org.dbuml.base.i18n.Translator;
import org.dbuml.base.model.Database;

public class ResultSetTable
extends JDialog {
    private JButton selectButton;
    private JButton closeButton;
    private JButton clearButton;
    private JButton nextButton;
    private JFrame frame = new JFrame();
    private JTextArea queryTextArea;
    private JComponent queryAggregate;
    private JPanel mainPanel;
    private JTable table;
    private JPanel textAreaPanel = new JPanel();
    private JPanel buttonSelectPanel = new JPanel();
    private JPanel buttonCancelPanel = new JPanel();
    private RSTableModel rsTable;
    private boolean nextFlag = false;
    private Connection connection;

    public ResultSetTable(Connection conn, Database db, String query) {
        this.connection = conn;
        this.rsTable = new RSTableModel(db);
        Counter.incCounter();
        this.mainPanel = new JPanel();
        this.queryTextArea = new JTextArea(query, 1, 49);
        this.selectButton = new JButton("Select");
        this.selectButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ResultSetTable.this.rsTable.fetchRecords();
                ResultSetTable.this.nextButton.setEnabled(ResultSetTable.this.nextFlag);
            }
        });
        this.clearButton = new JButton("Clear");
        this.clearButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ResultSetTable.this.queryTextArea.setText("");
            }
        });
        this.nextButton = new JButton("Next");
        this.nextButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ResultSetTable.this.rsTable.nextRecords();
                ResultSetTable.this.nextButton.setEnabled(ResultSetTable.this.nextFlag);
            }
        });
        this.nextButton.setEnabled(false);
        this.closeButton = new JButton("Close");
        this.closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ResultSetTable.this.rsTable.close();
                ResultSetTable.this.frame.setVisible(false);
                ResultSetTable.this.frame.dispose();
                ResultSetTable.this.frame = null;
            }
        });
        this.mainPanel.setLayout(new BoxLayout(this.mainPanel, 1));
        this.buttonSelectPanel.add(this.selectButton);
        this.buttonSelectPanel.add(this.clearButton);
        this.buttonCancelPanel.add(this.nextButton);
        this.buttonCancelPanel.add(this.closeButton);
        this.queryTextArea.setLineWrap(true);
        this.queryAggregate = new JScrollPane(this.queryTextArea);
        this.textAreaPanel.add(this.queryAggregate);
        this.textAreaPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        this.textAreaPanel.setBorder(BorderFactory.createEmptyBorder(15, 10, -4, 10));
        this.mainPanel.add(this.textAreaPanel);
        this.mainPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        this.mainPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 5, 10));
        this.mainPanel.setAlignmentX(0.5f);
        this.mainPanel.add(this.buttonSelectPanel);
        this.buttonSelectPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        this.buttonSelectPanel.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        this.table = new JTable(this.rsTable);
        this.table.setColumnSelectionAllowed(true);
        this.table.setAutoResizeMode(0);
        JScrollPane scrollpane = new JScrollPane(this.table);
        this.mainPanel.add(scrollpane);
        this.mainPanel.add(this.buttonCancelPanel);
        JFrame.setDefaultLookAndFeelDecorated(true);
        this.frame.getContentPane().add(this.mainPanel);
        Toolkit tkit = Toolkit.getDefaultToolkit();
        Dimension dim = tkit.getScreenSize();
        int wd = (int)dim.getWidth();
        int ht = (int)dim.getHeight();
        this.frame.setSize(wd - 550, ht - 250);
        this.frame.setLocation(150, 60);
        URL imgURL = ResultSetTable.class.getResource("Images/Explorer.gif");
        if (imgURL != null) {
            this.frame.setIconImage(new ImageIcon(imgURL).getImage());
        }
        this.frame.setTitle("Browse Instances");
        this.frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent we) {
                ResultSetTable.this.rsTable.close();
            }
        });
        this.frame.setVisible(true);
        this.frame.setResizable(false);
    }

    private class RSTableModel
    extends AbstractTableModel {
        private String[] columnNames;
        private Database dbase;
        private Vector data;
        private Factory factory;
        private QueryTransaction qTrans;

        public RSTableModel() {
        }

        public RSTableModel(Database db) {
            this.dbase = db;
        }

        public void fetchRecords() {
            String sFactName = this.dbase.getProperty("Factory");
            this.factory = Factory.getFactory(sFactName);
            if (this.qTrans != null) {
                this.close();
            }
            this.qTrans = this.factory.getQueryTransaction();
            if (ResultSetTable.this.queryTextArea.getText().equals("")) {
                Util.showMessageDialog(null, Translator.getInstance().localize("UNABLE_TO_GET_DATABASE_STRING"), Translator.getInstance().localize("NO_SQL_STRING"), 0);
            }
            if (!ResultSetTable.this.queryTextArea.getText().equals("")) {
                try {
                    if (this.factory == null) {
                        Util.showMessageDialog(null, Translator.getInstance().localize("UNABLE_TO_LOAD_FACTORY", "Factory"), Translator.getInstance().localize("IMPORT_FAILURE_TITLE"), 0);
                    } else {
                        this.data = this.qTrans.getRows(ResultSetTable.this.connection, ResultSetTable.this.queryTextArea.getText());
                        this.columnNames = this.qTrans.getColumnNames();
                        this.fireTableChanged(null);
                    }
                }
                catch (SQLException sqle) {
                    Util.showMessageDialog(null, sqle.getMessage(), Translator.getInstance().localize("BROWSE_INSTANCES"), 0);
                }
                ResultSetTable.this.nextFlag = this.qTrans.hasRecords();
            }
        }

        public void nextRecords() {
            if (this.qTrans != null && this.qTrans.hasRecords()) {
                try {
                    this.data = this.qTrans.getNextRows();
                    this.fireTableChanged(null);
                }
                catch (SQLException sqle) {
                    Util.showMessageDialog(null, sqle.getMessage(), Translator.getInstance().localize("BROWSE_INSTANCES"), 0);
                }
                ResultSetTable.this.nextFlag = this.qTrans.hasRecords();
            }
        }

        public void close() {
            if (this.qTrans != null) {
                this.qTrans.close();
                this.qTrans = null;
            }
        }

        public String getColumnName(int i) {
            return this.columnNames[i];
        }

        public int getColumnCount() {
            return this.columnNames == null ? 0 : this.columnNames.length;
        }

        public int getRowCount() {
            return this.data == null ? 0 : this.data.size();
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            return ((String[])this.data.elementAt(rowIndex))[columnIndex];
        }
    }
}

