/*
 * Decompiled with CFR 0.152.
 */
package org.dbuml.base.model;

import java.util.List;
import java.util.Properties;
import java.util.TreeMap;
import java.util.Vector;
import org.dbuml.base.database.DBMetadata;
import org.dbuml.base.database.DBMetadataCache;
import org.dbuml.base.factory.Factory;
import org.dbuml.base.model.DBElement;

public class Database
extends DBElement {
    public static final String STEREOSTRING = "Database";
    public static final String DRIVER = "Driver";
    public static final String URL = "Url";
    public static final String USER = "User";
    public static final String PASSWORD = "Password";
    public static final String FACTORY = "Factory";
    public static final String SUPPORTS_SCHEMA = "Supports_schema";
    private boolean preferreQuotedIdentifiers = false;
    private static final String QUOTES = "\"";
    private String quoteStr = "\"";
    private static final int UNKNOWN_CASE = 0;
    private static final int LOWER_CASE = 1;
    private static final int UPPER_CASE = 2;
    private static final int MIXED_CASE = 3;
    private int storeUnquoted = 0;
    private int storequoted = 0;
    private static List propNames = new Vector();
    private Factory factory = null;

    public Database() {
        this(null);
    }

    public Database(String sName) {
        super(sName, new TreeMap(new DBElement.KeyComparator(propNames)));
        this.setProperty(DRIVER, "sun.jdbc.odbc.JdbcOdbcDriver");
        this.setProperty(URL, "jdbc:odbc:data source name");
        this.setProperty(USER, "Public");
        this.setProperty(PASSWORD, "");
        this.setProperty(FACTORY, "org.dbuml.base.factory.GenericFactory");
        this.setProperty(SUPPORTS_SCHEMA, "false");
    }

    public Database(String sName, Object objModel, Properties properties) {
        this(sName);
        this._objModel = objModel;
        this.setProperties(properties);
        DBMetadata md = DBMetadataCache.getDBMetadata(this);
        if (md != null) {
            md.initDatabase(this);
        }
    }

    public String getStereostring() {
        return STEREOSTRING;
    }

    public boolean isConnected() {
        return DBMetadataCache.getDBMetadata(this) != null;
    }

    public String getDefaultSchemaName() {
        return this.getName();
    }

    public boolean isDefaultSchema(String schemaName) {
        return schemaName != null && schemaName.equals(this.getDefaultSchemaName());
    }

    protected boolean isReserved(String word) {
        String sf;
        if (this.factory == null && (sf = this.getProperty(FACTORY)) != null) {
            this.factory = Factory.getFactory(sf);
        }
        return this.factory != null && this.factory.getDBReservedWords().isReserved(word);
    }

    public void quoteIdentifiers(boolean preferred) {
        this.preferreQuotedIdentifiers = preferred;
    }

    public boolean preferresQuotes() {
        return this.preferreQuotedIdentifiers;
    }

    public String fixName(String identifier) {
        return this.fixName(identifier, false);
    }

    public String fixName(String str, boolean importing) {
        String retStr = str;
        if (!this.isQuoted(str)) {
            if (importing) {
                if (this.needsQuotes(str) || Database.includesSpace(str) || this.isReserved(str)) {
                    retStr = this.quoteStr + str + this.quoteStr;
                }
            } else if (this.preferresQuotes() || Database.includesSpace(str) || this.isReserved(str)) {
                retStr = this.quoteStr + str + this.quoteStr;
            }
        }
        return retStr;
    }

    public String removeQuote(String str) {
        String retVal = str;
        if (this.isQuoted(str)) {
            retVal = str.substring(1, str.length() - 1);
        }
        return retVal;
    }

    public void setIdentifierQuoteString(String quote) {
        this.quoteStr = quote;
    }

    private static boolean includesSpace(String str) {
        String str2;
        boolean retVal = false;
        if (str != null && (str2 = str.trim()) != null && str2.length() > 0) {
            retVal = str2.indexOf(32) > 0;
        }
        return retVal;
    }

    private boolean isQuoted(String str) {
        return str != null && str.startsWith(this.quoteStr) && str.endsWith(this.quoteStr);
    }

    private boolean needsQuotes(String str) {
        boolean retVal = false;
        if (str != null) {
            if (this.storeUnquoted == 0 || this.storequoted == 0 || this.storeUnquoted == this.storequoted) {
                retVal = false;
            }
            if (!retVal) {
                char[] chars = str.toCharArray();
                if (this.storeUnquoted == 1) {
                    retVal = Database.isUpperCase(chars) || Database.isMixedCase(chars);
                } else if (this.storeUnquoted == 2) {
                    retVal = Database.isLowerCase(chars) || Database.isMixedCase(chars);
                } else if (this.storeUnquoted == 3) {
                    retVal = Database.isLowerCase(chars) || Database.isUpperCase(chars);
                }
            }
        }
        return retVal;
    }

    public void likesLowerCaseIdentifier(boolean yes) {
        if (yes) {
            this.storeUnquoted = 1;
        }
    }

    public void likesLowerCaseQuotedIdentifier(boolean yes) {
        if (yes) {
            this.storequoted = 1;
        }
    }

    public void likesUpperCaseIdentifier(boolean yes) {
        if (yes) {
            this.storeUnquoted = 2;
        }
    }

    public void likesUpperCaseQuotedIdentifier(boolean yes) {
        if (yes) {
            this.storequoted = 2;
        }
    }

    public void likesMixedCaseIdentifier(boolean yes) {
        if (yes) {
            this.storeUnquoted = 3;
        }
    }

    public void likesMixedCaseQuotedIdentifier(boolean yes) {
        if (yes) {
            this.storequoted = 3;
        }
    }

    private static boolean isUpperCase(char[] chars) {
        boolean retVal = true;
        for (int i = 0; i < chars.length; ++i) {
            if (!Character.isLetter(chars[i]) || Character.isUpperCase(chars[i])) continue;
            retVal = false;
            break;
        }
        return retVal;
    }

    private static boolean isLowerCase(char[] chars) {
        boolean retVal = true;
        for (int i = 0; i < chars.length; ++i) {
            if (!Character.isLetter(chars[i]) || Character.isLowerCase(chars[i])) continue;
            retVal = false;
        }
        return retVal;
    }

    private static boolean isMixedCase(char[] chars) {
        return !Database.isLowerCase(chars) && !Database.isUpperCase(chars);
    }

    public String getDefaultTypesPkgName() {
        String url = this.getProperty(URL);
        String pkg = "";
        if (url != null && url.trim() != null) {
            int jdbcOdbc = (url = url.replaceAll(":", ".")).indexOf("jdbc.odbc");
            if (jdbcOdbc == -1) {
                if (url.indexOf("jdbc") >= 0) {
                    int secondDot = url.indexOf(46, 5);
                    pkg = url.substring(0, secondDot);
                } else {
                    int lastDot = url.lastIndexOf(46);
                    if (lastDot > -1) {
                        pkg = url.substring(0, lastDot);
                    }
                }
            } else {
                pkg = url;
            }
        }
        return "types." + pkg;
    }

    static {
        propNames.add(DRIVER);
        propNames.add(URL);
        propNames.add(USER);
        propNames.add(PASSWORD);
        propNames.add(FACTORY);
        propNames.add(SUPPORTS_SCHEMA);
    }
}

