/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.app.gui.basics.format;

import com.jgoodies.app.gui.basics.format.AppFormats;
import com.jgoodies.common.base.Strings;
import com.jgoodies.common.internal.DateUtils;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;
import java.time.LocalDate;
import java.util.Date;

public final class MonthFormat
extends Format {
    @Override
    public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
        if (obj == null) {
            return toAppendTo;
        }
        if (!(obj instanceof LocalDate)) {
            throw new ClassCastException("The object to format must be a LocalDate.");
        }
        toAppendTo.append(AppFormats.formatMonth((LocalDate)obj));
        return toAppendTo;
    }

    @Override
    public Object parseObject(String source, ParsePosition pos) {
        if (Strings.isNumeric(source)) {
            return MonthFormat.parseMonth(source, pos);
        }
        String sourceWithDay = "1." + source.replace('/', '.');
        ParsePosition newPos = new ParsePosition(0);
        Date date = DateFormat.getDateInstance().parse(sourceWithDay, newPos);
        pos.setIndex(source.length());
        return date == null ? null : DateUtils.toLocalDate(date);
    }

    private static LocalDate parseMonth(String source, ParsePosition pos) {
        try {
            int month = Integer.parseInt(source);
            if (month < 1 || month > 12) {
                return null;
            }
            pos.setIndex(source.length());
            return LocalDate.now().withMonth(month).withDayOfMonth(1);
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }
}

