/*
 * Decompiled with CFR 0.152.
 */
package net.charabia.jsmoothgen.application.gui.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.Vector;

public class CommandRunner {
    private static Vector s_runningprocs = new Vector();

    public static void run(String[] cmd, File curdir) throws Exception {
        Process proc = Runtime.getRuntime().exec(cmd, null, curdir);
        InputStream stdin = proc.getInputStream();
        InputStream stderr = proc.getErrorStream();
        new Thread(new CmdStdReader(stdin)).start();
        new Thread(new CmdStdReader(stderr)).start();
        s_runningprocs.add(proc);
    }

    static {
        ProcessCleaner t = new ProcessCleaner();
        t.setDaemon(true);
        Runtime.getRuntime().addShutdownHook(t);
    }

    public static class ProcessCleaner
    extends Thread {
        public void run() {
            Enumeration e = s_runningprocs.elements();
            while (e.hasMoreElements()) {
                Process p = (Process)e.nextElement();
                try {
                    int res = p.exitValue();
                }
                catch (Exception ex) {
                    p.destroy();
                }
            }
        }
    }

    public static class CmdStdReader
    implements Runnable {
        InputStream m_in;

        public CmdStdReader(InputStream in) {
            this.m_in = in;
        }

        public void run() {
            try {
                BufferedReader br = new BufferedReader(new InputStreamReader(this.m_in));
                String line = null;
                while ((line = br.readLine()) != null) {
                    System.out.println(line);
                }
            }
            catch (Exception exc) {
                exc.printStackTrace();
            }
        }
    }
}

