/*
 * Decompiled with CFR 0.152.
 */
package plugin.qualifier.skill;

import java.util.Collection;
import java.util.logging.Level;
import pcgen.cdom.base.Converter;
import pcgen.cdom.base.PrimitiveCollection;
import pcgen.cdom.base.PrimitiveFilter;
import pcgen.cdom.converter.AddFilterConverter;
import pcgen.cdom.enumeration.GroupingState;
import pcgen.cdom.reference.SelectionCreator;
import pcgen.core.PlayerCharacter;
import pcgen.core.Skill;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.QualifierToken;
import pcgen.util.Logging;

public class NoRankToken
implements QualifierToken<Skill>,
PrimitiveFilter<Skill> {
    private PrimitiveCollection<Skill> pcs = null;
    private boolean wasRestricted = false;

    public String getTokenName() {
        return "NORANK";
    }

    public Class<Skill> getReferenceClass() {
        return Skill.class;
    }

    public String getLSTformat(boolean useAny) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getTokenName());
        if (this.wasRestricted) {
            sb.append('[').append(this.pcs.getLSTformat(useAny)).append(']');
        }
        return sb.toString();
    }

    public boolean initialize(LoadContext context, SelectionCreator<Skill> sc, String condition, String value, boolean negate) {
        if (condition != null) {
            Logging.addParseMessage((Level)Level.SEVERE, (String)("Cannot make " + this.getTokenName() + " into a conditional Qualifier, remove ="));
            return false;
        }
        if (negate) {
            Logging.addParseMessage((Level)Level.SEVERE, (String)("Cannot make " + this.getTokenName() + " into a negated Qualifier, remove !"));
            return false;
        }
        if (value == null) {
            this.pcs = sc.getAllReference();
        } else {
            this.pcs = context.getPrimitiveChoiceFilter(sc, value);
            this.wasRestricted = true;
        }
        return this.pcs != null;
    }

    public GroupingState getGroupingState() {
        return this.pcs == null ? GroupingState.ANY : this.pcs.getGroupingState().reduce();
    }

    public int hashCode() {
        return this.pcs == null ? 0 : this.pcs.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof NoRankToken) {
            NoRankToken other = (NoRankToken)o;
            if (this.pcs == null) {
                return other.pcs == null;
            }
            return this.pcs.equals(other.pcs);
        }
        return false;
    }

    public <R> Collection<? extends R> getCollection(PlayerCharacter pc, Converter<Skill, R> c) {
        return this.pcs.getCollection(pc, (Converter)new AddFilterConverter(c, (PrimitiveFilter)this));
    }

    public boolean allow(PlayerCharacter pc, Skill sk) {
        return pc.getDisplay().getRank(sk).floatValue() == 0.0f;
    }
}

