/*
 * Decompiled with CFR 0.152.
 */
package pcgen.io.exporttoken;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.StringTokenizer;
import pcgen.core.Globals;
import pcgen.core.PlayerCharacter;
import pcgen.core.character.Follower;
import pcgen.core.display.CharacterDisplay;
import pcgen.io.ExportHandler;
import pcgen.io.exporttoken.Token;
import pcgen.util.Logging;

public class FollowerToken
extends Token {
    public static final String TOKENNAME = "FOLLOWER";

    @Override
    public String getTokenName() {
        return TOKENNAME;
    }

    @Override
    public String getToken(String tokenSource, PlayerCharacter pc, ExportHandler eh) {
        int i;
        StringTokenizer aTok = new StringTokenizer(tokenSource, ".");
        String fString = aTok.nextToken();
        if (TOKENNAME.equals(fString)) {
            i = Integer.parseInt(aTok.nextToken());
        } else {
            Logging.errorPrint("Old syntax FOLLOWERx will be replaced for FOLLOWER.x");
            i = Integer.parseInt(tokenSource.substring(8, tokenSource.indexOf(46)));
        }
        StringBuilder restString = new StringBuilder();
        while (aTok.hasMoreTokens()) {
            restString.append(".").append(aTok.nextToken());
        }
        if (restString.indexOf(".") == 0) {
            restString = restString.deleteCharAt(0);
        }
        String result = "";
        ArrayList<Follower> followers = new ArrayList<Follower>(pc.getDisplay().getFollowerList());
        if (i < followers.size()) {
            result = FollowerToken.getFollowerOutput(eh, restString.toString(), (Follower)followers.get(i));
        }
        return result;
    }

    public static String getFollowerOutput(ExportHandler eh, String followerToken, Follower follower) {
        StringWriter writer = new StringWriter();
        BufferedWriter bw = new BufferedWriter(writer);
        String token = "".equals(followerToken) ? "NAME" : followerToken;
        for (PlayerCharacter eachPC : Globals.getPCList()) {
            CharacterDisplay eachDisplay = eachPC.getDisplay();
            if (!follower.getFileName().equals(eachDisplay.getFileName()) || !follower.getName().equals(eachDisplay.getName())) continue;
            PlayerCharacter newPC = eachPC;
            eh.replaceToken(token, bw, newPC);
        }
        try {
            bw.flush();
        }
        catch (IOException e) {
            Logging.errorPrint("Ignoring error while processing FOLLOWER or FOLLOWERTYPE token", e);
        }
        return writer.toString();
    }
}

