/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens;

import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;
import pcgen.base.formula.Formula;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.FormulaFactory;
import pcgen.cdom.base.Ungranted;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.helper.StatLock;
import pcgen.cdom.reference.CDOMSingleRef;
import pcgen.core.PCStat;
import pcgen.core.utils.ParsingSeparator;
import pcgen.rules.context.Changes;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.ParseResult;

public class DefineStatLst
implements CDOMPrimaryToken<CDOMObject> {
    private static final Class<PCStat> PCSTAT_CLASS = PCStat.class;

    @Override
    public String getTokenName() {
        return "DEFINESTAT";
    }

    @Override
    public ParseResult parseToken(LoadContext context, CDOMObject obj, String value) {
        DefineStatSubToken subToken;
        if (obj instanceof Ungranted) {
            return new ParseResult.Fail("Cannot use " + this.getTokenName() + " on an Ungranted object type: " + obj.getClass().getSimpleName(), context);
        }
        ParsingSeparator sep = new ParsingSeparator(value, '|');
        if (!sep.hasNext()) {
            return new ParseResult.Fail(this.getTokenName() + " may not be empty", context);
        }
        String firstItem = sep.next();
        try {
            subToken = DefineStatSubToken.valueOf(firstItem);
        }
        catch (IllegalArgumentException e1) {
            return new ParseResult.Fail("Found unexpected sub tag " + firstItem + " in " + this.getTokenName() + ":" + value + ". Must be one of " + StringUtils.join((Object[])DefineStatSubToken.values(), ", ") + ".", context);
        }
        if (!sep.hasNext()) {
            return new ParseResult.Fail(this.getTokenName() + ":" + (Object)((Object)subToken) + "| must be followed by a stat.", context);
        }
        String statKey = sep.next();
        CDOMSingleRef<PCStat> stat = context.getReferenceContext().getCDOMReference(PCSTAT_CLASS, statKey);
        Formula f = null;
        if (subToken == DefineStatSubToken.LOCK || subToken == DefineStatSubToken.MINVALUE || subToken == DefineStatSubToken.MAXVALUE) {
            if (!sep.hasNext()) {
                return new ParseResult.Fail(this.getTokenName() + ":" + (Object)((Object)subToken) + "| must be followed by both a stat and a value.", context);
            }
            String formula = sep.next();
            f = FormulaFactory.getFormulaFor(formula);
            if (!f.isValid()) {
                return new ParseResult.Fail("Formula in " + this.getTokenName() + " was not valid: " + f.toString(), context);
            }
        }
        if (sep.hasNext()) {
            return new ParseResult.Fail(this.getTokenName() + ":" + value + " has too many pipe separated item.", context);
        }
        switch (subToken) {
            case LOCK: {
                context.getObjectContext().addToList(obj, ListKey.STAT_LOCKS, new StatLock(stat, f));
                break;
            }
            case UNLOCK: {
                context.getObjectContext().addToList(obj, ListKey.UNLOCKED_STATS, stat);
                break;
            }
            case NONSTAT: {
                context.getObjectContext().addToList(obj, ListKey.NONSTAT_STATS, stat);
                break;
            }
            case STAT: {
                context.getObjectContext().addToList(obj, ListKey.NONSTAT_TO_STAT_STATS, stat);
                break;
            }
            case MINVALUE: {
                context.getObjectContext().addToList(obj, ListKey.STAT_MINVALUE, new StatLock(stat, f));
                break;
            }
            case MAXVALUE: {
                context.getObjectContext().addToList(obj, ListKey.STAT_MAXVALUE, new StatLock(stat, f));
            }
        }
        return ParseResult.SUCCESS;
    }

    @Override
    public String[] unparse(LoadContext context, CDOMObject obj) {
        Changes<StatLock> lockChanges = context.getObjectContext().getListChanges(obj, ListKey.STAT_LOCKS);
        Changes<CDOMSingleRef<PCStat>> ulchanges = context.getObjectContext().getListChanges(obj, ListKey.UNLOCKED_STATS);
        Changes<CDOMSingleRef<PCStat>> nonStatChanges = context.getObjectContext().getListChanges(obj, ListKey.NONSTAT_STATS);
        Changes<CDOMSingleRef<PCStat>> nonStatToStatChanges = context.getObjectContext().getListChanges(obj, ListKey.NONSTAT_TO_STAT_STATS);
        Changes<StatLock> minValueChanges = context.getObjectContext().getListChanges(obj, ListKey.STAT_MINVALUE);
        Changes<StatLock> maxValueChanges = context.getObjectContext().getListChanges(obj, ListKey.STAT_MAXVALUE);
        TreeSet<String> set = new TreeSet<String>();
        if (lockChanges != null && !lockChanges.isEmpty()) {
            if (lockChanges.includesGlobalClear()) {
                context.addWriteMessage("DEFINE:LOCK does not support .CLEAR");
                return null;
            }
            if (lockChanges.hasAddedItems()) {
                for (StatLock statLock : lockChanges.getAdded()) {
                    set.add("LOCK|" + statLock.getLSTformat() + "|" + statLock.getLockValue());
                }
            }
        }
        if (ulchanges != null && !ulchanges.isEmpty()) {
            if (ulchanges.includesGlobalClear()) {
                context.addWriteMessage("DEFINE:UNLOCK does not support .CLEAR");
                return null;
            }
            if (ulchanges.hasAddedItems()) {
                for (CDOMSingleRef cDOMSingleRef : ulchanges.getAdded()) {
                    set.add("UNLOCK|" + cDOMSingleRef.getLSTformat(false));
                }
            }
        }
        if (nonStatChanges != null && !nonStatChanges.isEmpty() && nonStatChanges.hasAddedItems()) {
            for (CDOMSingleRef cDOMSingleRef : nonStatChanges.getAdded()) {
                set.add("NONSTAT|" + cDOMSingleRef.getLSTformat(false));
            }
        }
        if (nonStatToStatChanges != null && !nonStatToStatChanges.isEmpty() && nonStatToStatChanges.hasAddedItems()) {
            for (CDOMSingleRef cDOMSingleRef : nonStatToStatChanges.getAdded()) {
                set.add("STAT|" + cDOMSingleRef.getLSTformat(false));
            }
        }
        if (minValueChanges != null && !minValueChanges.isEmpty() && minValueChanges.hasAddedItems()) {
            for (StatLock statLock : minValueChanges.getAdded()) {
                set.add("MINVALUE|" + statLock.getLSTformat() + "|" + statLock.getLockValue());
            }
        }
        if (maxValueChanges != null && !maxValueChanges.isEmpty() && maxValueChanges.hasAddedItems()) {
            for (StatLock statLock : maxValueChanges.getAdded()) {
                set.add("MAXVALUE|" + statLock.getLSTformat() + "|" + statLock.getLockValue());
            }
        }
        if (set.isEmpty()) {
            return null;
        }
        return set.toArray(new String[set.size()]);
    }

    @Override
    public Class<CDOMObject> getTokenClass() {
        return CDOMObject.class;
    }

    public static enum DefineStatSubToken {
        LOCK,
        UNLOCK,
        NONSTAT,
        STAT,
        MINVALUE,
        MAXVALUE;

    }
}

