/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.provider;

import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.Task;
import org.gradle.api.internal.provider.ProviderInternal;
import org.gradle.api.internal.provider.ValueSupplier;

class OrElseValueProducer
implements ValueSupplier.ValueProducer {
    private final ProviderInternal<?> left;
    @Nullable
    private final ProviderInternal<?> right;
    private final ValueSupplier.ValueProducer leftProducer;
    private final ValueSupplier.ValueProducer rightProducer;

    public OrElseValueProducer(ProviderInternal<?> left, @Nullable ProviderInternal<?> right, ValueSupplier.ValueProducer rightProducer) {
        this.left = left;
        this.right = right;
        this.leftProducer = left.getProducer();
        this.rightProducer = rightProducer;
    }

    @Override
    public boolean isKnown() {
        return this.leftProducer.isKnown() || this.rightProducer.isKnown();
    }

    @Override
    public boolean isProducesDifferentValueOverTime() {
        return this.leftProducer.isProducesDifferentValueOverTime() || this.rightProducer.isProducesDifferentValueOverTime();
    }

    @Override
    public void visitProducerTasks(Action<? super Task> visitor) {
        if (!this.isMissing(this.left)) {
            if (this.leftProducer.isKnown()) {
                this.leftProducer.visitProducerTasks(visitor);
            }
            return;
        }
        if (this.right != null && this.rightProducer.isKnown() && !this.isMissing(this.right)) {
            this.rightProducer.visitProducerTasks(visitor);
        }
    }

    private boolean isMissing(ProviderInternal<?> provider) {
        return provider.calculateExecutionTimeValue().isMissing();
    }
}

