/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.failure.mappers;

import java.util.Collections;
import java.util.List;
import org.gradle.api.internal.tasks.testing.failure.TestFailureMapper;
import org.gradle.api.internal.tasks.testing.failure.ThrowableToTestFailureMapper;
import org.gradle.api.tasks.testing.TestFailure;

public class OpenTestAssertionFailedMapper
extends TestFailureMapper {
    @Override
    protected List<String> getSupportedClassNames() {
        return Collections.singletonList("org.opentest4j.AssertionFailedError");
    }

    @Override
    public TestFailure map(Throwable throwable, ThrowableToTestFailureMapper rootMapper) throws Exception {
        Object expectedValueWrapper = OpenTestAssertionFailedMapper.invokeMethod(throwable, "getExpected", Object.class);
        Object expectedValue = OpenTestAssertionFailedMapper.invokeMethod(expectedValueWrapper, "getValue", Object.class);
        Object actualValueWrapper = OpenTestAssertionFailedMapper.invokeMethod(throwable, "getActual", Object.class);
        Object actualValue = OpenTestAssertionFailedMapper.invokeMethod(actualValueWrapper, "getValue", Object.class);
        if (expectedValue.getClass().getName().equals("org.opentest4j.FileInfo") && actualValue.getClass().getName().equals("org.opentest4j.FileInfo")) {
            return OpenTestAssertionFailedMapper.mapFileInfoComparisonFailure(throwable, expectedValue, actualValue);
        }
        return OpenTestAssertionFailedMapper.mapStringBasedComparisonFailure(throwable, expectedValueWrapper, actualValueWrapper);
    }

    private static TestFailure mapFileInfoComparisonFailure(Throwable throwable, Object expected, Object actual) throws Exception {
        String expectedPath = OpenTestAssertionFailedMapper.invokeMethod(expected, "getPath", String.class);
        byte[] expectedContent = OpenTestAssertionFailedMapper.invokeMethod(expected, "getContents", byte[].class);
        String actualPath = OpenTestAssertionFailedMapper.invokeMethod(actual, "getPath", String.class);
        byte[] actualContent = OpenTestAssertionFailedMapper.invokeMethod(actual, "getContents", byte[].class);
        return TestFailure.fromFileComparisonFailure((Throwable)throwable, (String)expectedPath, (String)actualPath, (byte[])expectedContent, (byte[])actualContent, null);
    }

    private static TestFailure mapStringBasedComparisonFailure(Throwable throwable, Object expectedWrapper, Object actualWrapper) throws Exception {
        String expectedValue = OpenTestAssertionFailedMapper.invokeMethod(expectedWrapper, "getStringRepresentation", String.class);
        String actualValue = OpenTestAssertionFailedMapper.invokeMethod(actualWrapper, "getStringRepresentation", String.class);
        return TestFailure.fromTestAssertionFailure((Throwable)throwable, (String)expectedValue, (String)actualValue, null);
    }
}

