/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugin.devel.tasks.internal;

import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import com.google.gson.Gson;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.annotation.Annotation;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import org.gradle.api.Task;
import org.gradle.api.artifacts.transform.CacheableTransform;
import org.gradle.api.artifacts.transform.TransformAction;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.EmptyFileVisitor;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.problems.DocLink;
import org.gradle.api.problems.Problem;
import org.gradle.api.problems.ProblemBuilder;
import org.gradle.api.problems.Problems;
import org.gradle.api.problems.Severity;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.UntrackedTask;
import org.gradle.internal.deprecation.Documentation;
import org.gradle.internal.reflect.DefaultTypeValidationContext;
import org.gradle.internal.reflect.problems.ValidationProblemId;
import org.gradle.internal.reflect.validation.TypeValidationContext;
import org.gradle.plugin.devel.tasks.internal.PropertyValidationAccess;
import org.gradle.plugin.devel.tasks.internal.ValidationProblemSerialization;
import org.gradle.work.DisableCachingByDefault;
import org.gradle.workers.WorkAction;
import org.gradle.workers.WorkParameters;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;

public abstract class ValidateAction
implements WorkAction<Params> {
    private static final Logger LOGGER = Logging.getLogger(ValidateAction.class);
    public static final String PROBLEM_SEPARATOR = "--------";

    public void execute() {
        final ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        final ArrayList<Problem> taskValidationProblems = new ArrayList<Problem>();
        final Params params = (Params)this.getParameters();
        params.getClasses().getAsFileTree().visit((FileVisitor)new EmptyFileVisitor(){

            public void visitFile(FileVisitDetails fileDetails) {
                if (!fileDetails.getPath().endsWith(".class")) {
                    return;
                }
                List<String> classNames = this.getClassNames(fileDetails);
                for (String className : classNames) {
                    Class<?> clazz;
                    try {
                        clazz = classLoader.loadClass(className);
                    }
                    catch (ClassNotFoundException | IncompatibleClassChangeError | NoClassDefFoundError | VerifyError e) {
                        LOGGER.debug("Could not load class: " + className, e);
                        continue;
                    }
                    ValidateAction.collectValidationProblems(null, clazz, taskValidationProblems, (Boolean)params.getEnableStricterValidation().get());
                }
            }

            @Nonnull
            private List<String> getClassNames(FileVisitDetails fileDetails) {
                ClassReader reader = this.createClassReader(fileDetails);
                ArrayList classNames = Lists.newArrayList();
                reader.accept((ClassVisitor)new TaskNameCollectorVisitor(classNames), 1);
                return classNames;
            }

            @Nonnull
            private ClassReader createClassReader(FileVisitDetails fileDetails) {
                try {
                    return new ClassReader(Files.asByteSource((File)fileDetails.getFile()).read());
                }
                catch (IOException e) {
                    throw new org.gradle.api.UncheckedIOException((Throwable)e);
                }
            }
        });
        ValidateAction.storeResults(taskValidationProblems, params.getOutputFile());
    }

    private static void collectValidationProblems(Problems problemService, Class<?> topLevelBean, List<Problem> problems, boolean enableStricterValidation) {
        DefaultTypeValidationContext validationContext = ValidateAction.createTypeValidationContext(problemService, topLevelBean, enableStricterValidation);
        PropertyValidationAccess.collectValidationProblems(topLevelBean, (TypeValidationContext)validationContext);
        problems.addAll((Collection<Problem>)validationContext.getProblems());
    }

    @Nonnull
    private static DefaultTypeValidationContext createTypeValidationContext(Problems problemService, Class<?> topLevelBean, boolean enableStricterValidation) {
        if (Task.class.isAssignableFrom(topLevelBean)) {
            return ValidateAction.createValidationContextAndValidateCacheableAnnotations(problemService, topLevelBean, CacheableTask.class, enableStricterValidation);
        }
        if (TransformAction.class.isAssignableFrom(topLevelBean)) {
            return ValidateAction.createValidationContextAndValidateCacheableAnnotations(problemService, topLevelBean, CacheableTransform.class, enableStricterValidation);
        }
        return ValidateAction.createValidationContext(topLevelBean, enableStricterValidation);
    }

    private static DefaultTypeValidationContext createValidationContextAndValidateCacheableAnnotations(Problems problems, Class<?> topLevelBean, Class<? extends Annotation> cacheableAnnotationClass, boolean enableStricterValidation) {
        boolean cacheable = topLevelBean.isAnnotationPresent(cacheableAnnotationClass);
        DefaultTypeValidationContext validationContext = ValidateAction.createValidationContext(topLevelBean, cacheable || enableStricterValidation);
        if (enableStricterValidation) {
            ValidateAction.validateCacheabilityAnnotationPresent(topLevelBean, cacheable, cacheableAnnotationClass, validationContext);
        }
        return validationContext;
    }

    private static DefaultTypeValidationContext createValidationContext(Class<?> topLevelBean, boolean reportCacheabilityProblems) {
        return DefaultTypeValidationContext.withRootType(topLevelBean, (boolean)reportCacheabilityProblems);
    }

    private static void validateCacheabilityAnnotationPresent(Class<?> topLevelBean, boolean cacheable, Class<? extends Annotation> cacheableAnnotationClass, DefaultTypeValidationContext validationContext) {
        if (topLevelBean.isInterface()) {
            return;
        }
        if (!cacheable && topLevelBean.getAnnotation(DisableCachingByDefault.class) == null && topLevelBean.getAnnotation(UntrackedTask.class) == null) {
            boolean isTask = Task.class.isAssignableFrom(topLevelBean);
            String cacheableAnnotation = "@" + cacheableAnnotationClass.getSimpleName();
            String disableCachingAnnotation = "@" + DisableCachingByDefault.class.getSimpleName();
            String untrackedTaskAnnotation = "@" + UntrackedTask.class.getSimpleName();
            String workType = isTask ? "task" : "transform action";
            validationContext.visitTypeProblem(problem -> {
                ProblemBuilder builder = problem.withAnnotationType(topLevelBean).label("must be annotated either with " + cacheableAnnotation + " or with " + disableCachingAnnotation, new Object[0]).documentedAt((DocLink)Documentation.userManual((String)"validation_problems", (String)"disable_caching_by_default")).noLocation().type(ValidationProblemId.NOT_CACHEABLE_WITHOUT_REASON.name()).group("type_validation").severity(Severity.WARNING).details("The " + workType + " author should make clear why a " + workType + " is not cacheable").solution("Add " + disableCachingAnnotation + "(because = ...)").solution("Add " + cacheableAnnotation);
                if (isTask) {
                    builder.solution("Add " + untrackedTaskAnnotation + "(because = ...)");
                }
            });
        }
    }

    private static void storeResults(List<Problem> problemMessages, RegularFileProperty outputFile) {
        if (outputFile.isPresent()) {
            File output = ((RegularFile)outputFile.get()).getAsFile();
            try {
                output.createNewFile();
                Gson gson = ValidationProblemSerialization.createGsonBuilder().create();
                Files.asCharSink((File)output, (Charset)Charsets.UTF_8, (FileWriteMode[])new FileWriteMode[0]).write((CharSequence)gson.toJson(problemMessages));
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
        }
    }

    private static class TaskNameCollectorVisitor
    extends ClassVisitor {
        private final Collection<String> classNames;

        public TaskNameCollectorVisitor(Collection<String> classNames) {
            super(589824);
            this.classNames = classNames;
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            if ((access & 1) != 0) {
                this.classNames.add(name.replace('/', '.'));
            }
        }
    }

    public static interface Params
    extends WorkParameters {
        public ConfigurableFileCollection getClasses();

        public RegularFileProperty getOutputFile();

        public Property<Boolean> getEnableStricterValidation();
    }
}

