/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.RefDatabase;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.transport.PushCertificate;
import org.eclipse.jgit.transport.ReceiveCommand;

public class BatchRefUpdate {
    private final RefDatabase refdb;
    private final List<ReceiveCommand> commands;
    private boolean allowNonFastForwards;
    private PersonIdent refLogIdent;
    private String refLogMessage;
    private boolean refLogIncludeResult;
    private PushCertificate pushCert;
    private boolean atomic;

    protected BatchRefUpdate(RefDatabase refdb) {
        this.refdb = refdb;
        this.commands = new ArrayList<ReceiveCommand>();
        this.atomic = refdb.performsAtomicTransactions();
    }

    public boolean isAllowNonFastForwards() {
        return this.allowNonFastForwards;
    }

    public BatchRefUpdate setAllowNonFastForwards(boolean allow) {
        this.allowNonFastForwards = allow;
        return this;
    }

    public PersonIdent getRefLogIdent() {
        return this.refLogIdent;
    }

    public BatchRefUpdate setRefLogIdent(PersonIdent pi) {
        this.refLogIdent = pi;
        return this;
    }

    public String getRefLogMessage() {
        return this.refLogMessage;
    }

    public boolean isRefLogIncludingResult() {
        return this.refLogIncludeResult;
    }

    public BatchRefUpdate setRefLogMessage(String msg, boolean appendStatus) {
        if (msg == null && !appendStatus) {
            this.disableRefLog();
        } else if (msg == null && appendStatus) {
            this.refLogMessage = "";
            this.refLogIncludeResult = true;
        } else {
            this.refLogMessage = msg;
            this.refLogIncludeResult = appendStatus;
        }
        return this;
    }

    public BatchRefUpdate disableRefLog() {
        this.refLogMessage = null;
        this.refLogIncludeResult = false;
        return this;
    }

    public boolean isRefLogDisabled() {
        return this.refLogMessage == null;
    }

    public BatchRefUpdate setAtomic(boolean atomic) {
        this.atomic = atomic;
        return this;
    }

    public boolean isAtomic() {
        return this.atomic;
    }

    public void setPushCertificate(PushCertificate cert) {
        this.pushCert = cert;
    }

    protected PushCertificate getPushCertificate() {
        return this.pushCert;
    }

    public List<ReceiveCommand> getCommands() {
        return Collections.unmodifiableList(this.commands);
    }

    public BatchRefUpdate addCommand(ReceiveCommand cmd) {
        this.commands.add(cmd);
        return this;
    }

    public BatchRefUpdate addCommand(ReceiveCommand ... cmd) {
        return this.addCommand(Arrays.asList(cmd));
    }

    public BatchRefUpdate addCommand(Collection<ReceiveCommand> cmd) {
        this.commands.addAll(cmd);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void execute(RevWalk walk, ProgressMonitor monitor) throws IOException {
        if (this.atomic && !this.refdb.performsAtomicTransactions()) {
            for (ReceiveCommand c : this.commands) {
                if (c.getResult() != ReceiveCommand.Result.NOT_ATTEMPTED) continue;
                c.setResult(ReceiveCommand.Result.REJECTED_OTHER_REASON, JGitText.get().atomicRefUpdatesNotSupported);
            }
            return;
        }
        monitor.beginTask(JGitText.get().updatingReferences, this.commands.size());
        commands2 = new ArrayList<ReceiveCommand>(this.commands.size());
        namesToCheck = new ArrayList<String>(this.commands.size());
        for (ReceiveCommand cmd : this.commands) {
            try {
                if (cmd.getResult() != ReceiveCommand.Result.NOT_ATTEMPTED) continue;
                cmd.updateType(walk);
                switch (1.$SwitchMap$org$eclipse$jgit$transport$ReceiveCommand$Type[cmd.getType().ordinal()]) {
                    case 1: {
                        namesToCheck.add(cmd.getRefName());
                        commands2.add(cmd);
                        break;
                    }
                    case 2: 
                    case 3: {
                        commands2.add(cmd);
                        break;
                    }
                    case 4: {
                        rud = this.newUpdate(cmd);
                        monitor.update(1);
                        cmd.setResult(rud.delete(walk));
                    }
                }
            }
            catch (IOException err) {
                cmd.setResult(ReceiveCommand.Result.REJECTED_OTHER_REASON, MessageFormat.format(JGitText.get().lockError, new Object[]{err.getMessage()}));
            }
        }
        if (!commands2.isEmpty()) {
            takenNames = new HashSet<String>(this.refdb.getRefs("").keySet());
            takenPrefixes = BatchRefUpdate.getTakenPrefixes(takenNames);
lbl36:
            // 10 sources

            block19: for (ReceiveCommand cmd : commands2) {
                try {
                    if (cmd.getResult() != ReceiveCommand.Result.NOT_ATTEMPTED) continue;
                    cmd.updateType(walk);
                    ru = this.newUpdate(cmd);
                    switch (1.$SwitchMap$org$eclipse$jgit$transport$ReceiveCommand$Type[cmd.getType().ordinal()]) {
                        case 4: {
                            ** break;
                        }
                        case 2: 
                        case 3: {
                            ruu = this.newUpdate(cmd);
                            cmd.setResult(ruu.update(walk));
                            ** break;
                        }
                        case 1: {
                            for (String prefix : BatchRefUpdate.getPrefixes(cmd.getRefName())) {
                                if (!takenNames.contains(prefix)) continue;
                                cmd.setResult(RefUpdate.Result.LOCK_FAILURE);
                                ** break;
                            }
                            if (takenPrefixes.contains(cmd.getRefName())) {
                                cmd.setResult(RefUpdate.Result.LOCK_FAILURE);
                                ** break;
                            }
                            ru.setCheckConflicting(false);
                            BatchRefUpdate.addRefToPrefixes(takenPrefixes, cmd.getRefName());
                            takenNames.add(cmd.getRefName());
                            cmd.setResult(ru.update(walk));
                            continue block19;
                        }
                        ** default:
lbl63:
                        // 1 sources

                        continue block19;
                    }
                }
                catch (IOException err) {
                    cmd.setResult(ReceiveCommand.Result.REJECTED_OTHER_REASON, MessageFormat.format(JGitText.get().lockError, new Object[]{err.getMessage()}));
                }
                finally {
                    monitor.update(1);
                }
            }
        }
        monitor.endTask();
    }

    private static Collection<String> getTakenPrefixes(Collection<String> names) {
        HashSet<String> ref = new HashSet<String>();
        for (String name : names) {
            ref.addAll(BatchRefUpdate.getPrefixes(name));
        }
        return ref;
    }

    private static void addRefToPrefixes(Collection<String> prefixes, String name) {
        for (String prefix : BatchRefUpdate.getPrefixes(name)) {
            prefixes.add(prefix);
        }
    }

    static Collection<String> getPrefixes(String s2) {
        HashSet<String> ret = new HashSet<String>();
        int p1 = s2.indexOf(47);
        while (p1 > 0) {
            ret.add(s2.substring(0, p1));
            p1 = s2.indexOf(47, p1 + 1);
        }
        return ret;
    }

    protected RefUpdate newUpdate(ReceiveCommand cmd) throws IOException {
        RefUpdate ru = this.refdb.newUpdate(cmd.getRefName(), false);
        if (this.isRefLogDisabled()) {
            ru.disableRefLog();
        } else {
            ru.setRefLogIdent(this.refLogIdent);
            ru.setRefLogMessage(this.refLogMessage, this.refLogIncludeResult);
        }
        ru.setPushCertificate(this.pushCert);
        switch (cmd.getType()) {
            case DELETE: {
                if (!ObjectId.zeroId().equals(cmd.getOldId())) {
                    ru.setExpectedOldObjectId(cmd.getOldId());
                }
                ru.setForceUpdate(true);
                return ru;
            }
        }
        ru.setForceUpdate(this.isAllowNonFastForwards());
        ru.setExpectedOldObjectId(cmd.getOldId());
        ru.setNewObjectId(cmd.getNewId());
        return ru;
    }

    public String toString() {
        StringBuilder r = new StringBuilder();
        r.append(this.getClass().getSimpleName()).append('[');
        if (this.commands.isEmpty()) {
            return r.append(']').toString();
        }
        r.append('\n');
        for (ReceiveCommand cmd : this.commands) {
            r.append("  ");
            r.append(cmd);
            r.append("  (").append((Object)cmd.getResult()).append(")\n");
        }
        return r.append(']').toString();
    }
}

