/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.ant;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.dita.dost.log.DITAOTAntLogger;
import org.dita.dost.platform.PluginInstall;
import org.dita.dost.platform.SemVerMatch;

public final class PluginInstallTask
extends Task {
    private Path pluginFile;
    private URI pluginUrl;
    private String pluginName;
    private SemVerMatch pluginVersion;
    private boolean force;

    public void execute() throws BuildException {
        if (this.pluginFile == null && this.pluginUrl == null && this.pluginName == null) {
            throw new BuildException((Throwable)new IllegalStateException("pluginName argument not set"));
        }
        PluginInstall pluginInstall = new PluginInstall();
        DITAOTAntLogger logger = new DITAOTAntLogger(this.getProject());
        logger.setTarget(this.getOwningTarget());
        logger.setTask(this);
        pluginInstall.setLogger(logger);
        pluginInstall.setForce(this.force);
        pluginInstall.setDitaDir(this.getDitaDir());
        pluginInstall.setPluginFile(this.pluginFile);
        pluginInstall.setPluginUri(this.pluginUrl);
        pluginInstall.setPluginName(this.pluginName);
        pluginInstall.setPluginVersion(this.pluginVersion);
        try {
            pluginInstall.execute();
        }
        catch (Exception e) {
            throw new BuildException("Failed to install %s %s: %s".formatted(this.pluginName, this.pluginVersion, e.getMessage()), (Throwable)e);
        }
    }

    private File getDitaDir() {
        return Paths.get(this.getProject().getProperty("dita.dir"), new String[0]).toFile();
    }

    public void setPluginFile(String pluginFile) {
        try {
            this.pluginFile = Paths.get(pluginFile, new String[0]);
        }
        catch (InvalidPathException invalidPathException) {
            // empty catch block
        }
        try {
            URI uri = new URI(pluginFile);
            if (uri.isAbsolute()) {
                this.pluginUrl = uri;
            }
        }
        catch (URISyntaxException uri) {
            // empty catch block
        }
        if (pluginFile.contains("@")) {
            String[] tokens = pluginFile.split("@");
            this.pluginName = tokens[0];
            this.pluginVersion = new SemVerMatch(tokens[1]);
        } else {
            this.pluginName = pluginFile;
            this.pluginVersion = null;
        }
    }

    public void setForce(boolean force) {
        this.force = force;
    }
}

