/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.provider;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.util.Map;
import javax.annotation.Nonnull;
import org.gradle.api.Action;
import org.gradle.api.internal.lambdas.SerializableLambdas;
import org.gradle.api.internal.provider.MapCollector;
import org.gradle.api.internal.provider.MapEntryCollector;
import org.gradle.api.internal.provider.ProviderInternal;
import org.gradle.api.internal.provider.ValueCollector;
import org.gradle.api.internal.provider.ValueSupplier;
import org.gradle.internal.Cast;

public class MapCollectors {

    public static class EntriesFromMapProvider<K, V>
    implements MapCollector<K, V> {
        private final ProviderInternal<? extends Map<? extends K, ? extends V>> providerOfEntries;
        private final boolean ignoreAbsent;

        public EntriesFromMapProvider(ProviderInternal<? extends Map<? extends K, ? extends V>> providerOfEntries) {
            this(providerOfEntries, false);
        }

        private EntriesFromMapProvider(ProviderInternal<? extends Map<? extends K, ? extends V>> providerOfEntries, boolean ignoreAbsent) {
            this.providerOfEntries = ignoreAbsent ? EntriesFromMapProvider.neverMissing((ProviderInternal)Cast.uncheckedNonnullCast(providerOfEntries)) : providerOfEntries;
            this.ignoreAbsent = ignoreAbsent;
        }

        @Override
        public MapCollector<K, V> absentIgnoring() {
            return this.ignoreAbsent ? this : new EntriesFromMapProvider<K, V>(this.providerOfEntries, true);
        }

        @Nonnull
        private static <K, V> ProviderInternal<? extends Map<? extends K, ? extends V>> neverMissing(ProviderInternal<Map<? extends K, ? extends V>> provider) {
            return (ProviderInternal)Cast.uncheckedNonnullCast((Object)provider.orElse(ImmutableMap.of()));
        }

        @Override
        public boolean calculatePresence(ValueSupplier.ValueConsumer consumer) {
            return this.ignoreAbsent || this.providerOfEntries.calculatePresence(consumer);
        }

        @Override
        public ValueSupplier.Value<Void> collectEntries(ValueSupplier.ValueConsumer consumer, MapEntryCollector<K, V> collector, Map<K, V> dest) {
            ValueSupplier.Value<Map<K, V>> value = this.providerOfEntries.calculateValue(consumer);
            if (value.isMissing()) {
                return this.ignoreAbsent ? ValueSupplier.Value.present() : value.asType();
            }
            collector.addAll(value.getWithoutSideEffect().entrySet(), dest);
            return ValueSupplier.Value.present().withSideEffect(ValueSupplier.SideEffect.fixedFrom(value));
        }

        @Override
        public ValueSupplier.Value<Void> collectKeys(ValueSupplier.ValueConsumer consumer, ValueCollector<K> collector, ImmutableCollection.Builder<K> dest) {
            ValueSupplier.Value<Map<K, V>> value = this.providerOfEntries.calculateValue(consumer);
            if (value.isMissing()) {
                return value.asType();
            }
            collector.addAll(value.getWithoutSideEffect().keySet(), dest);
            return ValueSupplier.Value.present().withSideEffect(ValueSupplier.SideEffect.fixedFrom(value));
        }

        @Override
        public void calculateExecutionTimeValue(Action<ValueSupplier.ExecutionTimeValue<? extends Map<? extends K, ? extends V>>> visitor) {
            visitor.execute(this.providerOfEntries.calculateExecutionTimeValue());
        }

        @Override
        public ValueSupplier.ValueProducer getProducer() {
            return this.providerOfEntries.getProducer();
        }

        public String toString() {
            return String.valueOf(this.providerOfEntries);
        }
    }

    public static class EntriesFromMap<K, V>
    implements MapCollector<K, V> {
        private final Map<? extends K, ? extends V> entries;

        public EntriesFromMap(Map<? extends K, ? extends V> entries) {
            this.entries = entries;
        }

        @Override
        public boolean calculatePresence(ValueSupplier.ValueConsumer consumer) {
            return true;
        }

        @Override
        public MapCollector<K, V> absentIgnoring() {
            return this;
        }

        @Override
        public ValueSupplier.Value<Void> collectEntries(ValueSupplier.ValueConsumer consumer, MapEntryCollector<K, V> collector, Map<K, V> dest) {
            collector.addAll(this.entries.entrySet(), dest);
            return ValueSupplier.Value.present();
        }

        @Override
        public ValueSupplier.Value<Void> collectKeys(ValueSupplier.ValueConsumer consumer, ValueCollector<K> collector, ImmutableCollection.Builder<K> dest) {
            collector.addAll(this.entries.keySet(), dest);
            return ValueSupplier.Value.present();
        }

        @Override
        public void calculateExecutionTimeValue(Action<ValueSupplier.ExecutionTimeValue<? extends Map<? extends K, ? extends V>>> sources) {
            sources.execute(ValueSupplier.ExecutionTimeValue.fixedValue(this.entries));
        }

        @Override
        public ValueSupplier.ValueProducer getProducer() {
            return ValueSupplier.ValueProducer.unknown();
        }

        public String toString() {
            return this.entries.toString();
        }
    }

    public static class EntryWithValueFromProvider<K, V>
    implements MapCollector<K, V> {
        private final K key;
        private final ProviderInternal<? extends V> providerOfValue;

        public EntryWithValueFromProvider(K key, ProviderInternal<? extends V> providerOfValue) {
            this.key = key;
            this.providerOfValue = providerOfValue;
        }

        @Override
        public MapCollector<K, V> absentIgnoring() {
            return new EntriesFromMapProvider((ProviderInternal)this.providerOfValue.map(value -> ImmutableMap.of(this.key, (Object)value)), true);
        }

        @Override
        public boolean calculatePresence(ValueSupplier.ValueConsumer consumer) {
            return this.providerOfValue.calculatePresence(consumer);
        }

        @Override
        public ValueSupplier.Value<Void> collectEntries(ValueSupplier.ValueConsumer consumer, MapEntryCollector<K, V> collector, Map<K, V> dest) {
            ValueSupplier.Value<V> value = this.providerOfValue.calculateValue(consumer);
            if (value.isMissing()) {
                return value.asType();
            }
            collector.add(this.key, value.getWithoutSideEffect(), dest);
            return ValueSupplier.Value.present().withSideEffect(ValueSupplier.SideEffect.fixedFrom(value));
        }

        @Override
        public ValueSupplier.Value<Void> collectKeys(ValueSupplier.ValueConsumer consumer, ValueCollector<K> collector, ImmutableCollection.Builder<K> dest) {
            if (this.providerOfValue.calculatePresence(consumer)) {
                collector.add(this.key, dest);
                return ValueSupplier.Value.present();
            }
            return ValueSupplier.Value.missing();
        }

        @Override
        public void calculateExecutionTimeValue(Action<ValueSupplier.ExecutionTimeValue<? extends Map<? extends K, ? extends V>>> visitor) {
            ValueSupplier.ExecutionTimeValue<V> value = this.providerOfValue.calculateExecutionTimeValue();
            if (value.isMissing()) {
                visitor.execute(ValueSupplier.ExecutionTimeValue.missing());
            } else if (value.hasFixedValue()) {
                visitor.execute(ValueSupplier.ExecutionTimeValue.value(value.toValue().transform(v -> ImmutableMap.of(this.key, (Object)v))));
            } else {
                visitor.execute(ValueSupplier.ExecutionTimeValue.changingValue(value.getChangingValue().map(SerializableLambdas.transformer((SerializableLambdas.SerializableTransformer & Serializable)v -> ImmutableMap.of(this.key, (Object)v)))));
            }
        }

        @Override
        public ValueSupplier.ValueProducer getProducer() {
            return this.providerOfValue.getProducer();
        }

        public String toString() {
            return String.format("entry{%s=%s}", this.key, this.providerOfValue);
        }
    }

    public static class SingleEntry<K, V>
    implements MapCollector<K, V> {
        private final K key;
        private final V value;

        public SingleEntry(K key, V value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public boolean calculatePresence(ValueSupplier.ValueConsumer consumer) {
            return true;
        }

        @Override
        public MapCollector<K, V> absentIgnoring() {
            return this;
        }

        @Override
        public ValueSupplier.Value<Void> collectEntries(ValueSupplier.ValueConsumer consumer, MapEntryCollector<K, V> collector, Map<K, V> dest) {
            collector.add(this.key, this.value, dest);
            return ValueSupplier.Value.present();
        }

        @Override
        public ValueSupplier.Value<Void> collectKeys(ValueSupplier.ValueConsumer consumer, ValueCollector<K> collector, ImmutableCollection.Builder<K> dest) {
            collector.add(this.key, dest);
            return ValueSupplier.Value.present();
        }

        @Override
        public void calculateExecutionTimeValue(Action<ValueSupplier.ExecutionTimeValue<? extends Map<? extends K, ? extends V>>> visitor) {
            visitor.execute(ValueSupplier.ExecutionTimeValue.fixedValue(ImmutableMap.of(this.key, this.value)));
        }

        @Override
        public ValueSupplier.ValueProducer getProducer() {
            return ValueSupplier.ValueProducer.unknown();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SingleEntry that = (SingleEntry)o;
            return Objects.equal(this.key, that.key) && Objects.equal(this.value, that.value);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.key, this.value});
        }

        public String toString() {
            return String.format("{%s=%s}", this.key, this.value);
        }
    }
}

