/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.protocol;

import com.impossibl.postgres.protocol.DataRow;
import com.impossibl.postgres.protocol.ResultField;
import com.impossibl.postgres.system.Context;
import com.impossibl.postgres.types.Type;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.List;

public class BufferedDataRow
implements DataRow {
    private ByteBuf buffer;
    private List<ResultField> columns;
    private int[] columnOffsets;
    private Context parsingContext;

    private BufferedDataRow(ByteBuf buffer, List<ResultField> columns, int[] columnOffsets, Context parsingContext) {
        this.buffer = buffer.retain();
        this.columns = columns;
        this.columnOffsets = columnOffsets;
        this.parsingContext = parsingContext;
    }

    @Override
    public Object getColumn(int columnIndex) throws IOException {
        ResultField field2 = this.columns.get(columnIndex);
        Type type = field2.getTypeRef().get();
        int offset = this.columnOffsets[columnIndex];
        ByteBuf fieldBuffer = this.buffer.slice(offset, Math.max(this.buffer.getInt(offset), 0) + 4);
        return type.getCodec(field2.getFormat()).getDecoder().decode(type, field2.getTypeLength(), field2.getTypeModifier(), fieldBuffer, this.parsingContext);
    }

    @Override
    public void release() {
        this.buffer.release();
    }

    @Override
    public void touch() {
        if (this.buffer != null) {
            this.buffer.touch();
        }
    }

    public static BufferedDataRow parse(ByteBuf buffer, List<ResultField> columns, Context parsingContext) {
        int columnsCount = buffer.readUnsignedShort();
        int[] offsets = new int[columnsCount];
        for (int c = 0; c < columnsCount; ++c) {
            offsets[c] = buffer.readerIndex();
            buffer.skipBytes(Math.max(buffer.readInt(), 0));
        }
        return new BufferedDataRow(buffer, columns, offsets, parsingContext);
    }
}

