/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.system.procs;

import com.impossibl.postgres.system.Context;
import com.impossibl.postgres.system.procs.BinaryDecoder;
import com.impossibl.postgres.system.procs.BinaryEncoder;
import com.impossibl.postgres.system.procs.SimpleProcProvider;
import com.impossibl.postgres.system.procs.TextDecoder;
import com.impossibl.postgres.system.procs.TextEncoder;
import com.impossibl.postgres.types.PrimitiveType;
import com.impossibl.postgres.types.Type;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MacAddrs
extends SimpleProcProvider {
    public MacAddrs() {
        super((Type.Codec.Encoder)new TxtEncoder(), (Type.Codec.Decoder)new TxtDecoder(), (Type.Codec.Encoder)new BinEncoder(), (Type.Codec.Decoder)new BinDecoder(), "macaddr_");
    }

    static class TxtEncoder
    extends TextEncoder {
        private static final char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        private static final char separator = ':';

        TxtEncoder() {
        }

        @Override
        public Class<?> getInputType() {
            return byte[].class;
        }

        @Override
        public PrimitiveType getOutputPrimitiveType() {
            return PrimitiveType.Binary;
        }

        @Override
        public void encode(Type type, StringBuilder buffer, Object val, Context context) throws IOException {
            byte[] addr = (byte[])val;
            if (addr.length != 6) {
                throw new IOException("invalid length");
            }
            for (byte b : addr) {
                int bi = b & 0xFF;
                buffer.append(hexDigits[bi >> 4]);
                buffer.append(hexDigits[bi & 0xF]).append(':');
            }
            buffer.setLength(buffer.length() - 1);
        }
    }

    static class TxtDecoder
    extends TextDecoder {
        private static final Pattern macPattern = Pattern.compile("([0-9a-f-A-F]{2})[:-]?([0-9a-f-A-F]{2})[-:.]?([0-9a-f-A-F]{2})[:-]?([0-9a-f-A-F]{2})[-:.]?([0-9a-f-A-F]{2})[:-]?([0-9a-f-A-F]{2})");

        TxtDecoder() {
        }

        @Override
        public PrimitiveType getInputPrimitiveType() {
            return PrimitiveType.Binary;
        }

        @Override
        public Class<?> getOutputType() {
            return byte[].class;
        }

        public byte[] decode(Type type, Short typeLength, Integer typeModifier, CharSequence buffer, Context context) throws IOException {
            Matcher m3 = macPattern.matcher(buffer);
            if (!m3.matches()) {
                throw new IOException("Invalid Mac address: " + buffer);
            }
            byte[] addr = new byte[6];
            for (int i = 0; i < 6; ++i) {
                addr[i] = (byte)Integer.parseInt(m3.group(i + 1), 16);
            }
            return addr;
        }
    }

    static class BinEncoder
    extends BinaryEncoder {
        BinEncoder() {
        }

        @Override
        public Class<?> getInputType() {
            return byte[].class;
        }

        @Override
        public PrimitiveType getOutputPrimitiveType() {
            return PrimitiveType.Binary;
        }

        @Override
        public void encode(Type type, ByteBuf buffer, Object val, Context context) throws IOException {
            if (val == null) {
                buffer.writeInt(-1);
            } else {
                byte[] bytes = (byte[])val;
                if (bytes.length != 6) {
                    throw new IOException("invalid length");
                }
                buffer.writeInt(6);
                buffer.writeBytes(bytes);
            }
        }
    }

    static class BinDecoder
    extends BinaryDecoder {
        BinDecoder() {
        }

        @Override
        public PrimitiveType getInputPrimitiveType() {
            return PrimitiveType.Binary;
        }

        @Override
        public Class<?> getOutputType() {
            return byte[].class;
        }

        public byte[] decode(Type type, Short typeLength, Integer typeModifier, ByteBuf buffer, Context context) throws IOException {
            int length = buffer.readInt();
            if (length == -1) {
                return null;
            }
            if (length != 6) {
                throw new IOException("invalid length");
            }
            byte[] bytes = new byte[6];
            buffer.readBytes(bytes);
            return bytes;
        }
    }
}

