/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.richtext.model;

import java.util.Optional;
import java.util.function.BiFunction;
import org.fxmisc.richtext.model.EitherSegmentOps;
import org.fxmisc.richtext.model.EitherStyledSegmentOps;
import org.fxmisc.richtext.model.TextOps;
import org.fxmisc.richtext.model.TextOpsBase;
import org.reactfx.util.Either;

public interface SegmentOps<SEG, S> {
    public int length(SEG var1);

    public char charAt(SEG var1, int var2);

    public String getText(SEG var1);

    public SEG subSequence(SEG var1, int var2, int var3);

    public SEG subSequence(SEG var1, int var2);

    public Optional<SEG> joinSeg(SEG var1, SEG var2);

    default public Optional<S> joinStyle(S currentStyle, S nextStyle) {
        return Optional.empty();
    }

    public SEG createEmptySeg();

    public static <S> TextOps<String, S> styledTextOps() {
        return SegmentOps.styledTextOps((s1, s2) -> Optional.empty());
    }

    public static <S> TextOps<String, S> styledTextOps(final BiFunction<S, S, Optional<S>> mergeStyle) {
        return new TextOpsBase<String, S>(""){

            @Override
            public char realCharAt(String s2, int index) {
                return s2.charAt(index);
            }

            @Override
            public String realGetText(String s2) {
                return s2;
            }

            @Override
            public String realSubSequence(String s2, int start, int end) {
                return s2.substring(start, end);
            }

            @Override
            public String create(String text) {
                return text;
            }

            @Override
            public int length(String s2) {
                return s2.length();
            }

            @Override
            public Optional<String> joinSeg(String currentSeg, String nextSeg) {
                return Optional.of(currentSeg + nextSeg);
            }

            @Override
            public Optional<S> joinStyle(S currentStyle, S nextStyle) {
                return (Optional)mergeStyle.apply(currentStyle, nextStyle);
            }
        };
    }

    default public <R> SegmentOps<Either<SEG, R>, S> or(SegmentOps<R, S> rOps) {
        return SegmentOps.either(this, rOps);
    }

    default public <RSeg, RStyle> SegmentOps<Either<SEG, RSeg>, Either<S, RStyle>> orStyled(SegmentOps<RSeg, RStyle> rOps) {
        return SegmentOps.eitherStyles(this, rOps);
    }

    public static <LSeg, LStyle, RSeg, RStyle> SegmentOps<Either<LSeg, RSeg>, Either<LStyle, RStyle>> eitherStyles(SegmentOps<LSeg, LStyle> lOps, SegmentOps<RSeg, RStyle> rOps) {
        return new EitherStyledSegmentOps<LSeg, RSeg, LStyle, RStyle>(lOps, rOps);
    }

    public static <LSeg, RSeg, Style> SegmentOps<Either<LSeg, RSeg>, Style> either(SegmentOps<LSeg, Style> lOps, SegmentOps<RSeg, Style> rOps) {
        return SegmentOps.either(lOps, rOps, (leftStyle, rightStyle) -> Optional.empty());
    }

    public static <LSeg, RSeg, Style> SegmentOps<Either<LSeg, RSeg>, Style> either(SegmentOps<LSeg, Style> lOps, SegmentOps<RSeg, Style> rOps, BiFunction<Style, Style, Optional<Style>> mergeStyle) {
        return new EitherSegmentOps<LSeg, RSeg, Style>(lOps, rOps, mergeStyle);
    }
}

