/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JPanel;
import org.jabref.gui.JabRefDialog;
import org.jabref.gui.JabRefFrame;
import org.jabref.gui.help.HelpAction;
import org.jabref.gui.importer.ImportInspectionDialog;
import org.jabref.gui.mergeentries.MergeEntries;
import org.jabref.gui.util.WindowLocation;
import org.jabref.logic.help.HelpFile;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.entry.BibEntry;

public class DuplicateResolverDialog
extends JabRefDialog {
    JButton helpButton = new HelpAction(Localization.lang("Help", new String[0]), HelpFile.FIND_DUPLICATES).getHelpButton();
    private final JButton cancel = new JButton(Localization.lang("Cancel", new String[0]));
    private final JButton merge = new JButton(Localization.lang("Keep merged entry only", new String[0]));
    private final JabRefFrame frame;
    private final JPanel options = new JPanel();
    private DuplicateResolverResult status = DuplicateResolverResult.NOT_CHOSEN;
    private MergeEntries me;

    public DuplicateResolverDialog(JabRefFrame frame, BibEntry one, BibEntry two, DuplicateResolverType type) {
        super((Frame)frame, Localization.lang("Possible duplicate entries", new String[0]), true, DuplicateResolverDialog.class);
        this.frame = frame;
        this.init(one, two, type);
    }

    public DuplicateResolverDialog(ImportInspectionDialog dialog, BibEntry one, BibEntry two, DuplicateResolverType type) {
        super((Dialog)dialog, Localization.lang("Possible duplicate entries", new String[0]), true, DuplicateResolverDialog.class);
        this.frame = dialog.getFrame();
        this.init(one, two, type);
    }

    private void init(BibEntry one, BibEntry two, DuplicateResolverType type) {
        JButton both;
        JButton second;
        JButton first;
        JButton removeExact = null;
        switch (type) {
            case DUPLICATE_SEARCH: {
                first = new JButton(Localization.lang("Keep left", new String[0]));
                second = new JButton(Localization.lang("Keep right", new String[0]));
                both = new JButton(Localization.lang("Keep both", new String[0]));
                this.me = new MergeEntries(one, two, this.frame.getCurrentBasePanel().getBibDatabaseContext().getMode());
                break;
            }
            case INSPECTION: {
                first = new JButton(Localization.lang("Remove old entry", new String[0]));
                second = new JButton(Localization.lang("Remove entry from import", new String[0]));
                both = new JButton(Localization.lang("Keep both", new String[0]));
                this.me = new MergeEntries(one, two, Localization.lang("Old entry", new String[0]), Localization.lang("From import", new String[0]), this.frame.getCurrentBasePanel().getBibDatabaseContext().getMode());
                break;
            }
            case DUPLICATE_SEARCH_WITH_EXACT: {
                first = new JButton(Localization.lang("Keep left", new String[0]));
                second = new JButton(Localization.lang("Keep right", new String[0]));
                both = new JButton(Localization.lang("Keep both", new String[0]));
                removeExact = new JButton(Localization.lang("Automatically remove exact duplicates", new String[0]));
                this.me = new MergeEntries(one, two, this.frame.getCurrentBasePanel().getBibDatabaseContext().getMode());
                break;
            }
            default: {
                first = new JButton(Localization.lang("Import and remove old entry", new String[0]));
                second = new JButton(Localization.lang("Do not import entry", new String[0]));
                both = new JButton(Localization.lang("Import and keep old entry", new String[0]));
                this.me = new MergeEntries(one, two, Localization.lang("Old entry", new String[0]), Localization.lang("From import", new String[0]), this.frame.getCurrentBasePanel().getBibDatabaseContext().getMode());
            }
        }
        if (removeExact != null) {
            this.options.add(removeExact);
        }
        this.options.add(first);
        this.options.add(second);
        this.options.add(both);
        this.options.add(this.merge);
        this.options.add(Box.createHorizontalStrut(5));
        this.options.add(this.cancel);
        this.options.add(this.helpButton);
        first.addActionListener(e -> this.buttonPressed(DuplicateResolverResult.KEEP_LEFT));
        second.addActionListener(e -> this.buttonPressed(DuplicateResolverResult.KEEP_RIGHT));
        both.addActionListener(e -> this.buttonPressed(DuplicateResolverResult.KEEP_BOTH));
        this.merge.addActionListener(e -> this.buttonPressed(DuplicateResolverResult.KEEP_MERGE));
        if (removeExact != null) {
            removeExact.addActionListener(e -> this.buttonPressed(DuplicateResolverResult.AUTOREMOVE_EXACT));
        }
        this.cancel.addActionListener(e -> this.buttonPressed(DuplicateResolverResult.BREAK));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                DuplicateResolverDialog.this.buttonPressed(DuplicateResolverResult.BREAK);
            }
        });
        this.getContentPane().add(this.me.getMergeEntryPanel());
        this.getContentPane().add((Component)this.options, "South");
        this.pack();
        WindowLocation pw = new WindowLocation(this, "duplicatesPosX", "duplicatesPosY", "duplicatesSizeX", "duplicatesSizeY");
        pw.displayWindowAtStoredLocation();
        both.requestFocus();
    }

    private void buttonPressed(DuplicateResolverResult result) {
        this.status = result;
        this.dispose();
    }

    public DuplicateResolverResult getSelected() {
        return this.status;
    }

    public BibEntry getMergedEntry() {
        return this.me.getMergeEntry();
    }

    public static enum DuplicateResolverResult {
        NOT_CHOSEN,
        KEEP_BOTH,
        KEEP_LEFT,
        KEEP_RIGHT,
        AUTOREMOVE_EXACT,
        KEEP_MERGE,
        BREAK;

    }

    public static enum DuplicateResolverType {
        DUPLICATE_SEARCH,
        IMPORT_CHECK,
        INSPECTION,
        DUPLICATE_SEARCH_WITH_EXACT;

    }
}

