/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.SwingUtilities;
import org.jabref.Globals;
import org.jabref.gui.BasePanel;
import org.jabref.gui.JabRefFrame;
import org.jabref.gui.SidePane;
import org.jabref.gui.SidePaneComponent;
import org.jabref.gui.maintable.MainTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SidePaneManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(SidePaneManager.class);
    private final JabRefFrame frame;
    private final SidePane sidep;
    private final Map<Class<? extends SidePaneComponent>, SidePaneComponent> components = new LinkedHashMap<Class<? extends SidePaneComponent>, SidePaneComponent>();
    private final List<SidePaneComponent> visible = new LinkedList<SidePaneComponent>();

    public SidePaneManager(JabRefFrame frame) {
        this.frame = frame;
        frame.getTabbedPane().addChangeListener(event -> SwingUtilities.invokeLater(() -> this.setActiveBasePanel(this.frame.getCurrentBasePanel())));
        this.sidep = new SidePane();
        this.sidep.setVisible(false);
    }

    public SidePane getPanel() {
        return this.sidep;
    }

    public synchronized <T extends SidePaneComponent> boolean hasComponent(Class<T> sidePaneComponent) {
        return this.components.containsKey(sidePaneComponent);
    }

    public synchronized <T extends SidePaneComponent> boolean isComponentVisible(Class<T> sidePaneComponent) {
        SidePaneComponent component = this.components.get(sidePaneComponent);
        if (component == null) {
            return false;
        }
        return this.visible.contains(component);
    }

    public synchronized <T extends SidePaneComponent> void toggle(Class<T> sidePaneComponent) {
        if (this.isComponentVisible(sidePaneComponent)) {
            this.hide(sidePaneComponent);
        } else {
            this.show(sidePaneComponent);
        }
    }

    public synchronized <T extends SidePaneComponent> void toggleThreeWay(Class<T> sidePaneComponent) {
        boolean isPanelFocused;
        boolean bl = isPanelFocused = Globals.getFocusListener().getFocused() == this.components.get(sidePaneComponent);
        if (this.isComponentVisible(sidePaneComponent) && isPanelFocused) {
            this.hide(sidePaneComponent);
        } else {
            this.show(sidePaneComponent);
        }
    }

    public synchronized <T extends SidePaneComponent> void show(Class<T> sidePaneComponent) {
        SidePaneComponent component = this.components.get(sidePaneComponent);
        if (component == null) {
            LOGGER.warn("Side pane component '" + sidePaneComponent + "' unknown.");
        } else {
            this.show(component);
        }
    }

    public synchronized <T extends SidePaneComponent> void hide(Class<T> sidePaneComponent) {
        SidePaneComponent component = this.components.get(sidePaneComponent);
        if (component == null) {
            LOGGER.warn("Side pane component '" + sidePaneComponent + "' unknown.");
        } else {
            this.hideComponent(component);
            if (this.frame.getCurrentBasePanel() != null) {
                MainTable mainTable = this.frame.getCurrentBasePanel().getMainTable();
                mainTable.setSelected(mainTable.getSelectedRow());
                mainTable.requestFocus();
            }
        }
    }

    public synchronized void register(SidePaneComponent comp) {
        this.components.put(comp.getClass(), comp);
    }

    private synchronized void show(SidePaneComponent component) {
        if (!this.visible.contains(component)) {
            this.visible.add(0, component);
            Collections.sort(this.visible, new PreferredIndexSort());
            this.updateView();
            component.componentOpening();
        }
        Globals.getFocusListener().setFocused(component);
        component.grabFocus();
    }

    public synchronized <T extends SidePaneComponent> SidePaneComponent getComponent(Class<T> sidePaneComponent) {
        return this.components.get(sidePaneComponent);
    }

    public synchronized void hideComponent(SidePaneComponent comp) {
        if (this.visible.contains(comp)) {
            comp.componentClosing();
            this.visible.remove(comp);
            this.updateView();
        }
    }

    public synchronized <T extends SidePaneComponent> void hideComponent(Class<T> sidePaneComponent) {
        SidePaneComponent component = this.components.get(sidePaneComponent);
        if (component == null) {
            return;
        }
        if (this.visible.contains(component)) {
            component.componentClosing();
            this.visible.remove(component);
            this.updateView();
        }
    }

    private static Map<Class<? extends SidePaneComponent>, Integer> getPreferredPositions() {
        HashMap<Class<? extends SidePaneComponent>, Integer> preferredPositions = new HashMap<Class<? extends SidePaneComponent>, Integer>();
        List<String> componentNames = Globals.prefs.getStringList("sidePaneComponentNames");
        List<String> componentPositions = Globals.prefs.getStringList("sidePaneComponentPreferredPositions");
        for (int i = 0; i < componentNames.size(); ++i) {
            String componentName = componentNames.get(i);
            try {
                Class<?> componentClass = Class.forName(componentName);
                preferredPositions.put(componentClass, Integer.parseInt(componentPositions.get(i)));
                continue;
            }
            catch (ClassNotFoundException e) {
                LOGGER.debug("Following side pane could not be found: " + componentName, e);
                continue;
            }
            catch (ClassCastException e) {
                LOGGER.debug("Following Class is no side pane: '" + componentName, e);
                continue;
            }
            catch (NumberFormatException e) {
                LOGGER.debug("Invalid number format for side pane component '" + componentName + "'.", e);
            }
        }
        return preferredPositions;
    }

    private void updatePreferredPositions() {
        Map<Class<? extends SidePaneComponent>, Integer> preferredPositions = SidePaneManager.getPreferredPositions();
        int index = 0;
        for (SidePaneComponent comp : this.visible) {
            preferredPositions.put(comp.getClass(), index);
            ++index;
        }
        List<String> tmpComponentNames = preferredPositions.keySet().parallelStream().map(Class::getName).collect(Collectors.toList());
        List<String> componentPositions = preferredPositions.values().stream().map(Object::toString).collect(Collectors.toList());
        Globals.prefs.putStringList("sidePaneComponentNames", tmpComponentNames);
        Globals.prefs.putStringList("sidePaneComponentPreferredPositions", componentPositions);
    }

    public synchronized void moveUp(SidePaneComponent comp) {
        int currIndex;
        if (this.visible.contains(comp) && (currIndex = this.visible.indexOf(comp)) > 0) {
            int newIndex = currIndex - 1;
            this.visible.remove(currIndex);
            this.visible.add(newIndex, comp);
            this.updatePreferredPositions();
            this.updateView();
        }
    }

    public synchronized void moveDown(SidePaneComponent comp) {
        int currIndex;
        if (this.visible.contains(comp) && (currIndex = this.visible.indexOf(comp)) < this.visible.size() - 1) {
            int newIndex = currIndex + 1;
            this.visible.remove(currIndex);
            this.visible.add(newIndex, comp);
            this.updatePreferredPositions();
            this.updateView();
        }
    }

    public synchronized <T extends SidePaneComponent> void unregisterComponent(Class<T> sidePaneComponent) {
        this.components.remove(sidePaneComponent);
    }

    private synchronized void setActiveBasePanel(BasePanel panel) {
        for (SidePaneComponent component : this.components.values()) {
            component.setActiveBasePanel(panel);
        }
    }

    public synchronized void updateView() {
        this.sidep.setComponents(this.visible);
        if (this.visible.isEmpty()) {
            if (this.sidep.isVisible()) {
                Globals.prefs.putInt("sidePaneWidth", this.frame.getSplitPane().getDividerLocation());
            }
            this.sidep.setVisible(false);
        } else {
            boolean wasVisible = this.sidep.isVisible();
            this.sidep.setVisible(true);
            if (!wasVisible) {
                int width = Globals.prefs.getInt("sidePaneWidth");
                if (width > 0) {
                    this.frame.getSplitPane().setDividerLocation(width);
                } else {
                    this.frame.getSplitPane().setDividerLocation(this.getPanel().getPreferredSize().width);
                }
            }
        }
    }

    static /* synthetic */ Map access$000() {
        return SidePaneManager.getPreferredPositions();
    }

    private class PreferredIndexSort
    implements Comparator<SidePaneComponent> {
        private final Map<Class<? extends SidePaneComponent>, Integer> preferredPositions = SidePaneManager.access$000();

        @Override
        public int compare(SidePaneComponent comp1, SidePaneComponent comp2) {
            int pos1 = this.preferredPositions.getOrDefault(comp1.getClass(), 0);
            int pos2 = this.preferredPositions.getOrDefault(comp2.getClass(), 0);
            return Integer.valueOf(pos1).compareTo(pos2);
        }
    }
}

