/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.actions;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JDialog;
import org.jabref.Globals;
import org.jabref.JabRefExecutorService;
import org.jabref.JabRefGUI;
import org.jabref.gui.IconTheme;
import org.jabref.gui.externalfiles.AutoSetLinks;
import org.jabref.gui.keyboard.KeyBinding;
import org.jabref.gui.undo.NamedCompound;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.entry.BibEntry;

public class AutoLinkFilesAction
extends AbstractAction {
    public AutoLinkFilesAction() {
        this.putValue("SmallIcon", IconTheme.JabRefIcon.AUTO_FILE_LINK.getSmallIcon());
        this.putValue("SwingLargeIconKey", IconTheme.JabRefIcon.AUTO_FILE_LINK.getIcon());
        this.putValue("Name", Localization.lang("Automatically set file links", new String[0]));
        this.putValue("AcceleratorKey", Globals.getKeyPrefs().getKey(KeyBinding.AUTOMATICALLY_LINK_FILES));
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        List<BibEntry> entries = JabRefGUI.getMainFrame().getCurrentBasePanel().getSelectedEntries();
        if (entries.isEmpty()) {
            JabRefGUI.getMainFrame().getCurrentBasePanel().output(Localization.lang("This operation requires one or more entries to be selected.", new String[0]));
            return;
        }
        JDialog diag = new JDialog((Frame)JabRefGUI.getMainFrame(), true);
        NamedCompound nc = new NamedCompound(Localization.lang("Automatically set file links", new String[0]));
        Runnable runnable = AutoSetLinks.autoSetLinks(entries, nc, null, JabRefGUI.getMainFrame().getCurrentBasePanel().getBibDatabaseContext(), e -> {
            if (e.getID() > 0) {
                if (nc.hasEdits()) {
                    nc.end();
                    JabRefGUI.getMainFrame().getCurrentBasePanel().getUndoManager().addEdit(nc);
                    JabRefGUI.getMainFrame().getCurrentBasePanel().markBaseChanged();
                }
                JabRefGUI.getMainFrame().output(Localization.lang("Finished automatically setting external links.", new String[0]));
            } else {
                JabRefGUI.getMainFrame().output(Localization.lang("Finished automatically setting external links.", new String[0]) + " " + Localization.lang("No files found.", new String[0]));
            }
        }, diag);
        JabRefExecutorService.INSTANCE.execute(runnable);
    }
}

