/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.copyfiles;

import de.jensd.fx.glyphs.GlyphIcons;
import de.jensd.fx.glyphs.materialdesignicons.MaterialDesignIcon;
import de.jensd.fx.glyphs.materialdesignicons.utils.MaterialDesignIconFactory;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Text;
import javax.inject.Inject;
import org.jabref.gui.AbstractController;
import org.jabref.gui.copyfiles.CopyFilesDialogViewModel;
import org.jabref.gui.copyfiles.CopyFilesResultItemViewModel;
import org.jabref.gui.copyfiles.CopyFilesResultListDependency;
import org.jabref.gui.util.ValueTableCellFactory;

public class CopyFilesDialogController
extends AbstractController<CopyFilesDialogViewModel> {
    @FXML
    private TableView<CopyFilesResultItemViewModel> tvResult;
    @FXML
    private TableColumn<CopyFilesResultItemViewModel, MaterialDesignIcon> colStatus;
    @FXML
    private TableColumn<CopyFilesResultItemViewModel, String> colMessage;
    @FXML
    private TableColumn<CopyFilesResultItemViewModel, String> colFile;
    @Inject
    private CopyFilesResultListDependency copyfilesresultlistDependency;

    @FXML
    private void close(ActionEvent event) {
        this.getStage().close();
    }

    @FXML
    private void initialize() {
        this.viewModel = new CopyFilesDialogViewModel(this.copyfilesresultlistDependency);
        this.setupTable();
    }

    private void setupTable() {
        this.colFile.setCellValueFactory(cellData -> ((CopyFilesResultItemViewModel)cellData.getValue()).getFile());
        this.colMessage.setCellValueFactory(cellData -> ((CopyFilesResultItemViewModel)cellData.getValue()).getMessage());
        this.colStatus.setCellValueFactory(cellData -> ((CopyFilesResultItemViewModel)cellData.getValue()).getIcon());
        this.colFile.setCellFactory(new ValueTableCellFactory().withText(item -> item).withTooltip(item -> item));
        this.colStatus.setCellFactory(new ValueTableCellFactory().withGraphic(item -> {
            Text icon = MaterialDesignIconFactory.get().createIcon((GlyphIcons)item);
            if (item == MaterialDesignIcon.CHECK) {
                icon.setFill((Paint)Color.GREEN);
            }
            if (item == MaterialDesignIcon.ALERT) {
                icon.setFill((Paint)Color.RED);
            }
            return icon;
        }));
        this.tvResult.setItems(((CopyFilesDialogViewModel)this.viewModel).copyFilesResultListProperty());
        this.tvResult.setColumnResizePolicy(param2 -> true);
    }
}

