/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.customentrytypes;

import java.awt.event.ActionListener;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jabref.Globals;
import org.jabref.gui.customentrytypes.FieldSetComponent;
import org.jabref.logic.bibtexkeypattern.BibtexKeyGenerator;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.EntryTypes;
import org.jabref.model.database.BibDatabaseMode;
import org.jabref.model.entry.CustomEntryType;
import org.jabref.model.entry.EntryType;

public class EntryTypeList
extends FieldSetComponent
implements ListSelectionListener {
    private final JButton def = new JButton(Localization.lang("Default", new String[0]));
    private final BibDatabaseMode mode;

    public EntryTypeList(List<String> fields, BibDatabaseMode mode) {
        super(Localization.lang("Entry types", new String[0]), fields, false, true);
        this.mode = mode;
        this.con.gridx = 0;
        this.con.gridy = 2;
        this.con.fill = 3;
        this.con.anchor = 13;
        this.gbl.setConstraints(this.def, this.con);
        this.add(this.def);
        this.list.addListSelectionListener(this);
        this.def.addActionListener(e -> this.def.setEnabled(false));
        this.def.setEnabled(false);
        this.remove.setEnabled(false);
    }

    @Override
    protected void addField(String str) {
        String s2 = str.trim();
        if (this.forceLowerCase) {
            s2 = s2.toLowerCase(Locale.ROOT);
        }
        if ("".equals(s2) || this.listModel.contains(s2)) {
            return;
        }
        String testString = BibtexKeyGenerator.cleanKey(s2, Globals.prefs.getBoolean("enforceLegalBibtexKey"));
        if (!testString.equals(s2) || s2.indexOf(38) >= 0) {
            JOptionPane.showMessageDialog(this, Localization.lang("Entry type names are not allowed to contain white space or the following characters", new String[0]) + ": # { } ~ , ^ &", Localization.lang("Error", new String[0]), 0);
            return;
        }
        if ("comment".equalsIgnoreCase(s2)) {
            JOptionPane.showMessageDialog(this, Localization.lang("The name 'comment' cannot be used as an entry type name.", new String[0]), Localization.lang("Error", new String[0]), 0);
            return;
        }
        this.addFieldUncritically(s2);
    }

    @Override
    protected void removeSelected() {
        int[] selected = this.list.getSelectedIndices();
        if (selected.length > 0) {
            this.changesMade = true;
        }
        for (int i = 0; i < selected.length; ++i) {
            String typeName = (String)this.listModel.get(selected[selected.length - 1 - i]);
            Optional<EntryType> type = EntryTypes.getType(typeName, this.mode);
            if (type.isPresent() && type.get() instanceof CustomEntryType) {
                this.listModel.removeElementAt(selected[selected.length - 1 - i]);
                continue;
            }
            JOptionPane.showMessageDialog(null, Localization.lang("This entry type cannot be removed.", new String[0]), Localization.lang("Remove entry type", new String[0]), 0);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
    }

    public void enable(String typeName, boolean isChanged) {
        if (EntryTypes.getStandardType(typeName, this.mode).isPresent()) {
            Optional<EntryType> entryType = EntryTypes.getType(typeName, this.mode);
            if (isChanged || entryType.isPresent() && entryType.get() instanceof CustomEntryType) {
                this.def.setEnabled(true);
            } else {
                this.def.setEnabled(false);
            }
            this.remove.setEnabled(false);
        } else {
            this.def.setEnabled(false);
            this.remove.setEnabled(true);
        }
    }

    public void addDefaultActionListener(ActionListener l) {
        this.def.addActionListener(l);
    }

    @Override
    public void setEnabled(boolean en) {
        super.setEnabled(en);
        this.def.setEnabled(en);
    }
}

