/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.fieldeditors;

import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import org.jabref.gui.EntryContainer;
import org.jabref.gui.JabRefFrame;
import org.jabref.gui.externalfiles.DroppedFileHandler;
import org.jabref.gui.externalfiletype.ExternalFileType;
import org.jabref.gui.externalfiletype.ExternalFileTypes;
import org.jabref.gui.groups.EntryTableTransferHandler;
import org.jabref.model.util.FileHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FileListEditorTransferHandler
extends TransferHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileListEditorTransferHandler.class);
    private final DataFlavor URL_FLAVOR;
    private final JabRefFrame frame;
    private final EntryContainer entryContainer;
    private final TransferHandler textTransferHandler;
    private DroppedFileHandler droppedFileHandler;

    public FileListEditorTransferHandler(JabRefFrame frame, EntryContainer entryContainer, TransferHandler textTransferHandler) {
        this.frame = frame;
        this.entryContainer = entryContainer;
        this.textTransferHandler = textTransferHandler;
        this.URL_FLAVOR = this.getUrlFlavor();
    }

    private DataFlavor getUrlFlavor() {
        DataFlavor urlFlavor;
        try {
            urlFlavor = new DataFlavor("application/x-java-url; class=java.net.URL");
        }
        catch (ClassNotFoundException e) {
            LOGGER.info("Unable to configure drag and drop for file link table", e);
            urlFlavor = null;
        }
        return urlFlavor;
    }

    @Override
    public int getSourceActions(JComponent c) {
        return 0x40000001;
    }

    @Override
    public void exportToClipboard(JComponent comp, Clipboard clip, int action) {
        if (this.textTransferHandler != null) {
            this.textTransferHandler.exportToClipboard(comp, clip, action);
        }
    }

    @Override
    public boolean importData(JComponent comp, Transferable transferable) {
        try {
            ArrayList<Path> files = new ArrayList<Path>();
            if (transferable.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                List transferedFiles = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
                files.addAll(transferedFiles.stream().map(File::toPath).collect(Collectors.toList()));
            } else if (transferable.isDataFlavorSupported(this.URL_FLAVOR)) {
                URL dropLink = (URL)transferable.getTransferData(this.URL_FLAVOR);
                LOGGER.warn("Dropped URL, which is currently not implemented " + dropLink);
            } else if (transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                String dropStr = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                files.addAll(EntryTableTransferHandler.getFilesFromDraggedFilesString(dropStr));
            } else {
                LOGGER.warn("Dropped something, which we currently cannot handle");
            }
            SwingUtilities.invokeLater(() -> {
                for (Path file : files) {
                    String name = file.toAbsolutePath().toString();
                    FileHelper.getFileExtension(name).ifPresent(extension -> ExternalFileTypes.getInstance().getExternalFileTypeByExt((String)extension).ifPresent(fileType -> {
                        if (this.droppedFileHandler == null) {
                            this.droppedFileHandler = new DroppedFileHandler(this.frame, this.frame.getCurrentBasePanel());
                        }
                        this.droppedFileHandler.handleDroppedfile(name, (ExternalFileType)fileType, this.entryContainer.getEntry());
                    }));
                }
            });
            if (!files.isEmpty()) {
                return true;
            }
        }
        catch (IOException ioe) {
            LOGGER.warn("Failed to read dropped data. ", ioe);
        }
        catch (UnsupportedFlavorException | ClassCastException ufe) {
            LOGGER.warn("Drop type error. ", ufe);
        }
        LOGGER.warn("Cannot transfer input: " + this.dataFlavorsToString(transferable.getTransferDataFlavors()));
        return false;
    }

    private String dataFlavorsToString(DataFlavor[] transferFlavors) {
        return Arrays.stream(transferFlavors).map(dataFlavor -> dataFlavor.toString()).collect(Collectors.joining(" "));
    }

    @Override
    public boolean canImport(JComponent comp, DataFlavor[] transferFlavors) {
        for (DataFlavor inflav : transferFlavors) {
            if (!inflav.match(this.URL_FLAVOR) && !inflav.match(DataFlavor.stringFlavor) && !inflav.match(DataFlavor.javaFileListFlavor)) continue;
            return true;
        }
        LOGGER.debug("Unknown data transfer flavor: " + this.dataFlavorsToString(transferFlavors));
        return false;
    }
}

