/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.fieldeditors;

import de.jensd.fx.glyphs.materialdesignicons.MaterialDesignIcon;
import de.jensd.fx.glyphs.materialdesignicons.utils.MaterialDesignIconFactory;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Button;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.ListView;
import javafx.scene.control.MenuItem;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.Tooltip;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.DragEvent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.TransferMode;
import javafx.scene.layout.HBox;
import javafx.scene.text.Text;
import org.jabref.Globals;
import org.jabref.gui.DialogService;
import org.jabref.gui.DragAndDropDataFormats;
import org.jabref.gui.autocompleter.AutoCompleteSuggestionProvider;
import org.jabref.gui.fieldeditors.FieldEditorFX;
import org.jabref.gui.fieldeditors.LinkedFileViewModel;
import org.jabref.gui.fieldeditors.LinkedFilesEditorViewModel;
import org.jabref.gui.keyboard.KeyBinding;
import org.jabref.gui.util.ControlHelper;
import org.jabref.gui.util.TaskExecutor;
import org.jabref.gui.util.ViewModelListCellFactory;
import org.jabref.logic.integrity.FieldCheckers;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.LinkedFile;
import org.jabref.preferences.JabRefPreferences;

public class LinkedFilesEditor
extends HBox
implements FieldEditorFX {
    @FXML
    private final LinkedFilesEditorViewModel viewModel;
    @FXML
    private ListView<LinkedFileViewModel> listView;

    public LinkedFilesEditor(String fieldName, DialogService dialogService, BibDatabaseContext databaseContext, TaskExecutor taskExecutor, AutoCompleteSuggestionProvider<?> suggestionProvider, FieldCheckers fieldCheckers, JabRefPreferences preferences) {
        this.viewModel = new LinkedFilesEditorViewModel(fieldName, suggestionProvider, dialogService, databaseContext, taskExecutor, fieldCheckers, preferences);
        ControlHelper.loadFXMLForControl((Parent)this);
        ViewModelListCellFactory<LinkedFileViewModel> cellFactory = new ViewModelListCellFactory().withTooltip(LinkedFileViewModel::getDescription).withGraphic(LinkedFilesEditor::createFileDisplay).withContextMenu(this::createContextMenuForFile).withOnMouseClickedEvent(this::handleItemMouseClick).setOnDragDetected(this::handleOnDragDetected).setOnDragDropped(this::handleOnDragDropped).setOnDragOver(this::handleOnDragOver);
        this.listView.setCellFactory(cellFactory);
        this.setUpFilesDragAndDrop();
        Bindings.bindContentBidirectional((ObservableList)((ObservableList)this.listView.itemsProperty().get()), this.viewModel.filesProperty());
        this.setUpKeyBindings();
    }

    private void setUpFilesDragAndDrop() {
        this.listView.setOnDragOver(event -> {
            if (event.getDragboard().hasFiles()) {
                event.acceptTransferModes(new TransferMode[]{TransferMode.COPY, TransferMode.LINK});
            }
        });
        this.listView.setOnDragDropped(event -> {
            Dragboard dragboard = event.getDragboard();
            boolean success = false;
            ObservableList items = (ObservableList)this.listView.itemsProperty().get();
            if (dragboard.hasFiles()) {
                List linkedFiles = dragboard.getFiles().stream().map(File::toPath).map(this.viewModel::fromFile).collect(Collectors.toList());
                items.addAll(linkedFiles);
                success = true;
            }
            event.setDropCompleted(success);
            event.consume();
        });
    }

    private void handleOnDragOver(LinkedFileViewModel originalItem, DragEvent event) {
        if (event.getGestureSource() != originalItem && event.getDragboard().hasContent(DragAndDropDataFormats.LINKED_FILE)) {
            event.acceptTransferModes(new TransferMode[]{TransferMode.MOVE});
        }
        if (event.getDragboard().hasFiles()) {
            event.acceptTransferModes(new TransferMode[]{TransferMode.COPY, TransferMode.LINK});
        }
    }

    private void handleOnDragDetected(LinkedFileViewModel linkedFile, MouseEvent event) {
        LinkedFile selectedItem = ((LinkedFileViewModel)this.listView.getSelectionModel().getSelectedItem()).getFile();
        if (selectedItem != null) {
            ClipboardContent content = new ClipboardContent();
            Dragboard dragboard = this.listView.startDragAndDrop(new TransferMode[]{TransferMode.MOVE});
            content.put((Object)DragAndDropDataFormats.LINKED_FILE, (Object)selectedItem);
            dragboard.setContent((Map)content);
        }
        event.consume();
    }

    private void handleOnDragDropped(LinkedFileViewModel originalItem, DragEvent event) {
        Dragboard dragboard = event.getDragboard();
        boolean success = false;
        ObservableList items = (ObservableList)this.listView.itemsProperty().get();
        if (dragboard.hasContent(DragAndDropDataFormats.LINKED_FILE)) {
            LinkedFile linkedFile = (LinkedFile)dragboard.getContent(DragAndDropDataFormats.LINKED_FILE);
            LinkedFileViewModel transferedItem = null;
            int draggedIdx = 0;
            for (int i = 0; i < items.size(); ++i) {
                if (!((LinkedFileViewModel)items.get(i)).getFile().equals(linkedFile)) continue;
                draggedIdx = i;
                transferedItem = (LinkedFileViewModel)items.get(i);
                break;
            }
            int thisIdx = items.indexOf((Object)originalItem);
            items.set(draggedIdx, (Object)originalItem);
            items.set(thisIdx, transferedItem);
            success = true;
        }
        if (dragboard.hasFiles()) {
            List linkedFiles = dragboard.getFiles().stream().map(File::toPath).map(this.viewModel::fromFile).collect(Collectors.toList());
            items.addAll(linkedFiles);
        }
        event.setDropCompleted(success);
        event.consume();
    }

    private static Node createFileDisplay(LinkedFileViewModel linkedFile) {
        Text icon = MaterialDesignIconFactory.get().createIcon(linkedFile.getTypeIcon());
        icon.setOnMouseClicked(event -> linkedFile.open());
        Text link = new Text();
        link.textProperty().bind((ObservableValue)linkedFile.linkProperty());
        Text desc = new Text();
        desc.textProperty().bind((ObservableValue)linkedFile.descriptionProperty());
        ProgressBar progressIndicator = new ProgressBar();
        progressIndicator.progressProperty().bind((ObservableValue)linkedFile.downloadProgressProperty());
        progressIndicator.visibleProperty().bind((ObservableValue)linkedFile.downloadOngoingProperty());
        Button acceptAutoLinkedFile = MaterialDesignIconFactory.get().createIconButton(MaterialDesignIcon.BRIEFCASE_CHECK);
        acceptAutoLinkedFile.setTooltip(new Tooltip(Localization.lang("This file was found automatically. Do you want to link it to this entry?", new String[0])));
        acceptAutoLinkedFile.visibleProperty().bind((ObservableValue)linkedFile.isAutomaticallyFoundProperty());
        acceptAutoLinkedFile.setOnAction(event -> linkedFile.acceptAsLinked());
        acceptAutoLinkedFile.getStyleClass().setAll((Object[])new String[]{"flatButton"});
        Button writeXMPMetadata = MaterialDesignIconFactory.get().createIconButton(MaterialDesignIcon.IMPORT);
        writeXMPMetadata.setTooltip(new Tooltip(Localization.lang("Write BibTeXEntry as XMP-metadata to PDF.", new String[0])));
        writeXMPMetadata.visibleProperty().bind((ObservableValue)linkedFile.canWriteXMPMetadataProperty());
        writeXMPMetadata.setOnAction(event -> linkedFile.writeXMPMetadata());
        writeXMPMetadata.getStyleClass().setAll((Object[])new String[]{"flatButton"});
        HBox container = new HBox(10.0);
        container.setPrefHeight(Double.NEGATIVE_INFINITY);
        if (desc.getText().isEmpty()) {
            container.getChildren().addAll((Object[])new Node[]{icon, link, progressIndicator, acceptAutoLinkedFile, writeXMPMetadata});
        } else {
            container.getChildren().addAll((Object[])new Node[]{icon, desc, link, progressIndicator, acceptAutoLinkedFile, writeXMPMetadata});
        }
        return container;
    }

    private void setUpKeyBindings() {
        this.listView.addEventFilter(KeyEvent.KEY_PRESSED, event -> {
            Optional<KeyBinding> keyBinding = Globals.getKeyPrefs().mapToKeyBinding((KeyEvent)event);
            if (keyBinding.isPresent()) {
                switch (keyBinding.get()) {
                    case DELETE_ENTRY: {
                        LinkedFileViewModel selectedItem = (LinkedFileViewModel)this.listView.getSelectionModel().getSelectedItem();
                        if (selectedItem != null) {
                            this.viewModel.deleteFile(selectedItem);
                        }
                        event.consume();
                        break;
                    }
                }
            }
        });
    }

    public LinkedFilesEditorViewModel getViewModel() {
        return this.viewModel;
    }

    @Override
    public void bindToEntry(BibEntry entry) {
        this.viewModel.bindToEntry(entry);
    }

    @Override
    public Parent getNode() {
        return this;
    }

    @FXML
    private void addNewFile(ActionEvent event) {
        this.viewModel.addNewFile();
    }

    @FXML
    private void fetchFulltext(ActionEvent event) {
        this.viewModel.fetchFulltext();
    }

    @FXML
    private void addFromURL(ActionEvent event) {
        this.viewModel.addFromURL();
    }

    private ContextMenu createContextMenuForFile(LinkedFileViewModel linkedFile) {
        ContextMenu menu = new ContextMenu();
        menu.setStyle("-fx-font-size: " + Globals.prefs.getFontSizeFX() + "pt;");
        MenuItem edit = new MenuItem(Localization.lang("Edit", new String[0]));
        edit.setOnAction(event -> linkedFile.edit());
        MenuItem openFile = new MenuItem(Localization.lang("Open", new String[0]));
        openFile.setOnAction(event -> linkedFile.open());
        MenuItem openFolder = new MenuItem(Localization.lang("Open folder", new String[0]));
        openFolder.setOnAction(event -> linkedFile.openFolder());
        MenuItem download = new MenuItem(Localization.lang("Download file", new String[0]));
        download.setOnAction(event -> linkedFile.download());
        MenuItem renameFile = new MenuItem(Localization.lang("Rename file", new String[0]));
        renameFile.setOnAction(event -> linkedFile.rename());
        renameFile.setDisable(linkedFile.getFile().isOnlineLink());
        MenuItem moveFile = new MenuItem(Localization.lang("Move file to file directory", new String[0]));
        moveFile.setOnAction(event -> linkedFile.moveToDefaultDirectory());
        moveFile.setDisable(linkedFile.getFile().isOnlineLink());
        MenuItem deleteFile = new MenuItem(Localization.lang("Permanently delete local file", new String[0]));
        deleteFile.setOnAction(event -> this.viewModel.deleteFile(linkedFile));
        deleteFile.setDisable(linkedFile.getFile().isOnlineLink());
        MenuItem deleteLink = new MenuItem(Localization.lang("Remove link", new String[0]));
        deleteLink.setOnAction(event -> this.viewModel.removeFileLink(linkedFile));
        menu.getItems().add((Object)edit);
        menu.getItems().add((Object)new SeparatorMenuItem());
        menu.getItems().addAll((Object[])new MenuItem[]{openFile, openFolder});
        menu.getItems().add((Object)new SeparatorMenuItem());
        if (linkedFile.getFile().isOnlineLink()) {
            menu.getItems().add((Object)download);
        }
        menu.getItems().addAll((Object[])new MenuItem[]{renameFile, moveFile, deleteLink, deleteFile});
        return menu;
    }

    private void handleItemMouseClick(LinkedFileViewModel linkedFile, MouseEvent event) {
        if (event.getButton().equals((Object)MouseButton.PRIMARY) && event.getClickCount() == 2) {
            linkedFile.edit();
        }
    }

    @Override
    public double getWeight() {
        return 2.0;
    }
}

