/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.groups;

import java.util.List;
import org.jabref.gui.groups.GroupTreeNodeViewModel;
import org.jabref.gui.undo.AbstractUndoableJabRefEdit;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.groups.GroupTreeNode;

class UndoableAddOrRemoveGroup
extends AbstractUndoableJabRefEdit {
    public static final int ADD_NODE = 0;
    public static final int REMOVE_NODE_KEEP_CHILDREN = 1;
    public static final int REMOVE_NODE_AND_CHILDREN = 2;
    private final GroupTreeNodeViewModel m_groupsRootHandle;
    private final GroupTreeNode m_subtreeBackup;
    private final int m_subtreeRootChildCount;
    private final List<Integer> m_pathToNode;
    private final int m_editType;

    public UndoableAddOrRemoveGroup(GroupTreeNodeViewModel groupsRoot, GroupTreeNodeViewModel editedNode, int editType) {
        this.m_groupsRootHandle = groupsRoot;
        this.m_editType = editType;
        this.m_subtreeRootChildCount = editedNode.getChildCount();
        this.m_subtreeBackup = editType != 1 ? (GroupTreeNode)editedNode.getNode().copySubtree() : GroupTreeNode.fromGroup(editedNode.getNode().getGroup().deepCopy());
        this.m_pathToNode = editedNode.getNode().getIndexedPathFromRoot();
    }

    @Override
    public String getPresentationName() {
        switch (this.m_editType) {
            case 0: {
                return Localization.lang("add group", new String[0]);
            }
            case 1: {
                return Localization.lang("remove group (keep subgroups)", new String[0]);
            }
            case 2: {
                return Localization.lang("remove group and subgroups", new String[0]);
            }
        }
        return "? (" + Localization.lang("unknown edit", new String[0]) + ")";
    }

    @Override
    public void undo() {
        super.undo();
        this.doOperation(true);
    }

    @Override
    public void redo() {
        super.redo();
        this.doOperation(false);
    }

    private void doOperation(boolean undo) {
        GroupTreeNode cursor = this.m_groupsRootHandle.getNode();
        int childIndex = this.m_pathToNode.get(this.m_pathToNode.size() - 1);
        for (int i = 0; i < this.m_pathToNode.size() - 1; ++i) {
            cursor = (GroupTreeNode)cursor.getChildAt(this.m_pathToNode.get(i)).get();
        }
        if (undo) {
            switch (this.m_editType) {
                case 0: {
                    cursor.removeChild(childIndex);
                    break;
                }
                case 1: {
                    GroupTreeNode newNode = (GroupTreeNode)this.m_subtreeBackup.copySubtree();
                    for (int i = childIndex; i < childIndex + this.m_subtreeRootChildCount; ++i) {
                        ((GroupTreeNode)cursor.getChildAt(childIndex).get()).moveTo(newNode);
                    }
                    newNode.moveTo(cursor, childIndex);
                    break;
                }
                case 2: {
                    ((GroupTreeNode)this.m_subtreeBackup.copySubtree()).moveTo(cursor, childIndex);
                    break;
                }
            }
        } else {
            switch (this.m_editType) {
                case 0: {
                    ((GroupTreeNode)this.m_subtreeBackup.copySubtree()).moveTo(cursor, childIndex);
                    break;
                }
                case 1: {
                    GroupTreeNode removedNode = (GroupTreeNode)cursor.getChildAt(childIndex).get();
                    cursor.removeChild(childIndex);
                    while (removedNode.getNumberOfChildren() > 0) {
                        ((GroupTreeNode)removedNode.getFirstChild().get()).moveTo(cursor, childIndex);
                    }
                    break;
                }
                case 2: {
                    cursor.removeChild(childIndex);
                    break;
                }
            }
        }
    }
}

